/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;

public final class SimpleGlyph
extends Glyph {
    private static final int FLAG_ONCURVE = 1;
    private static final int FLAG_XSHORT = 2;
    private static final int FLAG_YSHORT = 4;
    private static final int FLAG_REPEAT = 8;
    private static final int FLAG_XREPEATSIGN = 16;
    private static final int FLAG_YREPEATSIGN = 32;
    private int instructionSize;
    private int numberOfPoints;
    private int instructionsOffset;
    private int flagsOffset;
    private int xCoordinatesOffset;
    private int yCoordinatesOffset;
    private int flagByteCount;
    private int xByteCount;
    private int yByteCount;
    private int[] xCoordinates;
    private int[] yCoordinates;
    private boolean[] onCurve;
    private int[] contourIndex;

    SimpleGlyph(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2, Glyph.GlyphType.Simple);
    }

    private SimpleGlyph(ReadableFontData readableFontData) {
        super(readableFontData, Glyph.GlyphType.Simple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.initializationLock;
        synchronized (object) {
            int n;
            if (this.initialized) {
                return;
            }
            if (this.readFontData().length() == 0) {
                this.instructionSize = 0;
                this.numberOfPoints = 0;
                this.instructionsOffset = 0;
                this.flagsOffset = 0;
                this.xCoordinatesOffset = 0;
                this.yCoordinatesOffset = 0;
                return;
            }
            this.instructionSize = this.data.readUShort(GlyphTable.Offset.simpleEndPtsOfCountours.offset + this.numberOfContours() * FontData.DataSize.USHORT.size());
            this.instructionsOffset = GlyphTable.Offset.simpleEndPtsOfCountours.offset + (this.numberOfContours() + 1) * FontData.DataSize.USHORT.size();
            this.flagsOffset = this.instructionsOffset + this.instructionSize * FontData.DataSize.BYTE.size();
            this.numberOfPoints = this.contourEndPoint(this.numberOfContours() - 1) + 1;
            this.xCoordinates = new int[this.numberOfPoints];
            this.yCoordinates = new int[this.numberOfPoints];
            this.onCurve = new boolean[this.numberOfPoints];
            this.parseData(false);
            this.xCoordinatesOffset = this.flagsOffset + this.flagByteCount * FontData.DataSize.BYTE.size();
            this.yCoordinatesOffset = this.xCoordinatesOffset + this.xByteCount * FontData.DataSize.BYTE.size();
            this.contourIndex = new int[this.numberOfContours() + 1];
            this.contourIndex[0] = 0;
            for (n = 0; n < this.contourIndex.length - 1; ++n) {
                this.contourIndex[n + 1] = this.contourEndPoint(n) + 1;
            }
            this.parseData(true);
            n = 5 * FontData.DataSize.SHORT.size() + this.numberOfContours() * FontData.DataSize.USHORT.size() + FontData.DataSize.USHORT.size() + this.instructionSize * FontData.DataSize.BYTE.size() + this.flagByteCount * FontData.DataSize.BYTE.size() + this.xByteCount * FontData.DataSize.BYTE.size() + this.yByteCount * FontData.DataSize.BYTE.size();
            this.setPadding(this.dataLength() - n);
            this.initialized = true;
        }
    }

    private void parseData(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (n2 == 0) {
                if (((n = this.flagAsInt(n3++)) & 8) == 8) {
                    n2 = this.flagAsInt(n3++);
                }
            } else {
                --n2;
            }
            if (bl) {
                boolean bl2 = this.onCurve[i] = (n & 1) == 1;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    this.xCoordinates[i] = this.data.readUByte(this.xCoordinatesOffset + n4);
                    int n6 = i;
                    this.xCoordinates[n6] = this.xCoordinates[n6] * ((n & 0x10) == 16 ? 1 : -1);
                }
                ++n4;
            } else if ((n & 0x10) != 16) {
                if (bl) {
                    this.xCoordinates[i] = this.data.readShort(this.xCoordinatesOffset + n4);
                }
                n4 += 2;
            }
            if (bl && i > 0) {
                int n7 = i;
                this.xCoordinates[n7] = this.xCoordinates[n7] + this.xCoordinates[i - 1];
            }
            if ((n & 4) == 4) {
                if (bl) {
                    this.yCoordinates[i] = this.data.readUByte(this.yCoordinatesOffset + n5);
                    int n8 = i;
                    this.yCoordinates[n8] = this.yCoordinates[n8] * ((n & 0x20) == 32 ? 1 : -1);
                }
                ++n5;
            } else if ((n & 0x20) != 32) {
                if (bl) {
                    this.yCoordinates[i] = this.data.readShort(this.yCoordinatesOffset + n5);
                }
                n5 += 2;
            }
            if (!bl || i <= 0) continue;
            int n9 = i;
            this.yCoordinates[n9] = this.yCoordinates[n9] + this.yCoordinates[i - 1];
        }
        this.flagByteCount = n3;
        this.xByteCount = n4;
        this.yByteCount = n5;
    }

    private int flagAsInt(int n) {
        return this.data.readUByte(this.flagsOffset + n * FontData.DataSize.BYTE.size());
    }

    public int contourEndPoint(int n) {
        return this.data.readUShort(n * FontData.DataSize.USHORT.size() + GlyphTable.Offset.simpleEndPtsOfCountours.offset);
    }

    @Override
    public int instructionSize() {
        this.initialize();
        return this.instructionSize;
    }

    @Override
    public ReadableFontData instructions() {
        this.initialize();
        return this.data.slice(this.instructionsOffset, this.instructionSize());
    }

    public int numberOfPoints(int n) {
        this.initialize();
        if (n >= this.numberOfContours()) {
            return 0;
        }
        return this.contourIndex[n + 1] - this.contourIndex[n];
    }

    public int xCoordinate(int n, int n2) {
        this.initialize();
        return this.xCoordinates[this.contourIndex[n] + n2];
    }

    public int yCoordinate(int n, int n2) {
        this.initialize();
        return this.yCoordinates[this.contourIndex[n] + n2];
    }

    public boolean onCurve(int n, int n2) {
        this.initialize();
        return this.onCurve[this.contourIndex[n] + n2];
    }

    @Override
    public String toString() {
        this.initialize();
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\tinstruction bytes = " + this.instructionSize() + "\n");
        for (int i = 0; i < this.numberOfContours(); ++i) {
            for (int j = 0; j < this.numberOfPoints(i); ++j) {
                stringBuilder.append("\t" + i + ":" + j + " = [" + this.xCoordinate(i, j) + ", " + this.yCoordinate(i, j) + ", " + this.onCurve(i, j) + "]\n");
            }
        }
        return stringBuilder.toString();
    }

    public static class SimpleGlyphBuilder
    extends Glyph.Builder<SimpleGlyph> {
        protected SimpleGlyphBuilder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData.slice(n, n2));
        }

        protected SimpleGlyphBuilder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData.slice(n, n2));
        }

        @Override
        protected SimpleGlyph subBuildTable(ReadableFontData readableFontData) {
            return new SimpleGlyph(readableFontData, 0, readableFontData.length());
        }
    }

    public static final class SimpleContour
    extends Glyph.Contour {
        protected SimpleContour() {
        }
    }
}

