/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import java.util.ArrayList;
import java.util.List;

public final class GlyphTable
extends SubTableContainerTable {
    private GlyphTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public Glyph glyph(int n, int n2) {
        return Glyph.getGlyph(this, this.data, n, n2);
    }

    public static class Builder
    extends SubTableContainerTable.Builder<GlyphTable> {
        private List<Glyph.Builder<? extends Glyph>> glyphBuilders;
        private List<Integer> loca;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        public void setLoca(List<Integer> list) {
            this.loca = new ArrayList<Integer>(list);
            this.setModelChanged(false);
            this.glyphBuilders = null;
        }

        public List<Integer> generateLocaList() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getGlyphBuilders().size());
            arrayList.add(0);
            if (this.getGlyphBuilders().size() == 0) {
                arrayList.add(0);
            } else {
                int n = 0;
                for (Glyph.Builder<? extends Glyph> builder : this.getGlyphBuilders()) {
                    int n2 = builder.subDataSizeToSerialize();
                    arrayList.add(n + n2);
                    n += n2;
                }
            }
            return arrayList;
        }

        private void initialize(ReadableFontData readableFontData, List<Integer> list) {
            this.glyphBuilders = new ArrayList<Glyph.Builder<? extends Glyph>>();
            if (readableFontData != null) {
                int n = list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    int n2 = list.get(i);
                    this.glyphBuilders.add(Glyph.Builder.getBuilder(this, readableFontData, n, n2 - n));
                    n = n2;
                }
            }
        }

        private List<Glyph.Builder<? extends Glyph>> getGlyphBuilders() {
            if (this.glyphBuilders == null) {
                if (this.internalReadData() != null && this.loca == null) {
                    throw new IllegalStateException("Loca values not set - unable to parse glyph data.");
                }
                this.initialize(this.internalReadData(), this.loca);
                this.setModelChanged();
            }
            return this.glyphBuilders;
        }

        public void revert() {
            this.glyphBuilders = null;
            this.setModelChanged(false);
        }

        public List<Glyph.Builder<? extends Glyph>> glyphBuilders() {
            return this.getGlyphBuilders();
        }

        public void setGlyphBuilders(List<Glyph.Builder<? extends Glyph>> list) {
            this.glyphBuilders = list;
            this.setModelChanged();
        }

        public Glyph.Builder<? extends Glyph> glyphBuilder(ReadableFontData readableFontData) {
            Glyph.Builder<Glyph> builder = Glyph.Builder.getBuilder(this, readableFontData);
            return builder;
        }

        @Override
        protected GlyphTable subBuildTable(ReadableFontData readableFontData) {
            return new GlyphTable(this.header(), readableFontData);
        }

        @Override
        protected void subDataSet() {
            this.glyphBuilders = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.glyphBuilders == null || this.glyphBuilders.size() == 0) {
                return 0;
            }
            boolean bl = false;
            int n = 0;
            for (Glyph.Builder<? extends Glyph> builder : this.glyphBuilders) {
                int n2 = builder.subDataSizeToSerialize();
                n += Math.abs(n2);
                bl |= n2 <= 0;
            }
            return bl ? -n : n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.glyphBuilders != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = 0;
            for (Glyph.Builder<? extends Glyph> builder : this.glyphBuilders) {
                n += builder.subSerialize(writableFontData.slice(n));
            }
            return n;
        }
    }

    public static enum Offset {
        numberOfContours(0),
        xMin(2),
        yMin(4),
        xMax(6),
        yMax(8),
        simpleEndPtsOfCountours(10),
        simpleInstructionLength(0),
        simpleInstructions(2),
        compositeFlags(0),
        compositeGyphIndexWithoutFlag(0),
        compositeGlyphIndexWithFlag(2);

        final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

