/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public final class HorizontalMetricsTable
extends Table {
    private int numHMetrics;
    private int numGlyphs;

    private HorizontalMetricsTable(Header header, ReadableFontData readableFontData, int n, int n2) {
        super(header, readableFontData);
        this.numHMetrics = n;
        this.numGlyphs = n2;
    }

    public int numberOfHMetrics() {
        return this.numHMetrics;
    }

    public int numberOfLSBs() {
        return this.numGlyphs - this.numHMetrics;
    }

    public int hMetricAdvanceWidth(int n) {
        if (n > this.numHMetrics) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = Offset.hMetricsStart.offset + n * Offset.hMetricsSize.offset + Offset.hMetricsAdvanceWidth.offset;
        return this.data.readUShort(n2);
    }

    public int hMetricLSB(int n) {
        if (n > this.numHMetrics) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = Offset.hMetricsStart.offset + n * Offset.hMetricsSize.offset + Offset.hMetricsLeftSideBearing.offset;
        return this.data.readShort(n2);
    }

    public int lsbTableEntry(int n) {
        if (n > this.numberOfLSBs()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = Offset.hMetricsStart.offset + this.numHMetrics * Offset.hMetricsSize.offset + n * Offset.LeftSideBearingSize.offset;
        return this.data.readShort(n2);
    }

    public int advanceWidth(int n) {
        if (n < this.numHMetrics) {
            return this.hMetricAdvanceWidth(n);
        }
        return this.hMetricAdvanceWidth(this.numHMetrics - 1);
    }

    public int leftSideBearing(int n) {
        if (n < this.numHMetrics) {
            return this.hMetricLSB(n);
        }
        return this.lsbTableEntry(n - this.numHMetrics);
    }

    public static class Builder
    extends TableBasedTableBuilder<HorizontalMetricsTable> {
        private int numHMetrics = -1;
        private int numGlyphs = -1;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        @Override
        protected HorizontalMetricsTable subBuildTable(ReadableFontData readableFontData) {
            return new HorizontalMetricsTable(this.header(), readableFontData, this.numHMetrics, this.numGlyphs);
        }

        public void setNumberOfHMetrics(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Number of metrics can't be negative.");
            }
            this.numHMetrics = n;
            ((HorizontalMetricsTable)this.table()).numHMetrics = n;
        }

        public void setNumGlyphs(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Number of glyphs can't be negative.");
            }
            this.numGlyphs = n;
            ((HorizontalMetricsTable)this.table()).numGlyphs = n;
        }
    }

    private static enum Offset {
        hMetricsStart(0),
        hMetricsSize(4),
        hMetricsAdvanceWidth(0),
        hMetricsLeftSideBearing(2),
        LeftSideBearingSize(2);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

