/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public class HorizontalDeviceMetricsTable
extends Table {
    private int numGlyphs;

    private HorizontalDeviceMetricsTable(Header header, ReadableFontData readableFontData, int n) {
        super(header, readableFontData);
        this.numGlyphs = n;
    }

    public int version() {
        return this.data.readUShort(Offset.version.offset);
    }

    public int numRecords() {
        return this.data.readShort(Offset.numRecords.offset);
    }

    public int recordSize() {
        return this.data.readLong(Offset.sizeDeviceRecord.offset);
    }

    public int pixelSize(int n) {
        if (n < 0 || n >= this.numRecords()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + n * this.recordSize() + Offset.deviceRecordPixelSize.offset);
    }

    public int maxWidth(int n) {
        if (n < 0 || n >= this.numRecords()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + n * this.recordSize() + Offset.deviceRecordMaxWidth.offset);
    }

    public int width(int n, int n2) {
        if (n < 0 || n >= this.numRecords() || n2 < 0 || n2 >= this.numGlyphs) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + n * this.recordSize() + Offset.deviceRecordWidths.offset + n2);
    }

    public static class Builder
    extends TableBasedTableBuilder<HorizontalDeviceMetricsTable> {
        private int numGlyphs = -1;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        @Override
        protected HorizontalDeviceMetricsTable subBuildTable(ReadableFontData readableFontData) {
            return new HorizontalDeviceMetricsTable(this.header(), readableFontData, this.numGlyphs);
        }

        public void setNumGlyphs(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Number of glyphs can't be negative.");
            }
            this.numGlyphs = n;
            ((HorizontalDeviceMetricsTable)this.table()).numGlyphs = n;
        }
    }

    private static enum Offset {
        version(0),
        numRecords(2),
        sizeDeviceRecord(4),
        records(8),
        deviceRecordPixelSize(0),
        deviceRecordMaxWidth(1),
        deviceRecordWidths(2);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

