/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.core.CMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class CMapTable
extends SubTableContainerTable
implements Iterable<CMap> {
    public static final int NOTDEF = 0;

    private CMapTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int version() {
        return this.data.readUShort(Offset.version.offset);
    }

    public int numCMaps() {
        return this.data.readUShort(Offset.numTables.offset);
    }

    private static int offsetForEncodingRecord(int n) {
        return Offset.encodingRecordStart.offset + n * Offset.encodingRecordSize.offset;
    }

    public CMapId cmapId(int n) {
        return CMapId.getInstance(this.platformId(n), this.encodingId(n));
    }

    public int platformId(int n) {
        return this.data.readUShort(Offset.encodingRecordPlatformId.offset + CMapTable.offsetForEncodingRecord(n));
    }

    public int encodingId(int n) {
        return this.data.readUShort(Offset.encodingRecordEncodingId.offset + CMapTable.offsetForEncodingRecord(n));
    }

    public int offset(int n) {
        return this.data.readULongAsInt(Offset.encodingRecordOffset.offset + CMapTable.offsetForEncodingRecord(n));
    }

    @Override
    public Iterator<CMap> iterator() {
        return new CMapIterator();
    }

    public Iterator<CMap> iterator(CMapFilter cMapFilter) {
        return new CMapIterator(cMapFilter);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" = { ");
        for (int i = 0; i < this.numCMaps(); ++i) {
            CMap cMap;
            try {
                cMap = this.cmap(i);
            }
            catch (IOException iOException) {
                continue;
            }
            stringBuilder.append("[0x");
            stringBuilder.append(Integer.toHexString(this.offset(i)));
            stringBuilder.append(" = ");
            stringBuilder.append(cMap);
            if (i < this.numCMaps() - 1) {
                stringBuilder.append("], ");
                continue;
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public CMap cmap(int n) throws IOException {
        CMap.Builder<? extends CMap> builder = Builder.cmapBuilder(this.readFontData(), n);
        return (CMap)builder.build();
    }

    public CMap cmap(int n, int n2) {
        return this.cmap(CMapId.getInstance(n, n2));
    }

    public CMap cmap(final CMapId cMapId) {
        Iterator<CMap> iterator = this.iterator(new CMapFilter(){

            @Override
            public boolean accept(CMapId cMapId2) {
                return cMapId.equals(cMapId2);
            }
        });
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static class Builder
    extends SubTableContainerTable.Builder<CMapTable> {
        private int version = 0;
        private Map<CMapId, CMap.Builder<? extends CMap>> cmapBuilders;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        protected static CMap.Builder<? extends CMap> cmapBuilder(ReadableFontData readableFontData, int n) {
            if (n < 0 || n > Builder.numCMaps(readableFontData)) {
                throw new IndexOutOfBoundsException("CMap table is outside the bounds of the known tables.");
            }
            int n2 = readableFontData.readUShort(Offset.encodingRecordPlatformId.offset + CMapTable.offsetForEncodingRecord(n));
            int n3 = readableFontData.readUShort(Offset.encodingRecordEncodingId.offset + CMapTable.offsetForEncodingRecord(n));
            int n4 = readableFontData.readULongAsInt(Offset.encodingRecordOffset.offset + CMapTable.offsetForEncodingRecord(n));
            CMapId cMapId = CMapId.getInstance(n2, n3);
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(readableFontData, n4, cMapId);
            return builder;
        }

        @Override
        protected void subDataSet() {
            this.cmapBuilders = null;
            super.setModelChanged(false);
        }

        private void initialize(ReadableFontData readableFontData) {
            this.cmapBuilders = new HashMap<CMapId, CMap.Builder<? extends CMap>>();
            int n = Builder.numCMaps(readableFontData);
            for (int i = 0; i < n; ++i) {
                CMap.Builder<? extends CMap> builder = Builder.cmapBuilder(readableFontData, i);
                this.cmapBuilders.put(builder.cmapId(), builder);
            }
        }

        private Map<CMapId, CMap.Builder<? extends CMap>> getCMapBuilders() {
            if (this.cmapBuilders != null) {
                return this.cmapBuilders;
            }
            this.initialize(this.internalReadData());
            this.setModelChanged();
            return this.cmapBuilders;
        }

        private static int numCMaps(ReadableFontData readableFontData) {
            if (readableFontData == null) {
                return 0;
            }
            return readableFontData.readUShort(Offset.numTables.offset);
        }

        public int numCMaps() {
            return this.getCMapBuilders().size();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.cmapBuilders == null || this.cmapBuilders.size() == 0) {
                return 0;
            }
            boolean bl = false;
            int n = Offset.encodingRecordStart.offset + this.cmapBuilders.size() * Offset.encodingRecordSize.offset;
            for (CMap.Builder<? extends CMap> builder : this.cmapBuilders.values()) {
                int n2 = builder.subDataSizeToSerialize();
                n += Math.abs(n2);
                bl |= n2 <= 0;
            }
            return bl ? -n : n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (this.cmapBuilders == null) {
                return false;
            }
            for (CMap.Builder<? extends CMap> builder : this.cmapBuilders.values()) {
                if (builder.subReadyToSerialize()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = writableFontData.writeUShort(Offset.version.offset, this.version());
            int n2 = n += writableFontData.writeUShort(Offset.numTables.offset, this.cmapBuilders.size());
            n += this.cmapBuilders.size() * Offset.encodingRecordSize.offset;
            for (CMap.Builder<? extends CMap> builder : this.cmapBuilders.values()) {
                n2 += writableFontData.writeUShort(n2, builder.platformId());
                n2 += writableFontData.writeUShort(n2, builder.encodingId());
                n2 += writableFontData.writeULong(n2, n);
                n += builder.subSerialize(writableFontData.slice(n));
            }
            return n;
        }

        @Override
        protected CMapTable subBuildTable(ReadableFontData readableFontData) {
            return new CMapTable(this.header(), readableFontData);
        }

        public Iterator<? extends CMap.Builder<? extends CMap>> iterator() {
            return this.getCMapBuilders().values().iterator();
        }

        public int version() {
            return this.version;
        }

        public void setVersion(int n) {
            this.version = n;
        }

        public CMap.Builder<? extends CMap> newCMapBuilder(CMapId cMapId, ReadableFontData readableFontData) throws IOException {
            WritableFontData writableFontData = WritableFontData.createWritableFontData(readableFontData.size());
            readableFontData.copyTo(writableFontData);
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(writableFontData, 0, cMapId);
            Map<CMapId, CMap.Builder<? extends CMap>> map = this.getCMapBuilders();
            map.put(cMapId, builder);
            return builder;
        }

        public CMap.Builder<? extends CMap> newCMapBuilder(CMapId cMapId, CMap.CMapFormat cMapFormat) {
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(cMapFormat, cMapId);
            Map<CMapId, CMap.Builder<? extends CMap>> map = this.getCMapBuilders();
            map.put(cMapId, builder);
            return builder;
        }

        public CMap.Builder<? extends CMap> cmapBuilder(CMapId cMapId) {
            Map<CMapId, CMap.Builder<? extends CMap>> map = this.getCMapBuilders();
            return map.get(cMapId);
        }
    }

    private class CMapIterator
    implements Iterator<CMap> {
        private int tableIndex = 0;
        private CMapFilter filter;

        private CMapIterator() {
        }

        private CMapIterator(CMapFilter cMapFilter) {
            this.filter = cMapFilter;
        }

        @Override
        public boolean hasNext() {
            if (this.filter == null) {
                return this.tableIndex < CMapTable.this.numCMaps();
            }
            while (this.tableIndex < CMapTable.this.numCMaps()) {
                if (this.filter.accept(CMapTable.this.cmapId(this.tableIndex))) {
                    return true;
                }
                ++this.tableIndex;
            }
            return false;
        }

        @Override
        public CMap next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CMapTable.this.cmap(this.tableIndex++);
            }
            catch (IOException iOException) {
                NoSuchElementException noSuchElementException = new NoSuchElementException("Error during the creation of the CMap.");
                noSuchElementException.initCause(iOException);
                throw noSuchElementException;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a CMap table from an existing font.");
        }
    }

    public static interface CMapFilter {
        public boolean accept(CMapId var1);
    }

    public static final class CMapId
    implements Comparable<CMapId> {
        public static final CMapId WINDOWS_BMP = CMapId.getInstance(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value());
        public static final CMapId WINDOWS_UCS4 = CMapId.getInstance(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        public static final CMapId MAC_ROMAN = CMapId.getInstance(Font.PlatformId.Macintosh.value(), Font.MacintoshEncodingId.Roman.value());
        private final int platformId;
        private final int encodingId;

        public static CMapId getInstance(int n, int n2) {
            return new CMapId(n, n2);
        }

        private CMapId(int n, int n2) {
            this.platformId = n;
            this.encodingId = n2;
        }

        public int platformId() {
            return this.platformId;
        }

        public int encodingId() {
            return this.encodingId;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CMapId)) {
                return false;
            }
            CMapId cMapId = (CMapId)object;
            return cMapId.platformId == this.platformId && cMapId.encodingId == this.encodingId;
        }

        public int hashCode() {
            return this.platformId << 8 | this.encodingId;
        }

        @Override
        public int compareTo(CMapId cMapId) {
            return this.hashCode() - cMapId.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("pid = ");
            stringBuilder.append(this.platformId);
            stringBuilder.append(", eid = ");
            stringBuilder.append(this.encodingId);
            return stringBuilder.toString();
        }
    }

    static enum Offset {
        version(0),
        numTables(2),
        encodingRecordStart(4),
        encodingRecordPlatformId(0),
        encodingRecordEncodingId(2),
        encodingRecordOffset(4),
        encodingRecordSize(8),
        format(0),
        format0Format(0),
        format0Length(2),
        format0Language(4),
        format0GlyphIdArray(6),
        format2Format(0),
        format2Length(2),
        format2Language(4),
        format2SubHeaderKeys(6),
        format2SubHeaders(518),
        format2SubHeader_firstCode(0),
        format2SubHeader_entryCount(2),
        format2SubHeader_idDelta(4),
        format2SubHeader_idRangeOffset(6),
        format2SubHeader_structLength(8),
        format4Format(0),
        format4Length(2),
        format4Language(4),
        format4SegCountX2(6),
        format4SearchRange(8),
        format4EntrySelector(10),
        format4RangeShift(12),
        format4EndCount(14),
        format4FixedSize(16),
        format6Format(0),
        format6Length(2),
        format6Language(4),
        format6FirstCode(6),
        format6EntryCount(8),
        format6GlyphIdArray(10),
        format8Format(0),
        format8Length(4),
        format8Language(8),
        format8Is32(12),
        format8nGroups(8204),
        format8Groups(8208),
        format8Group_startCharCode(0),
        format8Group_endCharCode(4),
        format8Group_startGlyphId(8),
        format8Group_structLength(12),
        format10Format(0),
        format10Length(4),
        format10Language(8),
        format10StartCharCode(12),
        format10NumChars(16),
        format10Glyphs(20),
        format12Format(0),
        format12Length(4),
        format12Language(8),
        format12nGroups(12),
        format12Groups(16),
        format12Groups_structLength(12),
        format12_startCharCode(0),
        format12_endCharCode(4),
        format12_startGlyphId(8),
        format13Format(0),
        format13Length(4),
        format13Language(8),
        format13nGroups(12),
        format13Groups(16),
        format13Groups_structLength(12),
        format13_startCharCode(0),
        format13_endCharCode(4),
        format13_glyphId(8),
        format14Format(0),
        format14Length(2);

        final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

