/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat6
extends CMap {
    private final int firstCode;
    private final int entryCount;

    protected CMapFormat6(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format6.value, cMapId);
        this.firstCode = this.data.readUShort(CMapTable.Offset.format6FirstCode.offset);
        this.entryCount = this.data.readUShort(CMapTable.Offset.format6EntryCount.offset);
    }

    @Override
    public int glyphId(int n) {
        if (n < this.firstCode || n >= this.firstCode + this.entryCount) {
            return 0;
        }
        return this.data.readUShort(CMapTable.Offset.format6GlyphIdArray.offset + (n - this.firstCode) * FontData.DataSize.USHORT.size());
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format6Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat6> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readUShort(n + CMapTable.Offset.format6Length.offset)), CMap.CMapFormat.Format6, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readUShort(n + CMapTable.Offset.format6Length.offset)), CMap.CMapFormat.Format6, cMapId);
        }

        @Override
        protected CMapFormat6 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat6(readableFontData, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int character;

        private CharacterIterator() {
            this.character = CMapFormat6.this.firstCode;
        }

        @Override
        public boolean hasNext() {
            return this.character < CMapFormat6.this.firstCode + CMapFormat6.this.entryCount;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

