/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BigGlyphMetrics;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat2
extends IndexSubTable {
    private final int imageSize;

    private IndexSubTableFormat2(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2);
        this.imageSize = this.data.readULongAsInt(EblcTable.Offset.indexSubTable2_imageSize.offset);
    }

    public int imageSize() {
        return this.data.readULongAsInt(EblcTable.Offset.indexSubTable2_imageSize.offset);
    }

    public BigGlyphMetrics bigMetrics() {
        return new BigGlyphMetrics(this.data.slice(EblcTable.Offset.indexSubTable2_bigGlyphMetrics.offset, BigGlyphMetrics.Offset.metricsLength.offset));
    }

    @Override
    public int numGlyphs() {
        return this.lastGlyphIndex() - this.firstGlyphIndex() + 1;
    }

    @Override
    public int glyphStartOffset(int n) {
        int n2 = this.checkGlyphRange(n);
        return n2 * this.imageSize;
    }

    @Override
    public int glyphLength(int n) {
        this.checkGlyphRange(n);
        return this.imageSize;
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat2> {
        private BigGlyphMetrics.Builder metrics;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(readableFontData, n, n2, n3);
            return new Builder(readableFontData.slice(n, n4), n2, n3);
        }

        static Builder createBuilder(WritableFontData writableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(writableFontData, n, n2, n3);
            return new Builder(writableFontData.slice(n, n4), n2, n3);
        }

        private static int dataLength(ReadableFontData readableFontData, int n, int n2, int n3) {
            return EblcTable.Offset.indexSubTable2Length.offset;
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable2_builderDataSize.offset, 2);
            this.metrics = BigGlyphMetrics.Builder.createBuilder();
        }

        private Builder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData, n, n2);
        }

        private Builder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData, n, n2);
        }

        @Override
        public int numGlyphs() {
            return this.lastGlyphIndex() - this.firstGlyphIndex() + 1;
        }

        @Override
        public int glyphStartOffset(int n) {
            int n2 = super.checkGlyphRange(n);
            return n2 * this.imageSize();
        }

        @Override
        public int glyphLength(int n) {
            super.checkGlyphRange(n);
            return this.imageSize();
        }

        public int imageSize() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.indexSubTable2_imageSize.offset);
        }

        public void setImageSize(int n) {
            this.internalWriteData().writeULong(EblcTable.Offset.indexSubTable2_imageSize.offset, n);
        }

        public BigGlyphMetrics.Builder bigMetrics() {
            if (this.metrics == null) {
                WritableFontData writableFontData = this.internalWriteData().slice(EblcTable.Offset.indexSubTable2_bigGlyphMetrics.offset, BigGlyphMetrics.Offset.metricsLength.offset);
                this.metrics = new BigGlyphMetrics.Builder(writableFontData);
            }
            return this.metrics;
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected IndexSubTableFormat2 subBuildTable(ReadableFontData readableFontData) {
            return new IndexSubTableFormat2(readableFontData, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            return EblcTable.Offset.indexSubTable2Length.offset;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = super.serializeIndexSubHeader(writableFontData);
            if (this.metrics == null) {
                n += this.internalReadData().slice(n).copyTo(writableFontData.slice(n));
            } else {
                n += writableFontData.writeLong(EblcTable.Offset.indexSubTable2_imageSize.offset, this.imageSize());
                n += this.metrics.subSerialize(writableFontData.slice(n));
            }
            return n;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int glyphId;

            public BitmapGlyphInfoIterator() {
                this.glyphId = Builder.this.firstGlyphIndex();
            }

            @Override
            public boolean hasNext() {
                return this.glyphId <= Builder.this.lastGlyphIndex();
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                BitmapGlyphInfo bitmapGlyphInfo = new BitmapGlyphInfo(this.glyphId, Builder.this.imageDataOffset(), Builder.this.glyphStartOffset(this.glyphId), Builder.this.glyphLength(this.glyphId), Builder.this.imageFormat());
                ++this.glyphId;
                return bitmapGlyphInfo;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

