/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.math.FontMath;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class BitmapSizeTable
extends SubTable {
    private static final boolean USE_BINARY_SEARCH = false;
    private final Object indexSubTablesLock = new Object();
    private volatile List<IndexSubTable> indexSubTables = null;

    protected BitmapSizeTable(ReadableFontData readableFontData, ReadableFontData readableFontData2) {
        super(readableFontData, readableFontData2);
    }

    public int indexSubTableArrayOffset() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset);
    }

    public int indexTableSize() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset);
    }

    private static int numberOfIndexSubTables(ReadableFontData readableFontData, int n) {
        return readableFontData.readULongAsInt(n + EblcTable.Offset.bitmapSizeTable_numberOfIndexSubTables.offset);
    }

    public int numberOfIndexSubTables() {
        return BitmapSizeTable.numberOfIndexSubTables(this.data, 0);
    }

    public int colorRef() {
        return this.data.readULongAsInt(EblcTable.Offset.bitmapSizeTable_colorRef.offset);
    }

    public void hori() {
    }

    public void vert() {
    }

    public int startGlyphIndex() {
        return this.data.readUShort(EblcTable.Offset.bitmapSizeTable_startGlyphIndex.offset);
    }

    public int endGlyphIndex() {
        return this.data.readUShort(EblcTable.Offset.bitmapSizeTable_endGlyphIndex.offset);
    }

    public int ppemX() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_ppemX.offset);
    }

    public int ppemY() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_ppemY.offset);
    }

    public int bitDepth() {
        return this.data.readByte(EblcTable.Offset.bitmapSizeTable_bitDepth.offset);
    }

    public int flagsAsInt() {
        return this.data.readChar(EblcTable.Offset.bitmapSizeTable_flags.offset);
    }

    public IndexSubTable indexSubTable(int n) {
        List<IndexSubTable> list = this.getIndexSubTableList();
        return list.get(n);
    }

    public BitmapGlyphInfo glyphInfo(int n) {
        IndexSubTable indexSubTable = this.searchIndexSubTables(n);
        if (indexSubTable == null) {
            return null;
        }
        return indexSubTable.glyphInfo(n);
    }

    public int glyphOffset(int n) {
        IndexSubTable indexSubTable = this.searchIndexSubTables(n);
        if (indexSubTable == null) {
            return -1;
        }
        return indexSubTable.glyphOffset(n);
    }

    public int glyphLength(int n) {
        IndexSubTable indexSubTable = this.searchIndexSubTables(n);
        if (indexSubTable == null) {
            return -1;
        }
        return indexSubTable.glyphLength(n);
    }

    public int glyphFormat(int n) {
        IndexSubTable indexSubTable = this.searchIndexSubTables(n);
        if (indexSubTable == null) {
            return -1;
        }
        return indexSubTable.imageFormat();
    }

    private IndexSubTable searchIndexSubTables(int n) {
        return this.linearSearchIndexSubTables(n);
    }

    private IndexSubTable linearSearchIndexSubTables(int n) {
        for (IndexSubTable indexSubTable : this.getIndexSubTableList()) {
            if (indexSubTable.firstGlyphIndex() > n || indexSubTable.lastGlyphIndex() < n) continue;
            return indexSubTable;
        }
        return null;
    }

    private IndexSubTable binarySearchIndexSubTables(int n) {
        List<IndexSubTable> list = this.getIndexSubTableList();
        int n2 = 0;
        int n3 = 0;
        int n4 = list.size();
        while (n4 != n3) {
            n2 = (n4 + n3) / 2;
            IndexSubTable indexSubTable = list.get(n2);
            if (n < indexSubTable.firstGlyphIndex()) {
                n4 = n2;
                continue;
            }
            if (n <= indexSubTable.lastGlyphIndex()) {
                return indexSubTable;
            }
            n3 = n2 + 1;
        }
        return null;
    }

    private IndexSubTable createIndexSubTable(int n) {
        return IndexSubTable.createIndexSubTable(this.masterReadData(), this.indexSubTableArrayOffset(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexSubTable> getIndexSubTableList() {
        if (this.indexSubTables == null) {
            Object object = this.indexSubTablesLock;
            synchronized (object) {
                if (this.indexSubTables == null) {
                    ArrayList<IndexSubTable> arrayList = new ArrayList<IndexSubTable>(this.numberOfIndexSubTables());
                    for (int i = 0; i < this.numberOfIndexSubTables(); ++i) {
                        arrayList.add(this.createIndexSubTable(i));
                    }
                    this.indexSubTables = arrayList;
                }
            }
        }
        return this.indexSubTables;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BitmapSizeTable: ");
        List<IndexSubTable> list = this.getIndexSubTableList();
        stringBuilder.append("[s=0x");
        stringBuilder.append(Integer.toHexString(this.startGlyphIndex()));
        stringBuilder.append(", e=0x");
        stringBuilder.append(Integer.toHexString(this.endGlyphIndex()));
        stringBuilder.append(", ppemx=");
        stringBuilder.append(this.ppemX());
        stringBuilder.append(", index subtables count=");
        stringBuilder.append(this.numberOfIndexSubTables());
        stringBuilder.append("]");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("\n\t");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(list.get(i));
            stringBuilder.append(", ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static final class Builder
    extends SubTable.Builder<BitmapSizeTable> {
        List<IndexSubTable.Builder<? extends IndexSubTable>> indexSubTables;

        static Builder createBuilder(WritableFontData writableFontData, ReadableFontData readableFontData) {
            return new Builder(writableFontData, readableFontData);
        }

        static Builder createBuilder(ReadableFontData readableFontData, ReadableFontData readableFontData2) {
            return new Builder(readableFontData, readableFontData2);
        }

        private Builder(WritableFontData writableFontData, ReadableFontData readableFontData) {
            super(writableFontData, readableFontData);
        }

        private Builder(ReadableFontData readableFontData, ReadableFontData readableFontData2) {
            super(readableFontData, readableFontData2);
        }

        public int indexSubTableArrayOffset() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset);
        }

        void setIndexSubTableArrayOffset(int n) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_indexSubTableArrayOffset.offset, n);
        }

        public int indexTableSize() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset);
        }

        void setIndexTableSize(int n) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_indexTableSize.offset, n);
        }

        public int numberOfIndexSubTables() {
            return this.getIndexSubTableBuilders().size();
        }

        private void setNumberOfIndexSubTables(int n) {
            this.internalWriteData().writeULong(EblcTable.Offset.bitmapSizeTable_numberOfIndexSubTables.offset, n);
        }

        public int colorRef() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.bitmapSizeTable_colorRef.offset);
        }

        public void hori() {
        }

        public void vert() {
        }

        public int startGlyphIndex() {
            return this.internalReadData().readUShort(EblcTable.Offset.bitmapSizeTable_startGlyphIndex.offset);
        }

        public int endGlyphIndex() {
            return this.internalReadData().readUShort(EblcTable.Offset.bitmapSizeTable_endGlyphIndex.offset);
        }

        public int ppemX() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_ppemX.offset);
        }

        public int ppemY() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_ppemY.offset);
        }

        public int bitDepth() {
            return this.internalReadData().readByte(EblcTable.Offset.bitmapSizeTable_bitDepth.offset);
        }

        public int flagsAsInt() {
            return this.internalReadData().readChar(EblcTable.Offset.bitmapSizeTable_flags.offset);
        }

        public IndexSubTable.Builder<? extends IndexSubTable> indexSubTableBuilder(int n) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> list = this.getIndexSubTableBuilders();
            return list.get(n);
        }

        public BitmapGlyphInfo glyphInfo(int n) {
            IndexSubTable.Builder<? extends IndexSubTable> builder = this.searchIndexSubTables(n);
            if (builder == null) {
                return null;
            }
            return builder.glyphInfo(n);
        }

        public int glyphOffset(int n) {
            IndexSubTable.Builder<? extends IndexSubTable> builder = this.searchIndexSubTables(n);
            if (builder == null) {
                return -1;
            }
            return builder.glyphOffset(n);
        }

        public int glyphLength(int n) {
            IndexSubTable.Builder<? extends IndexSubTable> builder = this.searchIndexSubTables(n);
            if (builder == null) {
                return -1;
            }
            return builder.glyphLength(n);
        }

        public int glyphFormat(int n) {
            IndexSubTable.Builder<? extends IndexSubTable> builder = this.searchIndexSubTables(n);
            if (builder == null) {
                return -1;
            }
            return builder.imageFormat();
        }

        public List<IndexSubTable.Builder<? extends IndexSubTable>> indexSubTableBuilders() {
            return this.getIndexSubTableBuilders();
        }

        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        protected void revert() {
            this.indexSubTables = null;
            this.setModelChanged(false);
        }

        public Map<Integer, BitmapGlyphInfo> generateLocaMap() {
            HashMap<Integer, BitmapGlyphInfo> hashMap = new HashMap<Integer, BitmapGlyphInfo>();
            Iterator<BitmapGlyphInfo> iterator = this.iterator();
            while (iterator.hasNext()) {
                BitmapGlyphInfo bitmapGlyphInfo = iterator.next();
                hashMap.put(bitmapGlyphInfo.glyphId(), bitmapGlyphInfo);
            }
            return hashMap;
        }

        private IndexSubTable.Builder<? extends IndexSubTable> searchIndexSubTables(int n) {
            return this.linearSearchIndexSubTables(n);
        }

        private IndexSubTable.Builder<? extends IndexSubTable> linearSearchIndexSubTables(int n) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> list = this.getIndexSubTableBuilders();
            for (IndexSubTable.Builder<? extends IndexSubTable> builder : list) {
                if (builder.firstGlyphIndex() > n || builder.lastGlyphIndex() < n) continue;
                return builder;
            }
            return null;
        }

        private IndexSubTable.Builder<? extends IndexSubTable> binarySearchIndexSubTables(int n) {
            List<IndexSubTable.Builder<? extends IndexSubTable>> list = this.getIndexSubTableBuilders();
            int n2 = 0;
            int n3 = 0;
            int n4 = list.size();
            while (n4 != n3) {
                n2 = (n4 + n3) / 2;
                IndexSubTable.Builder<? extends IndexSubTable> builder = list.get(n2);
                if (n < builder.firstGlyphIndex()) {
                    n4 = n2;
                    continue;
                }
                if (n <= builder.lastGlyphIndex()) {
                    return builder;
                }
                n3 = n2 + 1;
            }
            return null;
        }

        private List<IndexSubTable.Builder<? extends IndexSubTable>> getIndexSubTableBuilders() {
            if (this.indexSubTables == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.indexSubTables;
        }

        private void initialize(ReadableFontData readableFontData) {
            if (this.indexSubTables == null) {
                this.indexSubTables = new ArrayList<IndexSubTable.Builder<? extends IndexSubTable>>();
            } else {
                this.indexSubTables.clear();
            }
            if (readableFontData != null) {
                int n = BitmapSizeTable.numberOfIndexSubTables(readableFontData, 0);
                for (int i = 0; i < n; ++i) {
                    this.indexSubTables.add(this.createIndexSubTableBuilder(i));
                }
            }
        }

        private IndexSubTable.Builder<? extends IndexSubTable> createIndexSubTableBuilder(int n) {
            return IndexSubTable.Builder.createBuilder(this.masterReadData(), this.indexSubTableArrayOffset(), n);
        }

        @Override
        protected BitmapSizeTable subBuildTable(ReadableFontData readableFontData) {
            return new BitmapSizeTable(readableFontData, this.masterReadData());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.indexSubTableBuilders() == null) {
                return 0;
            }
            int n = EblcTable.Offset.bitmapSizeTableLength.offset;
            boolean bl = false;
            for (IndexSubTable.Builder<? extends IndexSubTable> builder : this.indexSubTables) {
                n += EblcTable.Offset.indexSubTableEntryLength.offset;
                int n2 = builder.subDataSizeToSerialize();
                int n3 = FontMath.paddingRequired(Math.abs(n2), FontData.DataSize.ULONG.size());
                bl = n2 > 0 ? bl : true;
                n += Math.abs(n2) + n3;
            }
            return bl ? -n : n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.indexSubTableBuilders() != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            this.setNumberOfIndexSubTables(this.indexSubTableBuilders().size());
            int n = this.internalReadData().copyTo(writableFontData);
            return n;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            Iterator<IndexSubTable.Builder<? extends IndexSubTable>> subTableIter;
            Iterator<BitmapGlyphInfo> subTableGlyphInfoIter;

            public BitmapGlyphInfoIterator() {
                this.subTableIter = Builder.this.getIndexSubTableBuilders().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.subTableGlyphInfoIter != null && this.subTableGlyphInfoIter.hasNext()) {
                    return true;
                }
                while (this.subTableIter.hasNext()) {
                    IndexSubTable.Builder<? extends IndexSubTable> builder = this.subTableIter.next();
                    this.subTableGlyphInfoIter = builder.iterator();
                    if (!this.subTableGlyphInfoIter.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                return this.subTableGlyphInfoIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

