/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import java.util.Comparator;

public final class BitmapGlyphInfo {
    private final int glyphId;
    private final boolean relative;
    private final int blockOffset;
    private final int startOffset;
    private final int length;
    private final int format;
    public static final Comparator<BitmapGlyphInfo> StartOffsetComparator = new StartOffsetComparatorClass();

    public BitmapGlyphInfo(int n, int n2, int n3, int n4, int n5) {
        this.glyphId = n;
        this.relative = true;
        this.blockOffset = n2;
        this.startOffset = n3;
        this.length = n4;
        this.format = n5;
    }

    public BitmapGlyphInfo(int n, int n2, int n3, int n4) {
        this.glyphId = n;
        this.relative = false;
        this.blockOffset = 0;
        this.startOffset = n2;
        this.length = n3;
        this.format = n4;
    }

    public int glyphId() {
        return this.glyphId;
    }

    public boolean relative() {
        return this.relative;
    }

    public int blockOffset() {
        return this.blockOffset;
    }

    public int offset() {
        return this.blockOffset() + this.startOffset();
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int length() {
        return this.length;
    }

    public int format() {
        return this.format;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.blockOffset;
        n = 31 * n + this.format;
        n = 31 * n + this.glyphId;
        n = 31 * n + this.length;
        n = 31 * n + this.startOffset;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BitmapGlyphInfo)) {
            return false;
        }
        BitmapGlyphInfo bitmapGlyphInfo = (BitmapGlyphInfo)object;
        if (this.format != bitmapGlyphInfo.format) {
            return false;
        }
        if (this.glyphId != bitmapGlyphInfo.glyphId) {
            return false;
        }
        if (this.length != bitmapGlyphInfo.length) {
            return false;
        }
        return this.offset() == bitmapGlyphInfo.offset();
    }

    private static final class StartOffsetComparatorClass
    implements Comparator<BitmapGlyphInfo> {
        private StartOffsetComparatorClass() {
        }

        @Override
        public int compare(BitmapGlyphInfo bitmapGlyphInfo, BitmapGlyphInfo bitmapGlyphInfo2) {
            return bitmapGlyphInfo.startOffset - bitmapGlyphInfo2.startOffset;
        }
    }
}

