/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.GlyphMetrics;

public class BigGlyphMetrics
extends GlyphMetrics {
    BigGlyphMetrics(ReadableFontData readableFontData) {
        super(readableFontData);
    }

    public int height() {
        return this.data.readByte(Offset.height.offset);
    }

    public int width() {
        return this.data.readByte(Offset.width.offset);
    }

    public int horiBearingX() {
        return this.data.readChar(Offset.horiBearingX.offset);
    }

    public int horiBearingY() {
        return this.data.readChar(Offset.horiBearingY.offset);
    }

    public int horiAdvance() {
        return this.data.readByte(Offset.horiAdvance.offset);
    }

    public int vertBearingX() {
        return this.data.readChar(Offset.vertBearingX.offset);
    }

    public int vertBearingY() {
        return this.data.readChar(Offset.vertBearingY.offset);
    }

    public int vertAdvance() {
        return this.data.readByte(Offset.vertAdvance.offset);
    }

    public static class Builder
    extends GlyphMetrics.Builder<BigGlyphMetrics> {
        public static Builder createBuilder() {
            WritableFontData writableFontData = WritableFontData.createWritableFontData(Offset.metricsLength.offset);
            return new Builder(writableFontData);
        }

        protected Builder(WritableFontData writableFontData) {
            super(writableFontData);
        }

        protected Builder(ReadableFontData readableFontData) {
            super(readableFontData);
        }

        public int height() {
            return this.internalReadData().readByte(Offset.height.offset);
        }

        public void setHeight(byte by) {
            this.internalWriteData().writeByte(Offset.height.offset, by);
        }

        public int width() {
            return this.internalReadData().readByte(Offset.width.offset);
        }

        public void setWidth(byte by) {
            this.internalWriteData().writeByte(Offset.width.offset, by);
        }

        public int horiBearingX() {
            return this.internalReadData().readChar(Offset.horiBearingX.offset);
        }

        public void setHoriBearingX(byte by) {
            this.internalWriteData().writeChar(Offset.horiBearingX.offset, by);
        }

        public int horiBearingY() {
            return this.internalReadData().readChar(Offset.horiBearingY.offset);
        }

        public void setHoriBearingY(byte by) {
            this.internalWriteData().writeChar(Offset.horiBearingY.offset, by);
        }

        public int horiAdvance() {
            return this.internalReadData().readByte(Offset.horiAdvance.offset);
        }

        public void setHoriAdvance(byte by) {
            this.internalWriteData().writeByte(Offset.horiAdvance.offset, by);
        }

        public int vertBearingX() {
            return this.internalReadData().readChar(Offset.vertBearingX.offset);
        }

        public void setVertBearingX(byte by) {
            this.internalWriteData().writeChar(Offset.vertBearingX.offset, by);
        }

        public int vertBearingY() {
            return this.internalReadData().readChar(Offset.vertBearingY.offset);
        }

        public void setVertBearingY(byte by) {
            this.internalWriteData().writeChar(Offset.vertBearingY.offset, by);
        }

        public int vertAdvance() {
            return this.internalReadData().readByte(Offset.vertAdvance.offset);
        }

        public void setVertAdvance(byte by) {
            this.internalWriteData().writeByte(Offset.vertAdvance.offset, by);
        }

        @Override
        protected BigGlyphMetrics subBuildTable(ReadableFontData readableFontData) {
            return new BigGlyphMetrics(readableFontData);
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return false;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return this.data().copyTo(writableFontData);
        }
    }

    static enum Offset {
        metricsLength(8),
        height(0),
        width(1),
        horiBearingX(2),
        horiBearingY(3),
        horiAdvance(4),
        vertBearingX(5),
        vertBearingY(6),
        vertAdvance(7);

        final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

