/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table;

import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.GenericTableBuilder;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.bitmap.EbdtTable;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.EbscTable;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.truetype.ControlProgramTable;
import com.google.typography.font.sfntly.table.truetype.ControlValueTable;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;

public class Table
extends FontDataTable {
    private Header header;

    protected Table(Header header, ReadableFontData readableFontData) {
        super(readableFontData);
        this.header = header;
    }

    public long calculatedChecksum() {
        return this.data.checksum();
    }

    public Header header() {
        return this.header;
    }

    public int headerTag() {
        return this.header().tag();
    }

    public int headerOffset() {
        return this.header().offset();
    }

    public int headerLength() {
        return this.header().length();
    }

    public long headerChecksum() {
        return this.header().checksum();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(Tag.stringValue(this.header.tag()));
        stringBuilder.append(", cs=0x");
        stringBuilder.append(Long.toHexString(this.header.checksum()));
        stringBuilder.append(", offset=0x");
        stringBuilder.append(Integer.toHexString(this.header.offset()));
        stringBuilder.append(", size=0x");
        stringBuilder.append(Integer.toHexString(this.header.length()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static abstract class Builder<T extends Table>
    extends FontDataTable.Builder<T> {
        private Header header;

        protected Builder(Header header, WritableFontData writableFontData) {
            super(writableFontData);
            this.header = header;
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(readableFontData);
            this.header = header;
        }

        protected Builder(Header header) {
            this(header, null);
        }

        public String toString() {
            return "Table Builder for - " + this.header.toString();
        }

        public final Header header() {
            return this.header;
        }

        @Override
        protected void notifyPostTableBuild(T t) {
            if (this.modelChanged() || this.dataChanged()) {
                Header header = new Header(this.header().tag(), ((FontDataTable)t).dataLength());
                ((Table)t).header = header;
            }
        }

        public static Builder<? extends Table> getBuilder(Header header, WritableFontData writableFontData) {
            int n = header.tag();
            if (n == Tag.cmap) {
                return CMapTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.head) {
                return FontHeaderTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.hhea) {
                return HorizontalHeaderTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.hmtx) {
                return HorizontalMetricsTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.maxp) {
                return MaximumProfileTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.name) {
                return NameTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.OS_2) {
                return OS2Table.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.post) {
                return PostScriptTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.cvt) {
                return ControlValueTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.glyf) {
                return GlyphTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.loca) {
                return LocaTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.prep) {
                return ControlProgramTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.EBDT) {
                return EbdtTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.EBLC) {
                return EblcTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.EBSC) {
                return EbscTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.hdmx) {
                return HorizontalDeviceMetricsTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.bhed) {
                return FontHeaderTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.bdat) {
                return EbdtTable.Builder.createBuilder(header, writableFontData);
            }
            if (n == Tag.bloc) {
                return EblcTable.Builder.createBuilder(header, writableFontData);
            }
            return GenericTableBuilder.createBuilder(header, writableFontData);
        }
    }
}

