/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table;

import com.google.typography.font.sfntly.Tag;
import java.util.Comparator;

public final class Header {
    private final int tag;
    private final int offset;
    private final boolean offsetValid;
    private final int length;
    private final boolean lengthValid;
    private final long checksum;
    private final boolean checksumValid;
    public static final Comparator<Header> COMPARATOR_BY_OFFSET = new Comparator<Header>(){

        @Override
        public int compare(Header header, Header header2) {
            return header.offset - header2.offset;
        }
    };
    public static final Comparator<Header> COMPARATOR_BY_TAG = new Comparator<Header>(){

        @Override
        public int compare(Header header, Header header2) {
            return header.tag - header2.tag;
        }
    };

    public Header(int n, long l, int n2, int n3) {
        this.tag = n;
        this.checksum = l;
        this.checksumValid = true;
        this.offset = n2;
        this.offsetValid = true;
        this.length = n3;
        this.lengthValid = true;
    }

    public Header(int n, int n2) {
        this.tag = n;
        this.checksum = 0L;
        this.checksumValid = false;
        this.offset = 0;
        this.offsetValid = false;
        this.length = n2;
        this.lengthValid = true;
    }

    public Header(int n) {
        this.tag = n;
        this.checksum = 0L;
        this.checksumValid = false;
        this.offset = 0;
        this.offsetValid = false;
        this.length = 0;
        this.lengthValid = true;
    }

    public int tag() {
        return this.tag;
    }

    public int offset() {
        return this.offset;
    }

    public boolean offsetValid() {
        return this.offsetValid;
    }

    public int length() {
        return this.length;
    }

    public boolean lengthValid() {
        return this.lengthValid;
    }

    public long checksum() {
        return this.checksum;
    }

    public boolean checksumValid() {
        return this.checksumValid;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Header)) {
            return false;
        }
        return ((Header)object).tag == this.tag;
    }

    public int hashCode() {
        return this.tag;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(Tag.stringValue(this.tag));
        stringBuilder.append(", ");
        stringBuilder.append(Long.toHexString(this.checksum));
        stringBuilder.append(", ");
        stringBuilder.append(Integer.toHexString(this.offset));
        stringBuilder.append(", ");
        stringBuilder.append(Integer.toHexString(this.length));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

