/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import java.io.IOException;
import java.io.OutputStream;

final class MemoryByteArray
extends ByteArray<MemoryByteArray> {
    private byte[] b;

    public MemoryByteArray(int n) {
        this(new byte[n], 0);
    }

    public MemoryByteArray(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public MemoryByteArray(byte[] byArray, int n) {
        super(n, byArray.length);
        this.b = byArray;
    }

    @Override
    protected void internalPut(int n, byte by) {
        this.b[n] = by;
    }

    @Override
    protected int internalPut(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.b, n, n3);
        return n3;
    }

    @Override
    protected int internalGet(int n) {
        return this.b[n];
    }

    @Override
    protected int internalGet(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.b, n, byArray, n2, n3);
        return n3;
    }

    @Override
    public void close() {
        this.b = null;
    }

    @Override
    public int copyTo(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(this.b, n, n2);
        return n2;
    }
}

