/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import java.io.IOException;
import java.io.OutputStream;

public class FontOutputStream
extends OutputStream {
    private final OutputStream out;
    private long position;

    public FontOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public long position() {
        return this.position;
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        ++this.position;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.out.write(byArray, n, n2);
        this.position += (long)n2;
    }

    public void writeChar(byte by) throws IOException {
        this.write(by);
    }

    public void writeUShort(int n) throws IOException {
        this.write((byte)(n >> 8 & 0xFF));
        this.write((byte)(n & 0xFF));
    }

    public void writeShort(int n) throws IOException {
        this.writeUShort(n);
    }

    public void writeUInt24(int n) throws IOException {
        this.write((byte)(n >> 16 & 0xFF));
        this.write((byte)(n >> 8 & 0xFF));
        this.write((byte)(n & 0xFF));
    }

    public void writeULong(long l) throws IOException {
        this.write((byte)(l >> 24 & 0xFFL));
        this.write((byte)(l >> 16 & 0xFFL));
        this.write((byte)(l >> 8 & 0xFFL));
        this.write((byte)(l & 0xFFL));
    }

    public void writeLong(long l) throws IOException {
        this.writeULong(l);
    }

    public void writeFixed(int n) throws IOException {
        this.writeULong(n);
    }

    public void writeDateTime(long l) throws IOException {
        this.writeULong(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.writeULong(l & 0xFFFFFFFFFFFFFFFFL);
    }
}

