/*
 * Decompiled with CFR 0.152.
 */
package com.jpacker;

import com.jpacker.JPackerPattern;
import com.jpacker.evaluators.AbstractEvaluator;
import com.jpacker.evaluators.DeleteEvaluator;
import com.jpacker.evaluators.Evaluator;
import com.jpacker.evaluators.IntegerEvaluator;
import com.jpacker.evaluators.StringEvaluator;
import com.jpacker.strategies.DefaultReplacementStrategy;
import com.jpacker.strategies.ReplacementStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPackerParser {
    private static Pattern GROUPS = Pattern.compile("\\(");
    private static Pattern SUB_REPLACE = Pattern.compile("\\$(\\d+)");
    private static Pattern INDEXED = Pattern.compile("^\\$\\d+$");
    private static Pattern ESCAPE = Pattern.compile("\\\\.");
    private static Pattern ESCAPE_BRACKETS = Pattern.compile("\\(\\?[:=!]|\\[[^\\]]+\\]");
    private static Pattern DELETED = Pattern.compile("\\x01[^\\x01]*\\x01");
    private static String IGNORE = "$0";
    private List<JPackerPattern> jpatterns = new ArrayList<JPackerPattern>();

    public void remove(String expression) {
        this.replace(expression, "");
    }

    public void ignore(String expression) {
        this.replace(expression, IGNORE);
    }

    public void replace(String expression, String replacement) {
        if (replacement.isEmpty()) {
            this.replace(expression, new DeleteEvaluator());
            return;
        }
        AbstractEvaluator evaluator = SUB_REPLACE.matcher(replacement).matches() && INDEXED.matcher(replacement).matches() ? new IntegerEvaluator(Integer.parseInt(replacement.substring(1))) : new StringEvaluator(replacement);
        JPackerPattern jpattern = new JPackerPattern(expression, evaluator);
        jpattern.setLength(this.countSubExpressions(expression));
        this.jpatterns.add(jpattern);
    }

    public void replace(String expression, Evaluator evaluator) {
        JPackerPattern jpattern = new JPackerPattern(expression, evaluator);
        jpattern.setLength(this.countSubExpressions(expression));
        this.jpatterns.add(jpattern);
    }

    private Pattern buildPatterns() {
        StringBuilder rtrn = new StringBuilder();
        for (JPackerPattern jpattern : this.jpatterns) {
            rtrn.append(jpattern).append("|");
        }
        rtrn.deleteCharAt(rtrn.length() - 1);
        return Pattern.compile(rtrn.toString());
    }

    public String exec(String input) {
        return this.exec(input, new DefaultReplacementStrategy());
    }

    public String exec(String input, ReplacementStrategy strategy) {
        Matcher matcher = this.buildPatterns().matcher(input);
        StringBuffer sb = new StringBuffer(input.length());
        while (matcher.find()) {
            String rep = strategy.replace(this.jpatterns, matcher);
            if (rep != null && !rep.isEmpty()) {
                rep = Matcher.quoteReplacement(rep);
            }
            matcher.appendReplacement(sb, rep);
        }
        matcher.appendTail(sb);
        return DELETED.matcher(sb).replaceAll("");
    }

    private int countSubExpressions(String expression) {
        int cont = 0;
        Matcher matcher = GROUPS.matcher(this.internalEscape(expression));
        while (matcher.find()) {
            ++cont;
        }
        return cont + 1;
    }

    private String internalEscape(String str) {
        return ESCAPE_BRACKETS.matcher(ESCAPE.matcher(str).replaceAll("")).replaceAll("");
    }

    public List<JPackerPattern> getJPatterns() {
        return this.jpatterns;
    }
}

