/*
 * Decompiled with CFR 0.152.
 */
package lt.dkd.nellymoser;

public class CodecImpl {
    private static final int[] bandBound = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 21, 24, 28, 32, 37, 43, 49, 56, 64, 73, 83, 95, 109, 124};
    private static final short[] gainBit = new short[]{6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] table0 = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 9, 10, 12, 14, 15, 0};
    private static final float[] table1 = new float[]{3134.0f, 5342.0f, 6870.0f, 7792.0f, 8569.0f, 9185.0f, 9744.0f, 10191.0f, 10631.0f, 11061.0f, 11434.0f, 11770.0f, 12116.0f, 12513.0f, 12925.0f, 13300.0f, 13674.0f, 14027.0f, 14352.0f, 14716.0f, 15117.0f, 15477.0f, 15824.0f, 16157.0f, 16513.0f, 16804.0f, 17090.0f, 17401.0f, 17679.0f, 17948.0f, 18238.0f, 18520.0f, 18764.0f, 19078.0f, 19381.0f, 19640.0f, 19921.0f, 20205.0f, 20500.0f, 20813.0f, 21162.0f, 21465.0f, 21794.0f, 22137.0f, 22453.0f, 22756.0f, 23067.0f, 23350.0f, 23636.0f, 23926.0f, 24227.0f, 24521.0f, 24819.0f, 25107.0f, 25414.0f, 25730.0f, 26120.0f, 26497.0f, 26895.0f, 27344.0f, 27877.0f, 28463.0f, 29426.0f, 31355.0f};
    private static final float[] table2 = new float[]{-11725.0f, -9420.0f, -7910.0f, -6801.0f, -5948.0f, -5233.0f, -4599.0f, -4039.0f, -3507.0f, -3030.0f, -2596.0f, -2170.0f, -1774.0f, -1383.0f, -1016.0f, -660.0f, -329.0f, -1.0f, 337.0f, 696.0f, 1085.0f, 1512.0f, 1962.0f, 2433.0f, 2968.0f, 3569.0f, 4314.0f, 5279.0f, 6622.0f, 8154.0f, 10076.0f, 12975.0f};
    private static final float[] table3 = new float[]{0.0f, -0.847256f, 0.722471f, -1.524748f, -0.453148f, 0.375361f, 1.47179f, -1.982258f, -1.192938f, -0.582937f, -0.069378f, 0.390957f, 0.90692f, 1.486274f, 2.221541f, -2.388787f, -1.806754f, -1.410542f, -1.077361f, -0.799501f, -0.555811f, -0.333402f, -0.132449f, 0.056802f, 0.254877f, 0.477355f, 0.738685f, 1.044306f, 1.395446f, 1.809875f, 2.391876f, -2.389383f, -1.988468f, -1.751404f, -1.564312f, -1.392213f, -1.216465f, -1.04695f, -0.89051f, -0.764558f, -0.645458f, -0.525928f, -0.405955f, -0.302972f, -0.20969f, -0.123987f, -0.047923f, 0.025773f, 0.100134f, 0.173718f, 0.258554f, 0.35229f, 0.456988f, 0.576775f, 0.700316f, 0.842552f, 1.009388f, 1.182135f, 1.353456f, 1.532082f, 1.733262f, 1.972235f, 2.397814f, -2.575631f, -2.057332f, -1.898492f, -1.772781f, -1.66626f, -1.574218f, -1.499332f, -1.431664f, -1.365228f, -1.300099f, -1.228093f, -1.158858f, -1.092125f, -1.013574f, -0.920285f, -0.828705f, -0.737489f, -0.644776f, -0.559094f, -0.485714f, -0.411032f, -0.34597f, -0.285116f, -0.234162f, -0.187058f, -0.14425f, -0.110717f, -0.073968f, -0.036561f, -0.007329f, 0.020361f, 0.047904f, 0.075197f, 0.0981f, 0.122039f, 0.1459f, 0.169435f, 0.197046f, 0.225243f, 0.255687f, 0.28701f, 0.31971f, 0.352583f, 0.388907f, 0.433492f, 0.476946f, 0.520482f, 0.564453f, 0.612204f, 0.668593f, 0.734165f, 0.803216f, 0.878404f, 0.956621f, 1.039707f, 1.129377f, 1.221116f, 1.308028f, 1.40248f, 1.505682f, 1.622773f, 1.772496f, 1.943088f, 2.290393f, 0.0f};
    private static final float[] table4 = new float[]{0.9999812f, 0.9995294f, 0.9984756f, 0.9968203f, 0.9945646f, 0.9917098f, 0.9882576f, 0.9842101f, 0.9795698f, 0.9743394f, 0.9685221f, 0.9621214f, 0.9551412f, 0.9475856f, 0.9394592f, 0.930767f, 0.921514f, 0.911706f, 0.9013488f, 0.8904487f, 0.8790122f, 0.8670462f, 0.854558f, 0.841555f, 0.828045f, 0.8140363f, 0.7995373f, 0.7845566f, 0.7691033f, 0.7531868f, 0.7368166f, 0.7200025f, 0.7027547f, 0.6850837f, 0.6669999f, 0.6485144f, 0.6296382f, 0.6103828f, 0.5907597f, 0.5707807f, 0.550458f, 0.5298036f, 0.5088301f, 0.4875502f, 0.4659765f, 0.4441221f, 0.4220003f, 0.3996242f, 0.3770074f, 0.3541635f, 0.3311063f, 0.3078496f, 0.2844075f, 0.2607941f, 0.2370236f, 0.2131103f, 0.1890687f, 0.1649131f, 0.1406582f, 0.1163186f, 0.091909f, 0.0674439f, 0.0429383f, 0.0184067f};
    private static final float[] table5 = new float[]{0.125f, 0.1249624f, 0.1248494f, 0.1246613f, 0.1243981f, 0.1240599f, 0.1236471f, 0.1231597f, 0.1225982f, 0.1219628f, 0.1212539f, 0.120472f, 0.1196175f, 0.118691f, 0.117693f, 0.1166241f, 0.1154849f, 0.1142762f, 0.1129987f, 0.111653f, 0.1102402f, 0.1087609f, 0.1072161f, 0.1056067f, 0.1039337f, 0.1021981f, 0.1004009f, 0.0985433f, 0.0966263f, 0.0946511f, 0.0926189f, 0.0905309f, 0.0883883f, 0.0861926f, 0.0839449f, 0.0816466f, 0.0792992f, 0.0769039f, 0.0744624f, 0.071976f, 0.0694463f, 0.0668747f, 0.0642628f, 0.0616123f, 0.0589246f, 0.0562014f, 0.0534444f, 0.0506552f, 0.0478354f, 0.0449869f, 0.0421112f, 0.0392102f, 0.0362856f, 0.0333391f, 0.0303725f, 0.0273877f, 0.0243863f, 0.0213702f, 0.0183413f, 0.0153013f, 0.0122521f, 0.0091956f, 0.0061335f, 0.0030677f};
    private static final float[] table6 = new float[]{-0.0061359f, -0.0306748f, -0.0551952f, -0.0796824f, -0.1041216f, -0.1284981f, -0.1527972f, -0.1770042f, -0.2011046f, -0.2250839f, -0.2489276f, -0.2726214f, -0.2961509f, -0.319502f, -0.3426607f, -0.365613f, -0.388345f, -0.4108432f, -0.4330938f, -0.4550836f, -0.4767992f, -0.4982277f, -0.519356f, -0.5401715f, -0.5606616f, -0.580814f, -0.6006165f, -0.6200572f, -0.6391244f, -0.6578067f, -0.6760927f, -0.6939715f, -0.7114322f, -0.7284644f, -0.7450578f, -0.7612024f, -0.7768885f, -0.7921066f, -0.8068476f, -0.8211025f, -0.8348629f, -0.8481203f, -0.8608669f, -0.873095f, -0.8847971f, -0.8959662f, -0.9065957f, -0.9166791f, -0.9262102f, -0.9351835f, -0.9435935f, -0.951435f, -0.9587035f, -0.9653944f, -0.9715039f, -0.9770281f, -0.9819639f, -0.9863081f, -0.9900582f, -0.9932119f, -0.9957674f, -0.9977231f, -0.9990777f, -0.9998306f};
    private static final float[] table7 = new float[]{0.0061359f, 0.0184067f, 0.0306748f, 0.0429383f, 0.0551952f, 0.0674439f, 0.0796824f, 0.091909f, 0.1041216f, 0.1163186f, 0.1284981f, 0.1406582f, 0.1527972f, 0.1649131f, 0.1770042f, 0.1890687f, 0.2011046f, 0.2131103f, 0.2250839f, 0.2370236f, 0.2489276f, 0.2607941f, 0.2726214f, 0.2844075f, 0.2961509f, 0.3078496f, 0.319502f, 0.3311063f, 0.3426607f, 0.3541635f, 0.365613f, 0.3770074f, 0.388345f, 0.3996242f, 0.4108432f, 0.4220003f, 0.4330938f, 0.4441221f, 0.4550836f, 0.4659765f, 0.4767992f, 0.4875502f, 0.4982277f, 0.5088301f, 0.519356f, 0.5298036f, 0.5401715f, 0.550458f, 0.5606616f, 0.5707807f, 0.580814f, 0.5907597f, 0.6006165f, 0.6103828f, 0.6200572f, 0.6296382f, 0.6391244f, 0.6485144f, 0.6578067f, 0.6669999f, 0.6760927f, 0.6850837f, 0.6939715f, 0.7027547f, 0.7114322f, 0.7200025f, 0.7284644f, 0.7368166f, 0.7450578f, 0.7531868f, 0.7612024f, 0.7691033f, 0.7768885f, 0.7845566f, 0.7921066f, 0.7995373f, 0.8068476f, 0.8140363f, 0.8211025f, 0.828045f, 0.8348629f, 0.841555f, 0.8481203f, 0.854558f, 0.8608669f, 0.8670462f, 0.873095f, 0.8790122f, 0.8847971f, 0.8904487f, 0.8959662f, 0.9013488f, 0.9065957f, 0.911706f, 0.9166791f, 0.921514f, 0.9262102f, 0.930767f, 0.9351835f, 0.9394592f, 0.9435935f, 0.9475856f, 0.951435f, 0.9551412f, 0.9587035f, 0.9621214f, 0.9653944f, 0.9685221f, 0.9715039f, 0.9743394f, 0.9770281f, 0.9795698f, 0.9819639f, 0.9842101f, 0.9863081f, 0.9882576f, 0.9900582f, 0.9917098f, 0.9932119f, 0.9945646f, 0.9957674f, 0.9968203f, 0.9977231f, 0.9984756f, 0.9990777f, 0.9995294f, 0.9998306f, 0.9999812f};
    private static final short[] table9 = new short[]{Short.MAX_VALUE, 30840, 29127, 27594, 26214, 24966, 23831, 22795, 21845, 20972, 20165, 19418, 18725, 18079, 17476, 16913, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final float[] table10 = new float[]{0.0f, 0.012271538f, 0.024541229f, 0.036807224f, 0.049067672f, 0.061320737f, 0.07356457f, 0.08579731f, 0.09801714f, 0.11022221f, 0.12241068f, 0.13458072f, 0.14673047f, 0.15885814f, 0.17096189f, 0.18303989f, 0.19509032f, 0.20711137f, 0.21910124f, 0.2310581f, 0.24298018f, 0.25486565f, 0.26671275f, 0.2785197f, 0.2902847f, 0.30200595f, 0.31368175f, 0.3253103f, 0.33688986f, 0.34841868f, 0.35989505f, 0.37131718f, 0.38268343f, 0.39399204f, 0.4052413f, 0.41642955f, 0.42755508f, 0.43861625f, 0.44961134f, 0.46053872f, 0.47139674f, 0.48218378f, 0.4928982f, 0.50353837f, 0.51410276f, 0.52458966f, 0.53499764f, 0.545325f, 0.55557024f, 0.5657318f, 0.57580817f, 0.58579785f, 0.5956993f, 0.60551107f, 0.6152316f, 0.6248595f, 0.6343933f, 0.64383155f, 0.65317285f, 0.6624158f, 0.671559f, 0.680601f, 0.68954057f, 0.69837624f, 0.70710677f, 0.71573085f, 0.7242471f, 0.7326543f, 0.7409511f, 0.7491364f, 0.7572088f, 0.7651673f, 0.77301043f, 0.7807372f, 0.7883464f, 0.7958369f, 0.8032075f, 0.8104572f, 0.8175848f, 0.8245893f, 0.8314696f, 0.8382247f, 0.8448536f, 0.8513552f, 0.8577286f, 0.86397284f, 0.87008697f, 0.8760701f, 0.88192123f, 0.88763964f, 0.8932243f, 0.8986745f, 0.9039893f, 0.909168f, 0.9142098f, 0.9191139f, 0.9238795f, 0.9285061f, 0.9329928f, 0.937339f, 0.94154406f, 0.9456073f, 0.94952816f, 0.953306f, 0.95694035f, 0.9604305f, 0.96377605f, 0.96697646f, 0.97003126f, 0.97293997f, 0.9757021f, 0.9783174f, 0.98078525f, 0.9831055f, 0.98527765f, 0.9873014f, 0.9891765f, 0.99090266f, 0.9924795f, 0.993907f, 0.9951847f, 0.9963126f, 0.99729043f, 0.9981181f, 0.99879545f, 0.99932235f, 0.9996988f, 0.9999247f, 1.0f};

    public static void encode(float[] state, float[] in, byte[] out) {
        int i;
        float[] var_8d8 = new float[256];
        float[] var_2e8 = new float[23];
        float[] var_268 = new float[23];
        float[] var_4d8 = new float[124];
        float[] var_208 = new float[124];
        BitStream bs = new BitStream();
        CodecImpl.fTransfm(state, in, 0, 7, var_8d8, 0);
        CodecImpl.fTransfm(state, in, 128, 7, var_8d8, 128);
        for (int i2 = 0; i2 < 23; ++i2) {
            int next_bound = bandBound[i2 + 1];
            double acc = 0.0;
            for (int bound = bandBound[i2]; bound < next_bound; ++bound) {
                double a = var_8d8[bound];
                double b = var_8d8[bound + 128];
                acc += a * a + b * b;
            }
            double tmp = Math.max(1.0, acc / (double)(table0[i2] << 1));
            var_2e8[i2] = Math.round(Math.log(tmp) * 1477.31970048);
        }
        int idx = CodecImpl.findClosest(var_2e8[0], table1, 0, 64);
        var_268[0] = table1[idx];
        bs.push(idx, gainBit[0], out);
        for (i = 1; i < 23; ++i) {
            idx = CodecImpl.findClosest(var_2e8[i] - var_268[i - 1], table2, 0, 32);
            var_268[i] = var_268[i - 1] + table2[idx];
            bs.push(idx, gainBit[i], out);
        }
        for (i = 0; i < 23; ++i) {
            var_2e8[i] = (float)(1.0 / Math.pow(2.0, (double)var_268[i] * 4.8828125E-4));
        }
        for (i = 0; i < 23; ++i) {
            int next_bound = bandBound[i + 1];
            for (int bound = bandBound[i]; bound < next_bound; ++bound) {
                var_4d8[bound] = var_268[i];
                var_208[bound] = var_2e8[i];
            }
        }
        int[] packed_byte_sizes = new int[124];
        int leftover = CodecImpl.wc(var_4d8, 124, 198, packed_byte_sizes);
        block6: for (int off = 0; off < 256; off += 128) {
            int i3;
            for (i3 = 0; i3 < 124; ++i3) {
                int packedSize = packed_byte_sizes[i3];
                if (packedSize <= 0) continue;
                int pow2 = 1 << packedSize;
                idx = CodecImpl.findClosestOrdered(var_208[i3] * var_8d8[off + i3], table3, pow2 - 1, (pow2 << 1) - 1);
                bs.push(idx, packedSize, out);
            }
            for (i3 = leftover; i3 > 0; i3 -= 8) {
                if (i3 <= 8) {
                    bs.push(0, i3, out);
                    continue block6;
                }
                bs.push(0, 8, out);
            }
        }
    }

    public static void decode(float[] state, byte[] in, float[] out) {
        int i;
        byte[] unpacked_input = new byte[124];
        float[] var_808 = new float[128];
        float[] var_608 = new float[124];
        float[] var_418 = new float[124];
        BitStream bs = new BitStream();
        int unpacked_byte = bs.pop(gainBit[0], in);
        unpacked_input[0] = (byte)unpacked_byte;
        var_808[0] = table1[unpacked_byte];
        for (i = 1; i < 23; ++i) {
            unpacked_byte = bs.pop(gainBit[i], in);
            unpacked_input[i] = (byte)unpacked_byte;
            var_808[i] = var_808[i - 1] + table2[unpacked_byte];
        }
        for (i = 0; i < 23; ++i) {
            float pow = (float)Math.pow(2.0, (double)var_808[i] * 4.8828125E-4);
            int next_bound = bandBound[i + 1];
            for (int bound = bandBound[i]; bound < next_bound; ++bound) {
                var_418[bound] = var_808[i];
                var_608[bound] = pow;
            }
        }
        int[] packed_byte_sizes = new int[124];
        int leftover = CodecImpl.wc(var_418, 124, 198, packed_byte_sizes);
        for (int out_off = 0; out_off < 256; out_off += 128) {
            int i2;
            for (i2 = 0; i2 < 124; ++i2) {
                int packed_size = packed_byte_sizes[i2];
                float val = var_608[i2];
                if (packed_size > 0) {
                    int pow2 = 1 << packed_size;
                    unpacked_byte = bs.pop(packed_size, in);
                    unpacked_input[i2] = (byte)unpacked_byte;
                    val *= table3[pow2 - 1 + unpacked_byte];
                } else {
                    double rnd_u32 = Math.random() * 4.294967296E9;
                    val = rnd_u32 < 1.073758208E9 ? (float)((double)val * -0.707099974) : (float)((double)val * 0.707099974);
                }
                var_808[i2] = val;
            }
            for (i2 = 124; i2 < 128; ++i2) {
                var_808[i2] = 0.0f;
            }
            for (i2 = leftover; i2 > 0; i2 -= 8) {
                if (i2 <= 8) {
                    bs.pop(i2, in);
                    break;
                }
                bs.pop(8, in);
            }
            CodecImpl.iTransfm(state, var_808, 7, out, out_off);
        }
    }

    private static void iTransfm(float[] state, float[] in, int len_log2, float[] out, int out_off) {
        int len = 1 << len_log2;
        int quarter_len = len >> 2;
        int y = len - 1;
        int x = len >> 1;
        int j = x - 1;
        int i = 0;
        CodecImpl.auxceps(in, 0, len_log2, out, out_off);
        while (i < quarter_len) {
            double state_i = state[i];
            double state_j = state[j];
            double out_x = out[out_off + x];
            double out_y = out[out_off + y];
            state[i] = -out[out_off + j];
            state[j] = -out[out_off + i];
            out[out_off + i] = (float)(state_i * (double)table7[y] + out_x * (double)table7[i]);
            out[out_off + j] = (float)(state_j * (double)table7[x] + out_y * (double)table7[j]);
            out[out_off + x] = (float)((double)table7[x] * -out_y + (double)table7[j] * state_j);
            out[out_off + y] = (float)((double)table7[y] * -out_x + (double)table7[i] * state_i);
            ++i;
            --j;
            ++x;
            --y;
        }
    }

    private static void fTransfm(float[] state, float[] in, int in_off, int len_log2, float[] out, int out_off) {
        int len = 1 << len_log2;
        int quarter_len = len >> 2;
        int y = len - 1;
        int x = len >> 1;
        int j = x - 1;
        int i = 0;
        while (i < quarter_len) {
            out[out_off + x] = state[i];
            out[out_off + y] = state[j];
            out[out_off + i] = -in[in_off + j] * table7[x] - in[in_off + x] * table7[j];
            out[out_off + j] = -in[in_off + y] * table7[i] - in[in_off + i] * table7[y];
            state[i] = in[in_off + i] * table7[i] - in[in_off + y] * table7[y];
            state[j] = in[in_off + j] * table7[j] - in[in_off + x] * table7[x];
            ++i;
            ++x;
            --y;
            --j;
        }
        CodecImpl.auxceps(out, out_off, len_log2, out, out_off);
    }

    private static void auxceps(float[] in, int in_off, int len_log2, float[] out, int out_off) {
        int len = 1 << len_log2;
        int half_len_m1 = (len >> 1) - 1;
        int quarter_len = len >> 2;
        for (int i = 0; i < quarter_len; ++i) {
            int i2 = i << 1;
            int j = len - 1 - i2;
            int k = j - 1;
            double in_i2 = in[in_off + i2];
            double in_i2_1 = in[in_off + i2 + 1];
            double in_j = in[in_off + j];
            double in_k = in[in_off + k];
            out[out_off + i2] = (float)((double)table4[i] * in_i2 - (double)table6[i] * in_j);
            out[out_off + i2 + 1] = (float)(in_j * (double)table4[i] + in_i2 * (double)table6[i]);
            out[out_off + k] = (float)((double)table4[half_len_m1 - i] * in_k - (double)table6[half_len_m1 - i] * in_i2_1);
            out[out_off + j] = (float)(in_i2_1 * (double)table4[half_len_m1 - i] + in_k * (double)table6[half_len_m1 - i]);
        }
        CodecImpl.HarXfm(out, out_off, len_log2 - 1);
        float last_out = out[out_off + len - 1];
        float pre_last_out = out[out_off + len - 2];
        out[out_off] = table5[0] * out[out_off];
        out[out_off + len - 1] = out[out_off + 1] * -table5[0];
        out[out_off + len - 2] = table5[half_len_m1] * out[out_off + len - 2] + table5[1] * last_out;
        out[out_off + 1] = pre_last_out * table5[1] - last_out * table5[half_len_m1];
        int i_out = len - 3;
        int i_tbl = half_len_m1;
        int j = 3;
        int i = 1;
        while (i < quarter_len) {
            double old_out_a = out[out_off + i_out];
            double old_out_b = out[out_off + i_out - 1];
            double old_out_c = out[out_off + j];
            double old_out_d = out[out_off + j - 1];
            out[out_off + j - 1] = (float)((double)table5[i_tbl] * old_out_c + (double)table5[j - 1 >> 1] * old_out_d);
            out[out_off + j] = (float)(old_out_b * (double)table5[j + 1 >> 1] - old_out_a * (double)table5[i_tbl - 1]);
            out[out_off + i_out] = (float)(old_out_d * (double)table5[i_tbl] - old_out_c * (double)table5[j - 1 >> 1]);
            out[out_off + i_out - 1] = (float)((double)table5[j + 1 >> 1] * old_out_a + (double)table5[i_tbl - 1] * old_out_b);
            ++i;
            --i_tbl;
            i_out -= 2;
            j += 2;
        }
    }

    private static void HarXfm(float[] data, int data_off, int half_len_log2) {
        float j3;
        float j2;
        float j1;
        float j0;
        int half_len = 1 << half_len_log2;
        CodecImpl.HarXfmHelper(data, data_off, half_len);
        int j = 0;
        int i = half_len >> 1;
        while (i > 0) {
            j0 = data[data_off + j];
            j1 = data[data_off + j + 1];
            j2 = data[data_off + j + 2];
            j3 = data[data_off + j + 3];
            data[data_off + j] = j0 + j2;
            data[data_off + j + 1] = j1 + j3;
            data[data_off + j + 2] = j0 - j2;
            data[data_off + j + 3] = j1 - j3;
            --i;
            j += 4;
        }
        j = 0;
        i = half_len >> 2;
        while (i > 0) {
            j0 = data[data_off + j];
            j1 = data[data_off + j + 1];
            j2 = data[data_off + j + 2];
            j3 = data[data_off + j + 3];
            float j4 = data[data_off + j + 4];
            float j5 = data[data_off + j + 5];
            float j6 = data[data_off + j + 6];
            float j7 = data[data_off + j + 7];
            data[data_off + j] = j0 + j4;
            data[data_off + j + 1] = j1 + j5;
            data[data_off + j + 2] = j2 + j7;
            data[data_off + j + 3] = j3 - j6;
            data[data_off + j + 4] = j0 - j4;
            data[data_off + j + 5] = j1 - j5;
            data[data_off + j + 6] = j2 - j7;
            data[data_off + j + 7] = j3 + j6;
            --i;
            j += 8;
        }
        i = 0;
        int x = half_len >> 3;
        int y = 64;
        int z = 4;
        int idx1 = half_len_log2 - 2;
        while (idx1 > 0) {
            j = 0;
            int idx2 = x;
            while (idx2 != 0) {
                double k1;
                double k0;
                double j12;
                double j02;
                int k;
                int idx3 = z >> 1;
                while (idx3 > 0) {
                    k = j + (z << 1);
                    j02 = data[data_off + j];
                    j12 = data[data_off + j + 1];
                    k0 = data[data_off + k];
                    k1 = data[data_off + k + 1];
                    data[data_off + k] = (float)(j02 - (k0 * (double)table10[128 - i] + k1 * (double)table10[i]));
                    data[data_off + j] = (float)(j02 + (k0 * (double)table10[128 - i] + k1 * (double)table10[i]));
                    data[data_off + k + 1] = (float)(j12 + (k0 * (double)table10[i] - k1 * (double)table10[128 - i]));
                    data[data_off + j + 1] = (float)(j12 - (k0 * (double)table10[i] - k1 * (double)table10[128 - i]));
                    --idx3;
                    j += 2;
                    i += y;
                }
                int idx4 = z >> 1;
                while (idx4 > 0) {
                    k = j + (z << 1);
                    j02 = data[data_off + j];
                    j12 = data[data_off + j + 1];
                    k0 = data[data_off + k];
                    k1 = data[data_off + k + 1];
                    data[data_off + k] = (float)(j02 + (k0 * (double)table10[128 - i] - k1 * (double)table10[i]));
                    data[data_off + j] = (float)(j02 - (k0 * (double)table10[128 - i] - k1 * (double)table10[i]));
                    data[data_off + k + 1] = (float)(j12 + (k1 * (double)table10[128 - i] + k0 * (double)table10[i]));
                    data[data_off + j + 1] = (float)(j12 - (k1 * (double)table10[128 - i] + k0 * (double)table10[i]));
                    --idx4;
                    j += 2;
                    i -= y;
                }
                --idx2;
                j += z << 1;
            }
            --idx1;
            z <<= 1;
            y >>= 1;
            x >>= 1;
        }
    }

    private static void HarXfmHelper(float[] data, int data_off, int half_len) {
        int len = half_len << 1;
        int j = 1;
        for (int i = 1; i < len; i += 2) {
            int x;
            if (i < j) {
                float tmp1 = data[data_off + i];
                data[data_off + i] = data[data_off + j];
                data[data_off + j] = tmp1;
                float tmp2 = data[data_off + i - 1];
                data[data_off + i - 1] = data[data_off + j - 1];
                data[data_off + j - 1] = tmp2;
            }
            for (x = half_len; x > 1 && x < j; j -= x, x >>= 1) {
            }
            j += x;
        }
    }

    private static int findClosest(float target, float[] values, int from, int to) {
        int min_idx = 0;
        float min_distance = Math.abs(target - values[from]);
        for (int i = from; i < to; ++i) {
            float distance = Math.abs(target - values[i]);
            if (!(distance < min_distance)) continue;
            min_distance = distance;
            min_idx = i - from;
        }
        return min_idx;
    }

    private static int findClosestOrdered(float target, float[] values, int from, int to) {
        int begin = from;
        int end = to;
        do {
            int middle;
            if (target > values[middle = begin + end >> 1]) {
                begin = middle;
                continue;
            }
            end = middle;
        } while (end - begin > 1);
        if (end != to && target - values[begin] > values[end] - target) {
            begin = end;
        }
        return begin - from;
    }

    static int wc(float[] in, int len, int total_bits, int[] packed_sizes) {
        int i;
        int i2;
        float max_input = 0.0f;
        for (int i3 = 0; i3 < len; ++i3) {
            if (!(in[i3] > max_input)) continue;
            max_input = in[i3];
        }
        int max_input_scale = 0;
        NormalizedInt32 normalized = new NormalizedInt32((int)max_input);
        max_input_scale = normalized.scale - 16;
        short[] scaled_input = new short[124];
        if (max_input_scale < 0) {
            for (i2 = 0; i2 < len; ++i2) {
                scaled_input[i2] = (short)((int)in[i2] >> -max_input_scale);
            }
        } else {
            for (i2 = 0; i2 < len; ++i2) {
                scaled_input[i2] = (short)((int)in[i2] << max_input_scale);
            }
        }
        Factor factor = new Factor(len);
        for (int i4 = 0; i4 < len; ++i4) {
            scaled_input[i4] = (short)(scaled_input[i4] * 3 >> 2);
        }
        int scaled_input_sum = 0;
        for (int i5 = 0; i5 < len; ++i5) {
            scaled_input_sum += scaled_input[i5];
        }
        int scaled_input_base = 0;
        int val = (scaled_input_sum -= total_bits << (max_input_scale += 11)) - (total_bits << max_input_scale);
        NormalizedInt32 normalized2 = new NormalizedInt32(val);
        scaled_input_base = (val >> 16) * factor.value >> 15;
        int shift = 31 - factor.shift - normalized2.scale;
        scaled_input_base = shift >= 0 ? (scaled_input_base <<= shift) : (scaled_input_base >>= -shift);
        int bits_used = CodecImpl.getD(scaled_input, max_input_scale, len, 6, scaled_input_base);
        if (bits_used != total_bits) {
            int last_scaled_input_base;
            int last_bits_used;
            int diff;
            int diff_scale = 0;
            if (diff <= 0) {
                for (diff = bits_used - total_bits; diff >= -16384; diff <<= 1) {
                    ++diff_scale;
                }
            } else {
                while (diff < 16384) {
                    ++diff_scale;
                    diff <<= 1;
                }
            }
            int base_delta = diff * factor.value >> 15;
            base_delta = (diff_scale = max_input_scale - (factor.shift + diff_scale - 15)) >= 0 ? (base_delta <<= diff_scale) : (base_delta >>= -diff_scale);
            int num_revisions = 1;
            do {
                last_bits_used = bits_used;
                last_scaled_input_base = scaled_input_base;
                bits_used = CodecImpl.getD(scaled_input, max_input_scale, len, 6, scaled_input_base += base_delta);
            } while (++num_revisions <= 19 && (bits_used - total_bits) * (last_bits_used - total_bits) > 0);
            if (bits_used != total_bits) {
                int dev_2;
                int bits_used_2;
                int bits_used_1;
                int scaled_input_base_1;
                if (bits_used > total_bits) {
                    scaled_input_base_1 = scaled_input_base;
                    scaled_input_base = last_scaled_input_base;
                    bits_used_1 = bits_used;
                    bits_used_2 = last_bits_used;
                } else {
                    scaled_input_base_1 = last_scaled_input_base;
                    bits_used_1 = last_bits_used;
                    bits_used_2 = bits_used;
                }
                while (bits_used != total_bits && num_revisions < 20) {
                    int avg = scaled_input_base + scaled_input_base_1 >> 1;
                    bits_used = CodecImpl.getD(scaled_input, max_input_scale, len, 6, avg);
                    ++num_revisions;
                    if (bits_used > total_bits) {
                        scaled_input_base_1 = avg;
                        bits_used_1 = bits_used;
                        continue;
                    }
                    scaled_input_base = avg;
                    bits_used_2 = bits_used;
                }
                int dev_1 = Math.abs(bits_used_1 - total_bits);
                if (dev_1 < (dev_2 = Math.abs(bits_used_2 - total_bits))) {
                    scaled_input_base = scaled_input_base_1;
                    bits_used = bits_used_1;
                } else {
                    bits_used = bits_used_2;
                }
            }
        }
        for (i = 0; i < len; ++i) {
            int tmp = scaled_input[i] - scaled_input_base;
            tmp = tmp >= 0 ? tmp + (1 << max_input_scale - 1) >> max_input_scale : 0;
            packed_sizes[i] = Math.min(tmp, 6);
        }
        if (bits_used > total_bits) {
            i = 0;
            int bit_count = 0;
            while (bit_count < total_bits) {
                bit_count += packed_sizes[i];
                ++i;
            }
            packed_sizes[i - 1] = total_bits - (bit_count -= packed_sizes[i - 1]);
            bits_used = total_bits;
            while (i < len) {
                packed_sizes[i] = 0;
                ++i;
            }
        }
        return total_bits - bits_used;
    }

    private static int getD(short[] in, int scale, int len, int upper_bound, int base) {
        int d = 0;
        if (len <= 0) {
            return d;
        }
        int var_1 = 1 << scale - 1;
        for (int i = 0; i < len; ++i) {
            int var_2 = in[i] - base;
            var_2 = var_2 < 0 ? 0 : var_2 + var_1 >> scale;
            d += Math.min(var_2, upper_bound);
        }
        return d;
    }

    private static class Factor {
        public final int value;
        public final int shift;

        public Factor(int val) {
            if (val == 124) {
                this.value = 4228;
                this.shift = 19;
                return;
            }
            if (val == 0) {
                this.value = 0;
                this.shift = 0;
                return;
            }
            int sign = (~val >>> 31 << 1) - 1;
            int abs = val * sign;
            int scale = -1;
            while ((abs & 0x8000) == 0) {
                abs <<= 1;
                ++scale;
            }
            this.shift = 27 - scale;
            short table_val = table9[(abs >>= 1) - 15872 >> 10];
            int tmp = abs * table_val;
            tmp = 0x40000000 - tmp;
            tmp += 16384;
            tmp >>= 15;
            tmp *= table_val;
            tmp += 16384;
            int tmp2 = tmp >>= 15;
            tmp *= abs;
            tmp = 0x20000000 - tmp;
            tmp += 16384;
            tmp >>= 15;
            tmp *= tmp2;
            tmp += 8192;
            tmp >>= 14;
            if ((tmp *= sign) > Short.MAX_VALUE && sign == 1) {
                tmp = Short.MAX_VALUE;
            } else if (tmp < Short.MIN_VALUE && sign == -1) {
                tmp = Short.MIN_VALUE;
            }
            this.value = tmp;
        }
    }

    private static class NormalizedInt32 {
        public final int value;
        public final int scale;

        public NormalizedInt32(int val) {
            if (val == 0) {
                this.value = val;
                this.scale = 31;
                return;
            }
            if (val >= 0x40000000) {
                this.value = 0;
                this.scale = 0;
                return;
            }
            int v = val;
            int s = 0;
            if (v > 0) {
                do {
                    ++s;
                } while ((v <<= 1) < 0x40000000);
            } else {
                int floor = Integer.MIN_VALUE;
                do {
                    ++s;
                } while ((v <<= 1) > -1073741824);
            }
            this.value = v;
            this.scale = s;
        }
    }

    private static class BitStream {
        private int byteOffset = 0;
        private int bitOffset = 0;

        private BitStream() {
        }

        public void push(int val, int len, byte[] buf) {
            if (this.bitOffset == 0) {
                buf[this.byteOffset] = (byte)val;
            } else {
                int n = this.byteOffset;
                buf[n] = (byte)(buf[n] | (byte)(val << this.bitOffset));
            }
            this.bitOffset += len;
            if (this.bitOffset >= 8) {
                ++this.byteOffset;
                this.bitOffset -= 8;
                if (this.bitOffset > 0) {
                    buf[this.byteOffset] = (byte)(val >> len - this.bitOffset);
                }
            }
        }

        public int pop(int len, byte[] buf) {
            int val = (buf[this.byteOffset] & 0xFF) >> this.bitOffset;
            int bits_read = 8 - this.bitOffset;
            if (len >= bits_read) {
                ++this.byteOffset;
                if (len > bits_read) {
                    val |= buf[this.byteOffset] << bits_read;
                }
            }
            this.bitOffset = this.bitOffset + len & 7;
            return val & (1 << len) - 1;
        }
    }
}

