
import argparse, json

class Opts(object):

    data_opts = {
        "scenario" : {
            "long_param" : "--scenario",
            "short_param" : "-s",
            "type" : str,
            "help" : "Selenium python script.",
            "required" : True
        },
        "cookies" : {
            "long_param" : "--cookies",
            "short_param" : "-c",
            "type" : json.loads,
            "help" : "Cookies need to access upload form.",
            "required" : False
        },
#        "success_str" : {
#            "long_param" : "--on-success",
#            "short_param" : "-s",
#            "type" : str,
#            "help" : "Displayed string on upload success.",
#            "required" : True
#        },
        "verbosity" : {
            "long_param" : "--verbosity",
            "short_param" : "-v",
            "help" : "Activate verbosity.",
            "action" : "store_true",
            "required" : False
        }
    }

    def __init__(self, argv):
        self.argv = argv
        self.parser = argparse.ArgumentParser(
            description='UpPwn')

    def initialize_options(self):
        for opt_name, content in self.data_opts.iteritems():
            self.add_option(opt_name, content)

    def add_option(self, opt_name, opt_content):
        if "type" in opt_content:
            self.parser.add_argument(opt_content["long_param"],
                        opt_content["short_param"],
                        type=opt_content["type"],
                        help=opt_content["help"],
                        required=opt_content["required"])
        elif "action" in opt_content:
            self.parser.add_argument(opt_content["long_param"],
                        opt_content["short_param"],
                        action=opt_content["action"],
                        help=opt_content["help"],
                        required=opt_content["required"])



    def parse(self):
        return self.parser.parse_args()
