#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_scanelement.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys, os.path,platform

from core.ufo_picsfinder import get_icon
from core import *
from core import ufo_easyboxdecode

class UFOScannViewElement(QListWidgetItem):
    def __init__(self,parent = None):
        QListWidgetItem.__init__(self)
#        super(UFOScannViewElement, self).__init__(parent)

        self.setIcon(get_icon("wifi25.png"))
        self.essidString = " - "
        self.macString=" - "
        self.signalString=" - "
        self.chanString=""
        self.freqString=" - "
        self.encrString=" - "
        self.encrString2=" - "
        self.isKey = False
        self.keyList=[]
        self.isOpen = False
        self.ifaceFlag = False
        self.dBmValue=25
        self.iface =""

    def set_ifaceFlag(self,b):
        self.ifaceFlag = b
        self.setIcon(get_icon("iface.png"))

    def is_iface(self):
        return self.ifaceFlag
        
    def set_signal_icon(self, signal):
        if platform.system() == "Windows":
            try:
                signal = int(signal.replace("%",""))
            except ValueError:
                signal = 1
            if signal >= 0 <= 25:
                self.setIcon(get_icon("wifi25.png"))
            if signal >= 26 <= 50:
                self.setIcon(get_icon("wifi50.png"))
            if signal >= 51 <= 75:
                self.setIcon(get_icon("wifi75.png"))
            if signal >= 76 <= 100:
                self.setIcon(get_icon("wifi100.png"))
    
    
    def set_dbm_value(self, dBm):
        if platform.system() != "Windows":
            self.dBmValue=dBm
            i_dBm = self.dBmValue
        else:
            self.dBmValue = dBm
            i_dBm = dBm
        if  i_dBm >=0 and i_dBm <26:     self.setIcon(get_icon("wifi25.png"))
        if  i_dBm >25 and i_dBm <51:    self.setIcon(get_icon("wifi50.png"))
        if  i_dBm >50 and i_dBm <76:    self.setIcon(get_icon("wifi75.png"))
        if  i_dBm >75 and i_dBm <=100:    self.setIcon(get_icon("wifi100.png"))

    def dbm_to_percentage(self,dbm):
            # In linea di massima: non c'e' una vera corrispondenza tra dBm e percentuale
            dbm =int(dbm)
            if dbm > -55 < 100:                return 100
            if dbm < -55 and dbm > -72:    return 75
            if dbm < -72 and dbm > -84:    return 50
            if dbm < -84:                return 25

    def find_wifi_key(self,essid):
        s = QString(essid)
        self.keyList = "Unknown"
        self.textKey = _("No key found")
        if s.contains("Fastweb-1"):
            self.keyList = ufo_fastwebdecode.calc(s.trimmed().right(12))
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("Thomson") or s.contains("INFINITUM") or s.contains("SpeedTouch") or s.contains("O2Wireless") or s.contains("Orange-") or s.contains("BigPond") or s.contains("Otenet") or s.contains("Bbox-") or s.contains("DMAX") or s.contains("privat"):
            self.keyList = ufo_speeddecode.calc(s.trimmed().right(6))
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("BTHomeHub"):
            self.keyList = ufo_speeddecode.calc(s.trimmed().right(4))
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("TeleTu_") or s.contains("Tele2"):
            self.keyList = ufo_teletudecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("Infostrada-"):
            self.keyList = ufo_infostradadecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("Alice-"):
            self.keyList = ufo_alicedecode.calc(s.trimmed().right(8), self.macString)
            self.keyList_nomac = ufo_alicedecode.calc(s.trimmed().right(8), 0)
            if self.keyList or self.keyList_nomac:
                return self.keyList+self.keyList_nomac
            else:
                return "0"

        elif s.contains("Dlink-"):
            self.keyList = ufo_dlinkdecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("Huawei-"):
            self.keyList = ufo_huaweidecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("JAZZTEL_") or s.contains("WLAN_"):
            self.keyList = ufo_jazzteldecode.calc(s.trimmed().right(4), self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"

        elif s.contains("YaCom") or s.contains("WLAN"):
            self.keyList = ufo_yacomdecode.calc(s.trimmed().right(6),self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"
        elif s.contains("PBS-"):
            self.keyList = ufo_prgdecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"
        elif s.contains("Vodafone-") or s.contains("Arcor-") or s.contains("EasyBox-"):
            self.keyList = ufo_easyboxdecode.calc(self.macString)
            if self.keyList:
                return self.keyList
            else:
                return "0"
        elif s.contains("Discus-") or s.contains("Discus--"):
            self.keyList = ufo_discusdecode.calc(s.trimmed().right(6))
            if self.keyList:
                return self.keyList
            else:
                return "0"
        else:
            return self.keyList

    def set_ssid(self,ssid):
        self.setText(ssid)
        self.essidString = ssid

    def set_mac(self,mac):
        self.macString = mac
        
    def set_iface(self,iface):
        self.iface = iface
        
    def set_signal(self,signal):
        self.signalString = signal

    def set_frequency(self,freq):
        self.freqString = freq

    def set_channel(self,chan):
        self.chanString = chan

    def set_encription(self,encr):
        self.encrString = encr

    def set_encription2(self,encr):
        self.encrString2 = encr

    def set_info(self):
        if self.macString != "":
            self.keyList = self.find_wifi_key(self.essidString)
            if self.keyList:
                if str(self.keyList) != "Unknown" or str(self.keyList) != "0":
                    self.isKey = True
                    self.setForeground(QColor(34,139,34))
                    if type(self.keyList) is list:
                        self.textKey = "\n".join(self.keyList)
                if self.keyList == "Unknown":
                    self.setForeground(QColor(238,0,0)) 
                    self.isKey = False
                    self.textKey = _("Unknown")
                if str(self.keyList) == "0":
                    self.setForeground(QColor(4,156,255))
                    self.isKey = False  
                    self.textKey = _("No key found.")
                    self.keyList = _("Unknwon")
 #           textTip = """Address: %s\nQuality: %s%%\nFrequency: %s\nChannel: %s\nIE Encription: %s\nIEEE Encription: %s\nWifi Key: %s""" % (self.macString, format(self.signalString,'.0f'), self.freqString, self.chanString, self.encrString, self.encrString2, self.keyList) 
            textTip = _("Address: {0}\nQuality: {1}%\nFrequency: {2}\nIface: {3}\nEncription: {4}\nWifi Key: {5}")
            textTip = textTip.format(self.macString, format(self.signalString,'.0f'), self.freqString, self.iface, self.encrString, self.keyList)
            self.setToolTip(textTip)
            


    def set_win_info(self):
        if self.macString != "":
            self.keyList = self.find_wifi_key(self.essidString)
            if self.keyList:
                if str(self.keyList) != "Unknown" or str(self.keyList) != "0":
                    self.isKey = True
                    self.setForeground(QColor(34,139,34))
                    if type(self.keyList) is list:
                        self.textKey = "\n".join(self.keyList)
                        self.textKey = "\n%s" % (self.textKey)
                if self.encrString2 == "none":
                        self.setForeground(QColor(34,139,34))
                        self.textKey = _("None")
                        self.keyList = [_("None")]
                if self.keyList == "Unknown":
                    self.setForeground(QColor(238,0,0)) 
                    self.isKey = False
                    self.textKey = _("Unknown")    
                if str(self.keyList) == "0":
                    self.setForeground(QColor(4,156,255))
                    self.isKey = False  
                    self.textKey = _("No key found.")
                    self.keyList = _("Unknown")
            textTip = _("Address: {0}\nQuality: {1}\nFrequency: {2}\nChannel: {3}\nEncription: {4}/{5}\nWifi Key: {6}")
            textTip = textTip.format(self.macString, self.signalString, self.freqString, self.chanString, self.encrString,self.encrString2, self.textKey)
            self.setToolTip(textTip)

    def get_ssid(self):
        return self.essidString

    def get_mac(self):
        return self.macString

    def get_signal(self):
        return self.signalString

    def get_frequency(self):
        return self.freqString

    def get_iface(self):
        return self.iface
        
    def get_channel(self):
        return self.chanString

    def get_encription(self):
        return self.encrString

    def get_encription2(self):
        return self.encrString2
        
    def get_keyList(self):
        return self.keyList
     
    def get_isKey(self):
        return self.isKey
        
    def set_isKey(self,b):
        self.isKey = b
