#!/usr/bin/python
'''
//=============================================================================
//
//  File : ufo_scannerguy.py
//  Creation date : Wed Dec 05 14:30:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                        Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys, os, os.path
import re

from core.ufo_picsfinder import *

class UFOIconLabel(QWidget):
    def __init__(self, parent=None):
        super(UFOIconLabel, self).__init__(parent)
        s = QHBoxLayout(self)
        self.styleWidget = QWidget(self)
        s.addWidget(self.styleWidget)
        hBoxLayout = QHBoxLayout(self.styleWidget)
        hBoxLayout.setAlignment(Qt.AlignLeft)
        self.pixLabel = QLabel(self.styleWidget)
        self.textLabel = QLabel(self.styleWidget)
        self.pixLabel.setPixmap(get_pixmap("ufonm.png"))
        self.textLabel.setText(_("UFO Network Manager"))
        hBoxLayout.addWidget(self.pixLabel)
        hBoxLayout.addWidget(self.textLabel)
        #self.setLayout(hBoxLayout)
        
    def setLabelPixmap(self,pix):
        self.pixLabel.setPixmap(pix)
        
    def setLabelText(self,s):
        self.textLabel.setText(s)
        
    def getText(self):
        return self.textLabel.text()
        
    def setLabelTextName(self,s):
        self.textLabel.setObjectName(s)
        
    def setLabelPixmapName(self,s):
        self.pixLabel.setObjectName(s)
        
    def setLabelWidgetName(self,s):
        self.styleWidget.setObjectName(s)
