/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.util.SecurityProviderConstants;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger publicExponent;
    private int keySize;
    private SecureRandom random;

    public RSAKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_RSA_KEY_SIZE, null);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        try {
            RSAKeyFactory.checkKeyLengths(n, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.keySize = n;
        this.random = secureRandom;
        this.publicExponent = RSAKeyGenParameterSpec.F4;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        int n = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        } else {
            if (bigInteger.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be 3 or larger");
            }
            if (bigInteger.bitLength() > n) {
                throw new InvalidAlgorithmParameterException("Public exponent must be smaller than key size");
            }
        }
        try {
            RSAKeyFactory.checkKeyLengths(n, bigInteger, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", invalidKeyException);
        }
        this.keySize = n;
        this.publicExponent = bigInteger;
        this.random = secureRandom;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        int n = this.keySize + 1 >> 1;
        int n2 = this.keySize - n;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        BigInteger bigInteger7 = this.publicExponent;
        do {
            bigInteger4 = BigInteger.probablePrime(n, this.random);
            do {
                if (bigInteger4.compareTo(bigInteger2 = BigInteger.probablePrime(n2, this.random)) >= 0) continue;
                bigInteger5 = bigInteger4;
                bigInteger4 = bigInteger2;
                bigInteger2 = bigInteger5;
            } while ((bigInteger = bigInteger4.multiply(bigInteger2)).bitLength() < this.keySize);
        } while (!bigInteger7.gcd(bigInteger6 = (bigInteger5 = bigInteger4.subtract(BigInteger.ONE)).multiply(bigInteger3 = bigInteger2.subtract(BigInteger.ONE))).equals(BigInteger.ONE));
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger6);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger5);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger2.modInverse(bigInteger4);
        try {
            RSAPublicKeyImpl rSAPublicKeyImpl = new RSAPublicKeyImpl(bigInteger, bigInteger7);
            RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(bigInteger, bigInteger7, bigInteger8, bigInteger4, bigInteger2, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKeyImpl, rSAPrivateCrtKeyImpl);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }
}

