/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.CompletionHandlerWrapper;
import jdk.management.resource.internal.FutureWrapper;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.AsynchronousServerSocketChannelImpl")
public class AsynchronousServerSocketChannelImplRMHooks {
    @InstrumentationMethod
    public final SocketAddress getLocalAddress() throws IOException {
        return this.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public final AsynchronousServerSocketChannel bind(SocketAddress socketAddress, int n) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open socket channels", resourceRequestDeniedException);
            }
        }
        int n2 = 0;
        AsynchronousServerSocketChannel asynchronousServerSocketChannel = null;
        try {
            asynchronousServerSocketChannel = this.bind(socketAddress, n);
            n2 = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n2), resourceIdImpl);
            }
        }
        return asynchronousServerSocketChannel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InstrumentationMethod
    public final Future<AsynchronousSocketChannel> accept() {
        long l;
        ResourceRequest resourceRequest;
        ResourceIdImpl resourceIdImpl;
        Future<AsynchronousSocketChannel> future = this.accept();
        if (future.isDone()) {
            AsynchronousSocketChannel asynchronousSocketChannel;
            try {
                asynchronousSocketChannel = future.get();
            }
            catch (InterruptedException interruptedException) {
                CompletableFuture<AsynchronousSocketChannel> completableFuture = new CompletableFuture<AsynchronousSocketChannel>();
                completableFuture.completeExceptionally(interruptedException);
                return completableFuture;
            }
            catch (ExecutionException executionException) {
                CompletableFuture<AsynchronousSocketChannel> completableFuture = new CompletableFuture<AsynchronousSocketChannel>();
                completableFuture.completeExceptionally(executionException.getCause());
                return completableFuture;
            }
            resourceIdImpl = null;
            try {
                resourceIdImpl = ResourceIdImpl.of(asynchronousSocketChannel.getLocalAddress());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(asynchronousSocketChannel);
            l = 0L;
            ResourceRequestDeniedException resourceRequestDeniedException = null;
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    resourceRequestDeniedException = new ResourceRequestDeniedException("Resource limited: too many open server socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException2) {
                resourceRequestDeniedException = resourceRequestDeniedException2;
            }
            if (resourceRequestDeniedException != null) {
                resourceRequest.request(-l, resourceIdImpl);
                try {
                    asynchronousSocketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CompletableFuture<AsynchronousSocketChannel> completableFuture = new CompletableFuture<AsynchronousSocketChannel>();
                completableFuture.completeExceptionally(resourceRequestDeniedException);
                return completableFuture;
            }
        } else {
            FutureWrapper<AsynchronousSocketChannel> futureWrapper = new FutureWrapper<AsynchronousSocketChannel>(future);
            return futureWrapper;
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        return future;
    }

    @InstrumentationMethod
    public final <A> void accept(A a, CompletionHandler<AsynchronousSocketChannel, ? super A> completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("'handler' is null");
        }
        completionHandler = new CompletionHandlerWrapper<AsynchronousSocketChannel, A>(completionHandler);
        this.accept(a, completionHandler);
    }
}

