/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.naming.CommunicationException;

final class LdapRequest {
    LdapRequest next;
    int msgId;
    private int gotten = 0;
    private BlockingQueue<BerDecoder> replies;
    private int highWatermark = -1;
    private boolean cancelled = false;
    private boolean pauseAfterReceipt = false;
    private boolean completed = false;

    LdapRequest(int n, boolean bl) {
        this(n, bl, -1);
    }

    LdapRequest(int n, boolean bl, int n2) {
        this.msgId = n;
        this.pauseAfterReceipt = bl;
        if (n2 == -1) {
            this.replies = new LinkedBlockingQueue<BerDecoder>();
        } else {
            this.replies = new LinkedBlockingQueue<BerDecoder>(n2);
            this.highWatermark = n2 * 80 / 100;
        }
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.notify();
    }

    synchronized boolean addReplyBer(BerDecoder berDecoder) {
        if (this.cancelled) {
            return false;
        }
        try {
            this.replies.put(berDecoder);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            this.completed = berDecoder.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        berDecoder.reset();
        this.notify();
        if (this.highWatermark != -1 && this.replies.size() >= this.highWatermark) {
            return true;
        }
        return this.pauseAfterReceipt;
    }

    synchronized BerDecoder getReplyBer() throws CommunicationException {
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        BerDecoder berDecoder = (BerDecoder)this.replies.poll();
        return berDecoder;
    }

    synchronized boolean hasSearchCompleted() {
        return this.completed;
    }
}

