/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    private static final long serialVersionUID = -7332541893877932896L;
    protected byte[] subnet = null;
    protected int prefix = -1;

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = byArray.length;
        byte[] byArray2 = null;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "BINARY ARRAY :");
            StringBuffer stringBuffer = new StringBuffer();
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append((byArray[n3] & 0xFF) + ":");
            }
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", stringBuffer.toString());
        }
        if ((n2 = this.prefix / 8) == n4) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "The mask is the complete address, strange..." + n4);
            }
            byArray2 = byArray;
            return byArray2;
        }
        if (n2 > n4) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        n3 = n2;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Partially covered index : " + n3);
        }
        byte by = byArray[n3];
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Partially covered byte : " + by);
        }
        int n5 = this.prefix % 8;
        int n6 = 0;
        n6 = n5 == 0 ? n3 : n3 + 1;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Remains : " + n5);
        }
        int n7 = 0;
        for (n = 0; n < n5; ++n) {
            n7 = (byte)(n7 | 1 << 7 - n);
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Mask value : " + (n7 & 0xFF));
        }
        n = (byte)(by & n7);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Masked byte : " + (n & 0xFF));
        }
        byArray2 = new byte[n6];
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Resulting subnet : ");
        }
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
            if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", (byArray2[i] & 0xFF) + ":");
        }
        if (n5 != 0) {
            byArray2[n3] = n;
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Last subnet byte : " + (byArray2[n3] & 0xFF));
            }
        }
        return byArray2;
    }

    public NetMaskImpl(String string, int n) throws UnknownHostException {
        super(string);
        this.prefix = n;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    @Override
    public boolean addMember(Principal principal) {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PrincipalImpl || object instanceof NetMaskImpl) {
            PrincipalImpl principalImpl = (PrincipalImpl)object;
            InetAddress inetAddress = principalImpl.getAddress();
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "Received Address : " + inetAddress);
            }
            byte[] byArray = inetAddress.getAddress();
            for (int i = 0; i < this.subnet.length; ++i) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "(recAddr[i]) : " + (byArray[i] & 0xFF));
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "(recAddr[i] & subnet[i]) : " + (byArray[i] & this.subnet[i] & 0xFF) + " subnet[i] : " + (this.subnet[i] & 0xFF));
                }
                if ((byArray[i] & this.subnet[i]) == this.subnet[i]) continue;
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "FALSE");
                }
                return false;
            }
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(Principal principal) {
        return (principal.hashCode() & super.hashCode()) == principal.hashCode();
    }

    @Override
    public Enumeration<? extends Principal> members() {
        Vector<NetMaskImpl> vector = new Vector<NetMaskImpl>(1);
        vector.addElement(this);
        return vector.elements();
    }

    @Override
    public boolean removeMember(Principal principal) {
        return true;
    }

    @Override
    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }
}

