/*
 * Decompiled with CFR 0.152.
 */
package rtlspektrum;

import java.io.File;
import java.net.URISyntaxException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import rtlspektrum.RtlpowerLibrary;
import rtlspektrum.RtlsdrLibrary;
import rtlspektrum.channel_solve;
import rtlspektrum.misc_settings;
import rtlspektrum.sine_table;
import rtlspektrum.tuning_state;

public class Rtlspektrum {
    private int deviceId;
    private Pointer dev = null;
    private misc_settings ms = new misc_settings();
    private Pointer<tuning_state> tunes = Pointer.allocateArray(tuning_state.class, (long)4000L);
    private Pointer<sine_table> s_tables = Pointer.allocateArray(sine_table.class, (long)32L);
    private int tune_count = 0;
    private double[] dbmBuffer = null;
    private double[] dbmRelativeBuffer = null;
    private int[] subbufferShifts = null;
    private int scanPos = 0;
    private final Lock dbmBufferLock = new ReentrantLock();
    private misc_settings.window_fn_callback window_callback = null;
    private Thread autoScanThread = null;
    private boolean stopScanThread = false;
    private RelativeModeType relMode = RelativeModeType.NONE;
    public static final int AUTO_GAIN = -100;
    private static final String[] nativeLibraries = new String[]{"rtlsdr", "rtlpower"};

    public static String[] getDevices() {
        Rtlspektrum.loadNativeLibs();
        int deviceCount = RtlsdrLibrary.rtlsdr_get_device_count();
        String[] ret = new String[deviceCount];
        Pointer serial = Pointer.allocateBytes((long)256L);
        for (int i = 0; i < deviceCount; ++i) {
            RtlsdrLibrary.rtlsdr_get_device_usb_strings(i, null, null, serial);
            ret[i] = RtlsdrLibrary.rtlsdr_get_device_name(i).getCString() + ": " + serial.getCString();
        }
        serial.release();
        return ret;
    }

    public static void loadNativeLibs() {
        File runningPath = null;
        try {
            runningPath = new File(Rtlspektrum.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (runningPath != null) {
            System.out.println(String.format("Loading libs from %s.", runningPath));
            for (String lib : nativeLibraries) {
                String name = "";
                name = Platform.isWindows() ? "lib" + lib + ".dll" : (Platform.isMacOSX() ? "lib" + lib + ".dylib" : "lib" + lib + ".so");
                File targetLibPath = new File(runningPath, name);
                System.out.println(String.format("Library %s file %s.", lib, targetLibPath));
                BridJ.setNativeLibraryFile((String)lib, (File)targetLibPath);
            }
        }
    }

    public Rtlspektrum(int deviceId) {
        Rtlspektrum.loadNativeLibs();
        this.deviceId = deviceId;
    }

    public void setRelativeMode(RelativeModeType relMode) {
        if (this.relMode != relMode && relMode == RelativeModeType.RECORD) {
            for (int i = 0; i < this.dbmBuffer.length; ++i) {
                this.dbmRelativeBuffer[i] = this.dbmBuffer[i];
            }
        } else if (this.relMode != relMode && relMode == RelativeModeType.NONE) {
            this.dbmRelativeBuffer = new double[this.dbmRelativeBuffer.length];
            for (int i = 0; i < this.dbmBuffer.length; ++i) {
                this.dbmBuffer[i] = Double.POSITIVE_INFINITY;
            }
        }
        this.relMode = relMode;
    }

    private void createScannerThread() {
        this.autoScanThread = new Thread(){

            public void run() {
                int i = 0;
                while (!Rtlspektrum.this.stopScanThread) {
                    Rtlspektrum.this.scanOneTune(i);
                    i = i < Rtlspektrum.this.tune_count - 1 ? i + 1 : 0;
                }
            }
        };
    }

    private void initMisc() {
        this.window_callback = new misc_settings.window_fn_callback(){

            public double apply(int int1, int int2) {
                return RtlpowerLibrary.rectangle(int1, int2);
            }
        };
        this.ms.target_rate(2400000);
        this.ms.boxcar(1);
        this.ms.comp_fir_size(0);
        this.ms.crop(0.0);
        this.ms.gain(-100);
        this.ms.window_fn((Pointer<misc_settings.window_fn_callback>)Pointer.getPointer((NativeObject)this.window_callback));
        this.ms.smoothing(0);
        this.ms.peak_hold(0);
        this.ms.linear(0);
    }

    public int openDevice() {
        int ret = 0;
        Pointer ppdev = Pointer.pointerToPointer((Pointer)this.dev);
        ret = RtlsdrLibrary.rtlsdr_open((Pointer<Pointer>)ppdev, this.deviceId);
        if (ret >= 0) {
            this.dev = (Pointer)ppdev.get();
            this.initMisc();
            RtlsdrLibrary.rtlsdr_reset_buffer(this.dev);
        }
        return ret;
    }

    public void setFrequencyRange(int lower, int upper, int step, double crop_grg) {
        int i;
        this.ms.crop(crop_grg);
        channel_solve c = new channel_solve();
        c.lower(lower);
        c.upper(upper);
        c.bin_spec(step);
        this.tune_count = RtlpowerLibrary.frequency_range((Pointer<misc_settings>)Pointer.getPointer((NativeObject)this.ms), this.tunes, (Pointer<channel_solve>)Pointer.getPointer((NativeObject)c), this.tune_count);
        RtlpowerLibrary.generate_sine_tables(this.s_tables, this.tunes, this.tune_count);
        int bufferSize = 0;
        this.subbufferShifts = new int[this.tune_count];
        for (i = 0; i < this.tune_count; ++i) {
            tuning_state ts = (tuning_state)((Object)this.tunes.get((long)i));
            ts.gain(this.ms.gain());
            this.subbufferShifts[i] = bufferSize;
            bufferSize += ts.crop_i2() - ts.crop_i1() + 1;
        }
        this.dbmBuffer = new double[bufferSize];
        this.dbmRelativeBuffer = new double[bufferSize];
        for (i = 0; i < bufferSize; ++i) {
            this.dbmRelativeBuffer[i] = Double.POSITIVE_INFINITY;
        }
    }

    public void clearFrequencyRange() {
        this.stopAutoScan();
        RtlpowerLibrary.free_frequency_range(this.tunes, this.tune_count);
        this.tune_count = 0;
    }

    public void startAutoScan() {
        if (this.autoScanThread != null && this.autoScanThread.isAlive()) {
            return;
        }
        this.createScannerThread();
        this.stopScanThread = false;
        this.autoScanThread.start();
    }

    public void stopAutoScan() {
        if (this.autoScanThread == null) {
            return;
        }
        if (this.autoScanThread.isAlive()) {
            this.stopScanThread = true;
            try {
                this.autoScanThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public double[] getDbmBuffer() {
        if (this.dbmBuffer == null) {
            return null;
        }
        double[] ret = new double[this.dbmBuffer.length];
        this.dbmBufferLock.lock();
        try {
            System.arraycopy(this.dbmBuffer, 0, ret, 0, this.dbmBuffer.length);
        }
        finally {
            this.dbmBufferLock.unlock();
        }
        return ret;
    }

    public int getScanPos() {
        return this.scanPos;
    }

    public void setGain(int gain) {
        boolean restart = this.autoScanThread.isAlive();
        this.stopAutoScan();
        this.ms.gain(gain);
        for (int i = 0; i < this.tune_count; ++i) {
            tuning_state ts = (tuning_state)((Object)this.tunes.get((long)i));
            ts.gain(gain);
        }
        if (restart) {
            this.startAutoScan();
        }
    }

    public int[] getGains() {
        Pointer gains = null;
        int count = RtlsdrLibrary.rtlsdr_get_tuner_gains(this.dev, gains);
        gains = Pointer.allocateInts((long)count);
        RtlsdrLibrary.rtlsdr_get_tuner_gains(this.dev, (Pointer<Integer>)gains);
        int[] ret = new int[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = (Integer)gains.get((long)i);
        }
        return ret;
    }

    public void setOffsetTunning(boolean enabled) {
        if (enabled) {
            RtlsdrLibrary.rtlsdr_set_offset_tuning(this.dev, 1);
        } else {
            RtlsdrLibrary.rtlsdr_set_offset_tuning(this.dev, 0);
        }
    }

    public void setDirectSampling(int state) {
        RtlsdrLibrary.rtlsdr_set_direct_sampling(this.dev, state);
    }

    public void setCorrection(int ppm) {
        RtlsdrLibrary.rtlsdr_set_freq_correction(this.dev, ppm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanOneTune(int index) {
        tuning_state ts = (tuning_state)((Object)this.tunes.get((long)index));
        int bufferShift = this.subbufferShifts[index];
        RtlpowerLibrary.scan_tune(this.dev, (Pointer<tuning_state>)Pointer.getPointer((NativeObject)ts));
        this.scanPos = bufferShift + (ts.crop_i2() - ts.crop_i1());
        this.dbmBufferLock.lock();
        try {
            for (int j = 0; j <= ts.crop_i2() - ts.crop_i1(); ++j) {
                this.dbmBuffer[bufferShift + j] = (Double)ts.dbm().get((long)j);
                if (this.relMode == RelativeModeType.RECORD) {
                    this.dbmRelativeBuffer[bufferShift + j] = this.dbmRelativeBuffer[bufferShift + j] == Double.POSITIVE_INFINITY ? this.dbmBuffer[bufferShift + j] : (this.dbmRelativeBuffer[bufferShift + j] + this.dbmBuffer[bufferShift + j]) / 2.0;
                    this.dbmBuffer[bufferShift + j] = this.dbmRelativeBuffer[bufferShift + j];
                    continue;
                }
                if (this.relMode != RelativeModeType.RELATIVE) continue;
                this.dbmBuffer[bufferShift + j] = this.dbmBuffer[bufferShift + j] - this.dbmRelativeBuffer[bufferShift + j];
            }
        }
        finally {
            this.dbmBufferLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelativeModeType {
        NONE,
        RECORD,
        RELATIVE;

    }
}

