/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Matrix
extends Controller<Matrix> {
    protected int cnt;
    protected int[][] _myCells;
    protected int stepX;
    protected int stepY;
    protected int cellX;
    protected int cellY;
    protected boolean isPressed;
    protected int _myCellX;
    protected int _myCellY;
    protected int sum;
    protected int _myInterval = 100;
    protected int currentX = -1;
    protected int currentY = -1;
    protected int _myMode = 1;
    private Thread t;
    protected int gapX = 1;
    protected int gapY = 1;
    private Object _myPlug;
    private String _myPlugName;
    private boolean playing = true;
    private int bg = 0;

    public Matrix(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 10, 10, 0, 0, 100, 100);
        controlP5.register(controlP5.papplet, string, this);
    }

    public Matrix(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(controlP5, controllerGroup, string, n3, n4, n5, n6);
        this.setGrid(n, n2);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        this._myCaptionLabel.align(37, 13);
        this._myCaptionLabel.setPadding(0, 4);
        this.runThread();
    }

    public Matrix setGrid(int n, int n2) {
        this._myCellX = n;
        this._myCellY = n2;
        this.sum = this._myCellX * this._myCellY;
        this.stepX = this.getWidth() / this._myCellX;
        this.stepY = this.getHeight() / this._myCellY;
        this._myCells = new int[this._myCellX][this._myCellY];
        for (int i = 0; i < this._myCellX; ++i) {
            for (int j = 0; j < this._myCellY; ++j) {
                this._myCells[i][j] = 0;
            }
        }
        return this;
    }

    public Matrix setInterval(int n) {
        this._myInterval = n;
        return this;
    }

    public int getInterval() {
        return this._myInterval;
    }

    @Override
    @ControlP5.Invisible
    public Matrix updateInternalEvents(PApplet pApplet) {
        this.setIsInside(this.inside());
        if (this.getIsInside() && this.isPressed) {
            int n = (int)(((float)pApplet.mouseX - Matrix.x(this.position)) / (float)this.stepX);
            int n2 = (int)(((float)pApplet.mouseY - Matrix.y(this.position)) / (float)this.stepY);
            if (n != this.currentX || n2 != this.currentY) {
                boolean bl = this._myCells[n = PApplet.min((int)PApplet.max((int)0, (int)n), (int)this._myCellX)][n2 = PApplet.min((int)PApplet.max((int)0, (int)n2), (int)this._myCellY)] == 1;
                switch (this._myMode) {
                    default: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[n][i] = 0;
                        }
                        this._myCells[n][n2] = !bl ? 1 : this._myCells[n][n2];
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[n][i] = 0;
                        }
                        this._myCells[n][n2] = !bl ? 1 : this._myCells[n][n2];
                        break;
                    }
                    case 2: {
                        this._myCells[n][n2] = this._myCells[n][n2] == 1 ? 0 : 1;
                    }
                }
                this.currentX = n;
                this.currentY = n2;
            }
        }
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = this.getIsInside();
        if (this.getIsInside()) {
            this.isPressed = true;
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        if (this.isActive) {
            this.isActive = false;
        }
        this.isPressed = false;
        this.currentX = -1;
        this.currentY = -1;
    }

    @Override
    public Matrix setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this;
    }

    public Matrix play() {
        this.playing = true;
        return this;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public Matrix pause() {
        this.playing = false;
        return this;
    }

    public Matrix stop() {
        this.playing = false;
        this.cnt = 0;
        return this;
    }

    public Matrix trigger(int n) {
        if (n < 0 || n >= this._myCells.length) {
            return this;
        }
        for (int i = 0; i < this._myCellY; ++i) {
            if (this._myCells[n][i] != 1) continue;
            this._myValue = 0.0f;
            this._myValue = (n << 0) + (i << 8);
            this.setValue(this._myValue);
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                method.invoke(this._myPlug, n, i);
                continue;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public Matrix update() {
        return this.setValue(this._myValue);
    }

    public Matrix setGap(int n, int n2) {
        this.gapX = n;
        this.gapY = n2;
        return this;
    }

    @Override
    public Matrix plugTo(Object object) {
        this._myPlug = object;
        return this;
    }

    @Override
    public Matrix plugTo(Object object, String string) {
        this._myPlug = object;
        this._myPlugName = string;
        return this;
    }

    public Matrix set(int n, int n2, boolean bl) {
        this._myCells[n][n2] = bl ? 1 : 0;
        return this;
    }

    public boolean get(int n, int n2) {
        return this._myCells[n][n2] == 1;
    }

    public Matrix clear() {
        for (int i = 0; i < this._myCells.length; ++i) {
            for (int j = 0; j < this._myCells[i].length; ++j) {
                this._myCells[i][j] = 0;
            }
        }
        return this;
    }

    public static int getX(int n) {
        return n >> 0 & 0xFF;
    }

    public static int getY(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getX(float f) {
        return (int)f >> 0 & 0xFF;
    }

    public static int getY(float f) {
        return (int)f >> 8 & 0xFF;
    }

    public Matrix setCells(int[][] nArray) {
        this.setGrid(nArray.length, nArray[0].length);
        this._myCells = nArray;
        return this;
    }

    public int[][] getCells() {
        return this._myCells;
    }

    private void triggerEventFromThread() {
        if (this.playing) {
            ++this.cnt;
            this.cnt %= this._myCellX;
            this.trigger(this.cnt);
        }
    }

    private void runThread() {
        if (this.t == null) {
            this.t = new Thread(this.getName()){

                @Override
                public void run() {
                    while (true) {
                        Matrix.this.triggerEventFromThread();
                        try {
                            1.sleep(Matrix.this._myInterval);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            this.t.start();
        }
    }

    @Override
    public void remove() {
        if (this.t != null) {
            this.t.interrupt();
        }
        super.remove();
    }

    public Matrix setMode(int n) {
        this._myMode = n;
        return this;
    }

    public int getMode() {
        return this._myMode;
    }

    public Matrix setBackground(int n) {
        this.bg = 0;
        if ((n >> 24 & 0xFF) > 0) {
            this.bg = n >> 24 << 24 | n >> 16 << 16 | n >> 8 << 8 | n >> 0 << 0;
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Matrix updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new MatrixView();
                break;
            }
        }
        return this;
    }

    class MatrixView
    implements ControllerView<Matrix> {
        MatrixView() {
        }

        @Override
        public void display(PGraphics pGraphics, Matrix matrix) {
            pGraphics.noStroke();
            pGraphics.fill(Matrix.this.bg);
            pGraphics.rect(0.0f, 0.0f, (float)Matrix.this.getWidth(), (float)Matrix.this.getHeight());
            float f = Matrix.this.gapX / 2;
            float f2 = Matrix.this.gapY / 2;
            for (int i = 0; i < Matrix.this._myCellX; ++i) {
                for (int j = 0; j < Matrix.this._myCellY; ++j) {
                    pGraphics.fill(Matrix.this._myCells[i][j] == 1 ? Matrix.this.color.getActive() : Matrix.this.color.getBackground());
                    pGraphics.rect((float)(i * Matrix.this.stepX) + f, (float)(j * Matrix.this.stepY) + f2, (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                }
            }
            if (Matrix.this.isInside()) {
                // empty if block
            }
            pGraphics.fill(Matrix.this.color.getActive());
            pGraphics.rect((float)(Matrix.this.cnt * Matrix.this.stepX), 0.0f, 1.0f, (float)(Matrix.this.getHeight() - Matrix.this.gapY));
            if (Matrix.this.isLabelVisible) {
                Matrix.this._myCaptionLabel.draw(pGraphics, 0, 0, matrix);
            }
        }
    }
}

