/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ChartData;
import controlP5.ChartDataSet;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import java.util.Iterator;
import java.util.LinkedHashMap;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Chart
extends Controller<Chart> {
    public static final int LINE = 0;
    public static final int BAR = 1;
    public static final int BAR_CENTERED = 2;
    public static final int HISTOGRAM = 3;
    public static final int PIE = 4;
    public static final int AREA = 5;
    protected final LinkedHashMap<String, ChartDataSet> _myDataSet;
    protected float resolution = 1.0f;
    protected float strokeWeight = 1.0f;
    protected float _myMin = 0.0f;
    protected float _myMax = 1.0f;

    public Chart(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, 200, 100);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Chart(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, int n, int n2) {
        super(controlP5, controllerGroup, string, f, f2, n, n2);
        this.setRange(0.0f, n2);
        this._myDataSet = new LinkedHashMap();
        this.getCaptionLabel().align(37, 13);
        Label.paddingX = 0;
    }

    public Chart setRange(float f, float f2) {
        this._myMin = f;
        this._myMax = f2;
        return this;
    }

    public Chart setColors(String string, int ... nArray) {
        this.getDataSet().get(string).setColors(nArray);
        return this;
    }

    public Chart addData(ChartData chartData) {
        return this.addData(this.getFirstDataSetIndex(), chartData);
    }

    private String getFirstDataSetIndex() {
        return this.getDataSet().keySet().iterator().next();
    }

    private String getLastDataSetIndex() {
        Iterator<String> iterator = this.getDataSet().keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = iterator.next();
        }
        return string;
    }

    public Chart addData(String string, ChartData chartData) {
        this.getDataSet(string).add(chartData);
        return this;
    }

    public Chart addData(float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(this.getFirstDataSetIndex()).add(chartData);
        return this;
    }

    public Chart addData(String string, float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(string).add(chartData);
        return this;
    }

    public Chart addData(ChartDataSet chartDataSet, float f) {
        ChartData chartData = new ChartData(f);
        chartDataSet.add(chartData);
        return this;
    }

    public Chart unshift(float f) {
        return this.unshift(this.getFirstDataSetIndex(), f);
    }

    public Chart unshift(String string, float f) {
        if ((float)this.getDataSet(string).size() > (float)this.getWidth() / this.resolution) {
            this.removeLast(string);
        }
        return this.addFirst(string, f);
    }

    public Chart push(float f) {
        return this.push(this.getFirstDataSetIndex(), f);
    }

    public Chart push(String string, float f) {
        if ((float)this.getDataSet(string).size() > (float)this.getWidth() / this.resolution) {
            this.removeFirst(string);
        }
        return this.addLast(string, f);
    }

    public Chart addFirst(float f) {
        return this.addFirst(this.getFirstDataSetIndex(), f);
    }

    public Chart addFirst(String string, float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(string).add(0, chartData);
        return this;
    }

    public Chart addLast(float f) {
        return this.addLast(this.getFirstDataSetIndex(), f);
    }

    public Chart addLast(String string, float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(string).add(chartData);
        return this;
    }

    public Chart removeLast() {
        return this.removeLast(this.getFirstDataSetIndex());
    }

    public Chart removeLast(String string) {
        return this.removeData(string, this.getDataSet(string).size() - 1);
    }

    public Chart removeFirst() {
        return this.removeFirst(this.getFirstDataSetIndex());
    }

    public Chart removeFirst(String string) {
        return this.removeData(string, 0);
    }

    public Chart removeData(ChartData chartData) {
        this.removeData(this.getFirstDataSetIndex(), chartData);
        return this;
    }

    public Chart removeData(String string, ChartData chartData) {
        this.getDataSet(string).remove(chartData);
        return this;
    }

    public Chart removeData(int n) {
        this.removeData(this.getFirstDataSetIndex(), n);
        return this;
    }

    public Chart removeData(String string, int n) {
        if (this.getDataSet(string).size() < 1) {
            return this;
        }
        this.getDataSet(string).remove(n);
        return this;
    }

    public Chart setData(int n, ChartData chartData) {
        this.getDataSet(this.getFirstDataSetIndex()).set(n, chartData);
        return this;
    }

    public Chart setData(String string, int n, ChartData chartData) {
        this.getDataSet(string).set(n, chartData);
        return this;
    }

    public Chart addDataSet(String string) {
        this.getDataSet().put(string, new ChartDataSet(string));
        return this;
    }

    public Chart setDataSet(ChartDataSet chartDataSet) {
        this.setDataSet(this.getFirstDataSetIndex(), chartDataSet);
        return this;
    }

    public Chart setDataSet(String string, ChartDataSet chartDataSet) {
        this.getDataSet().put(string, chartDataSet);
        return this;
    }

    public Chart removeDataSet(String string) {
        this.getDataSet().remove(string);
        return this;
    }

    public Chart setData(float ... fArray) {
        this.setData(this.getFirstDataSetIndex(), fArray);
        return this;
    }

    public Chart setData(String string, float ... fArray) {
        int n;
        if (this.getDataSet().get(string).size() != fArray.length) {
            this.getDataSet().get(string).clear();
            for (n = 0; n < fArray.length; ++n) {
                this.getDataSet().get(string).add(new ChartData(0.0f));
            }
        }
        n = 0;
        this.resolution = (float)this.getWidth() / (float)(this.getDataSet().get(string).size() - 1);
        for (float f : fArray) {
            ((ChartData)this.getDataSet().get(string).get(n++)).setValue(f);
        }
        return this;
    }

    public Chart updateData(float ... fArray) {
        return this.setData(fArray);
    }

    public Chart updateData(String string, float ... fArray) {
        return this.setData(string, fArray);
    }

    public LinkedHashMap<String, ChartDataSet> getDataSet() {
        return this._myDataSet;
    }

    public ChartDataSet getDataSet(String string) {
        return this.getDataSet().get(string);
    }

    public float[] getValuesFrom(String string) {
        return this.getDataSet(string).getValues();
    }

    public ChartData getData(String string, int n) {
        return (ChartData)this.getDataSet(string).get(n);
    }

    public int size() {
        return this.getDataSet().size();
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onLeave() {
    }

    @Override
    public Chart setValue(float f) {
        return this;
    }

    public Chart setStrokeWeight(float f) {
        this.strokeWeight = f;
        for (ChartDataSet chartDataSet : this.getDataSet().values()) {
            chartDataSet.setStrokeWeight(f);
        }
        return this;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public Chart setResolution(int n) {
        this.resolution = n;
        return this;
    }

    public int getResolution() {
        return (int)this.resolution;
    }

    @Override
    @ControlP5.Invisible
    public Chart updateDisplayMode(int n) {
        return this.updateViewMode(n);
    }

    @ControlP5.Invisible
    public Chart updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new ChartViewPie();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return this;
    }

    public Chart setView(int n) {
        switch (n) {
            case 4: {
                this.setView(new ChartViewPie());
                break;
            }
            case 0: {
                this.setView(new ChartViewLine());
                break;
            }
            case 1: {
                this.setView(new ChartViewBar());
                break;
            }
            case 2: {
                this.setView(new ChartViewBarCentered());
                break;
            }
            case 5: {
                this.setView(new ChartViewArea());
                break;
            }
            default: {
                System.out.println("Sorry, this ChartView does not exist");
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tChart\n" + super.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] Chart (" + this.getClass().getSuperclass() + ")";
    }

    public class ChartViewPie
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics pGraphics, Chart chart) {
            pGraphics.pushStyle();
            pGraphics.pushMatrix();
            Iterator<String> iterator = Chart.this.getDataSet().keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                float f = 0.0f;
                for (int i = 0; i < Chart.this.getDataSet(string).size(); ++i) {
                    f += ((ChartData)Chart.this.getDataSet(string).get(i)).getValue();
                }
                float f2 = (float)Math.PI * 2 / f;
                float f3 = -1.5707964f;
                pGraphics.noStroke();
                for (int i = 0; i < Chart.this.getDataSet(string).size(); ++i) {
                    pGraphics.fill(Chart.this.getDataSet(string).getColor(i));
                    float f4 = f3 + ((ChartData)Chart.this.getDataSet(string).get(i)).getValue() * f2;
                    float f5 = PApplet.max((float)0.0f, (float)PApplet.map((float)Chart.this.getWidth(), (float)0.0f, (float)200.0f, (float)0.05f, (float)0.01f));
                    pGraphics.arc(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight(), f3 - f5, f4);
                    f3 = f4;
                }
                pGraphics.translate(0.0f, (float)(Chart.this.getHeight() + 10));
            }
            pGraphics.popMatrix();
            pGraphics.popStyle();
        }
    }

    public class ChartViewArea
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics pGraphics, Chart chart) {
            pGraphics.pushStyle();
            pGraphics.fill(Chart.this.getColor().getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            pGraphics.noStroke();
            Iterator<String> iterator = Chart.this.getDataSet().keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                float f = (float)Chart.this.getWidth() / (float)(Chart.this.getDataSet(string).size() - 1);
                pGraphics.fill(Chart.this.getDataSet(string).getColor(0));
                pGraphics.beginShape();
                pGraphics.vertex(0.0f, (float)Chart.this.getHeight());
                for (int i = 0; i < Chart.this.getDataSet(string).size(); ++i) {
                    float f2 = PApplet.map((float)((ChartData)Chart.this.getDataSet(string).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)Chart.this.getHeight(), (float)0.0f);
                    pGraphics.vertex((float)i * f, PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)f2)));
                }
                pGraphics.vertex((float)Chart.this.getWidth(), (float)Chart.this.getHeight());
                pGraphics.endShape(2);
            }
            pGraphics.noStroke();
            pGraphics.popStyle();
        }
    }

    public class ChartViewLine
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics pGraphics, Chart chart) {
            pGraphics.pushStyle();
            pGraphics.fill(Chart.this.getColor().getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            pGraphics.noFill();
            Iterator<String> iterator = Chart.this.getDataSet().keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                pGraphics.stroke(Chart.this.getDataSet(string).getColor(0));
                pGraphics.strokeWeight(Chart.this.getDataSet(string).getStrokeWeight());
                pGraphics.beginShape();
                float f = (float)Chart.this.getWidth() / (float)(Chart.this.getDataSet(string).size() - 1);
                for (int i = 0; i < Chart.this.getDataSet(string).size(); ++i) {
                    float f2 = PApplet.map((float)((ChartData)Chart.this.getDataSet(string).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)Chart.this.getHeight(), (float)0.0f);
                    pGraphics.vertex((float)i * f, PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)f2)));
                }
                pGraphics.endShape();
            }
            pGraphics.noStroke();
            pGraphics.popStyle();
            Chart.this.getCaptionLabel().draw(pGraphics, 0, 0, chart);
        }
    }

    public class ChartViewBarCentered
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics pGraphics, Chart chart) {
            pGraphics.pushStyle();
            pGraphics.fill(Chart.this.getColor().getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            pGraphics.noStroke();
            Iterator<String> iterator = Chart.this.getDataSet().keySet().iterator();
            String string = null;
            float f = 0.0f;
            int n = 4;
            int n2 = (Chart.this.getDataSet().size() - 1) * n;
            while (iterator.hasNext()) {
                string = iterator.next();
                int n3 = Chart.this.getDataSet(string).size();
                float f2 = (float)Chart.this.getWidth() / (float)n3;
                float f3 = f2 - (float)Chart.this.getWidth() % f2;
                f3 -= 1.0f;
                f3 = PApplet.max((float)1.0f, (float)f3);
                for (int i = 0; i < n3; ++i) {
                    pGraphics.fill(Chart.this.getDataSet(string).getColor(i));
                    f3 = (float)(Chart.this.getWidth() / n3) * 0.5f;
                    float f4 = PApplet.map((float)((ChartData)Chart.this.getDataSet(string).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)0.0f, (float)Chart.this.getHeight());
                    pGraphics.rect((float)(-n2 / 2) + f + (float)(i * (Chart.this.getWidth() / n3)) + f3 / 2.0f, (float)Chart.this.getHeight(), f3, -PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)f4)));
                }
                f += (float)n;
            }
            pGraphics.popStyle();
        }
    }

    public class ChartViewBar
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics pGraphics, Chart chart) {
            pGraphics.pushStyle();
            pGraphics.fill(Chart.this.getColor().getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            pGraphics.noStroke();
            Iterator<String> iterator = Chart.this.getDataSet().keySet().iterator();
            String string = null;
            float f = 0.0f;
            while (iterator.hasNext()) {
                string = iterator.next();
                float f2 = Chart.this.getDataSet(string).size();
                int n = 0;
                while ((float)n < f2) {
                    pGraphics.fill(Chart.this.getDataSet(string).getColor(n));
                    float f3 = (float)Chart.this.getWidth() / f2;
                    float f4 = PApplet.map((float)((ChartData)Chart.this.getDataSet(string).get(n)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)0.0f, (float)Chart.this.getHeight());
                    pGraphics.rect(f + (float)n * f3, (float)Chart.this.getHeight(), f3 / (float)Chart.this.getDataSet().size(), -PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)f4)));
                    ++n;
                }
                f += (float)Chart.this.getWidth() / f2 / (float)Chart.this.getDataSet().size();
            }
            pGraphics.popStyle();
        }
    }
}

