/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControllerInterface;
import java.io.Serializable;

public class CColor
implements Serializable {
    private int colorBackground = -16763310;
    private int colorSelectedBackground = -1;
    private int colorForeground = -16750196;
    private int colorActive = -16211249;
    private int colorCaptionLabel = -1;
    private int colorValueLabel = -1;
    private int colorBackgroundAlpha = 255;
    private int colorForegroundAlpha = 255;
    private int colorActiveAlpha = 255;
    private int colorCaptionLabelAlpha = 255;
    private int colorValueLabelAlpha = 255;
    private int alpha = 255;
    private int maskA = 0xFFFFFF;
    int maskR = -16711681;
    int maskG = -65281;
    int maskB = -256;

    protected CColor set(CColor cColor) {
        this.colorBackground = cColor.colorBackground;
        this.colorSelectedBackground = cColor.colorSelectedBackground;
        this.colorForeground = cColor.colorForeground;
        this.colorActive = cColor.colorActive;
        this.colorCaptionLabel = cColor.colorCaptionLabel;
        this.colorValueLabel = cColor.colorValueLabel;
        this.colorBackgroundAlpha = cColor.colorBackgroundAlpha;
        this.colorForegroundAlpha = cColor.colorForegroundAlpha;
        this.colorActiveAlpha = cColor.colorActiveAlpha;
        this.colorCaptionLabelAlpha = cColor.colorCaptionLabelAlpha;
        this.colorValueLabelAlpha = cColor.colorValueLabelAlpha;
        return this;
    }

    protected CColor copyTo(ControllerInterface<?> controllerInterface) {
        controllerInterface.setColorBackground(this.colorBackground);
        controllerInterface.setColorForeground(this.colorForeground);
        controllerInterface.setColorActive(this.colorActive);
        controllerInterface.setColorLabel(this.colorCaptionLabel);
        return this;
    }

    public String toString() {
        return "bg (" + (this.colorBackground >> 16 & 0xFF) + "," + (this.colorBackground >> 8 & 0xFF) + "," + (this.colorBackground >> 0 & 0xFF) + "), fg (" + (this.colorForeground >> 16 & 0xFF) + "," + (this.colorForeground >> 8 & 0xFF) + "," + (this.colorForeground >> 0 & 0xFF) + "), active (" + (this.colorActive >> 16 & 0xFF) + "," + (this.colorActive >> 8 & 0xFF) + "," + (this.colorActive >> 0 & 0xFF) + "), captionlabel (" + (this.colorCaptionLabel >> 16 & 0xFF) + "," + (this.colorCaptionLabel >> 8 & 0xFF) + "," + (this.colorCaptionLabel >> 0 & 0xFF) + "), valuelabel (" + (this.colorValueLabel >> 16 & 0xFF) + "," + (this.colorValueLabel >> 8 & 0xFF) + "," + (this.colorValueLabel >> 0 & 0xFF) + ")";
    }

    public CColor() {
        this.set(ControlP5.getColor());
    }

    public CColor(int n, int n2, int n3, int n4, int n5) {
        this.setForeground(n);
        this.setBackground(n2);
        this.setActive(n3);
        this.setCaptionLabel(n4);
        this.setValueLabel(n5);
    }

    public CColor(CColor cColor) {
        this.set(cColor);
    }

    public CColor setAlpha(int n) {
        System.out.println("controlP5.CColor.setAlpha: setting alpha values disabled for this version of controlP5.");
        return this;
    }

    public CColor setForeground(int n) {
        this.colorForeground = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public CColor setBackground(int n) {
        this.colorBackground = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public CColor setSelectedBackground(int n) {
        this.colorSelectedBackground = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public CColor setActive(int n) {
        this.colorActive = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public CColor setCaptionLabel(int n) {
        this.colorCaptionLabel = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public CColor setValueLabel(int n) {
        this.colorValueLabel = (n & 0xFF000000) == 0 ? -16777216 : n;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getForeground() {
        return this.colorForeground;
    }

    public int getBackground() {
        return this.colorBackground;
    }

    public int getSelectedBackground() {
        return this.colorSelectedBackground;
    }

    public int getActive() {
        return this.colorActive;
    }

    public int getCaptionLabel() {
        return this.colorCaptionLabel;
    }

    public int getValueLabel() {
        return this.colorValueLabel;
    }

    public int hashCode() {
        int n = 23;
        n = 37 * n + this.colorBackground;
        n = 37 * n + this.colorForeground;
        n = 37 * n + this.colorActive;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CColor cColor = (CColor)object;
        return this.colorBackground == cColor.colorBackground && this.colorForeground == cColor.colorForeground && this.colorActive == cColor.colorActive && this.colorCaptionLabel == cColor.colorCaptionLabel && this.colorValueLabel == cColor.colorValueLabel;
    }
}

