/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.DropdownList;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.core.PApplet;
import processing.core.PFont;
import processing.data.Table;
import processing.event.MouseEvent;
import processing.serial.Serial;
import rtlspektrum.Rtlspektrum;

public class spektrum
extends PApplet {
    Serial myPort;
    Rtlspektrum spektrumReader;
    ControlP5 cp5;
    DataPoint[] scaledBuffer;
    boolean startingupBypassSaveConfiguration = true;
    int reloadConfigurationAfterStartUp = 0;
    int CONFIG_RELOAD_DELAY = 30;
    int movingCursor = 0;
    String tmpMessage;
    String tmpMessage1;
    final int NONE = 0;
    int tabActiveID = 1;
    String tabActiveName = "default";
    final int TAB_HEIGHT = 25;
    final int TAB_HEIGHT_ACTIVE = 30;
    final int TAB_GENERAL = 1;
    final int TAB_MEASURE = 2;
    final int TAB_SETTINGS = 3;
    final int TAB_SARK100 = 4;
    String[] tabLabels = new String[]{"global", "SETUP", "MEASURE", "SETTINGS", "NOT YET", "WHO ARE YOU"};
    final int ITEM_GAIN = 1;
    final int ITEM_FREQUENCY = 2;
    final int ITEM_ZOOM = 3;
    final int ITEM_RF_GAIN = 4;
    final int IF_TYPE_NONE = 0;
    final int IF_TYPE_ABOVE = 1;
    final int IF_TYPE_BELOW = 2;
    final int nrOfConfigurations = 10;
    final int PRESET_SAVE = 1;
    final int PRESET_LOAD = 2;
    int configurationOperation = 0;
    int CONFIG_SAVE_DELAY = 80;
    configurationClass[] configSet = new configurationClass[10];
    int configurationActive = 0;
    String configurationName;
    DropdownList configurationDropdown;
    int configurationSaveDelay = 0;
    int timeToSet = 0;
    int itemToSet = 0;
    int infoText1X = 0;
    int infoText1Y = 0;
    int infoColor = -16711873;
    int infoLineX = 0;
    int infoLineY = 0;
    int[] infoRectangle = new int[4];
    String infoText = "";
    int lastWidth = 0;
    int zoomBackFreqMin = 0;
    int zoomBackFreqMax = 0;
    int zoomBackScalMin = 0;
    int zoomBackScalMax = 0;
    int fullRangeMin = 24000000;
    int fullRangeMax = 1800000000;
    int fullScaleMin = -110;
    int fullScaleMax = 40;
    int startFreq = 88000000;
    int stopFreq = 108000000;
    int binStep = 1000;
    int binStepProtection = 200;
    int vertCursorFreq = 88000000;
    int tmpFreq = 0;
    int rfGain = 0;
    int ifOffset = 0;
    int ifType = 0;
    int cropPercent = 0;
    int scaleMin = -110;
    int scaleMax = 40;
    int uiNextLineIndex = 0;
    int[][] uiLines = new int[10][10];
    final int GRAPH_DRAG_NONE = 0;
    final int GRAPH_DRAG_STARTED = 1;
    final int GRAPH_DRAG_ENDED = 0;
    int mouseDragGraph = 0;
    int dragGraphStartX;
    int dragGraphStartY;
    int cursorVerticalLeftX = -1;
    int cursorVerticalRightX = -1;
    int cursorHorizontalTopY = -1;
    int cursorHorizontalBottomY = -1;
    int cursorVerticalLeftX_Color = -13395457;
    int cursorHorizontalBottomY_Color = -13395457;
    int cursorVerticalRightX_Color = -32555;
    int cursorHorizontalTopY_Color = -32555;
    int cursorDeltaColor = -16719856;
    ListBox deviceDropdown;
    DropdownList gainDropdown;
    DropdownList serialDropdown;
    String[] devices;
    int[] gains;
    int relMode = 0;
    double minFrequency;
    double minValue;
    double minScaledValue;
    double maxFrequency;
    double maxValue;
    double maxScaledValue;
    boolean minmaxDisplay = false;
    boolean sweepDisplay = false;
    int showInfoScreen = 0;
    infoScreen infoHelp;
    Table table;
    String fileName = "config.csv";
    boolean setupDone = false;
    boolean frozen = true;
    boolean vertCursor = false;
    float minMaxTextX = 10.0f;
    float minMaxTextY = 660.0f;
    int deltaLabelsX;
    int deltaLabelsY;
    int deltaLabelsXWaiting;
    int deltaLabelsYWaiting;
    boolean overGraph = false;
    boolean mouseDragLock = false;
    int startDraggingThr = 5;
    int lastMouseX;
    int buttonColor = this.color(70, 70, 70);
    int buttonColorText = this.color(255, 255, 230);
    int setButtonColor = this.color(127, 0, 0);
    int clickMeButtonColor = this.color(20, 200, 20);
    int willSaveButtonColor = this.color(200, 20, 20);
    boolean drawSampleToggle = false;
    boolean vertCursorToggle = true;
    boolean drawFill = false;
    boolean refShow = false;
    boolean refStoreFlag = false;
    DataPoint[] refArray;
    boolean refArrayHasData = false;
    int refYoffset = 0;
    DataPoint[] avgArray;
    boolean avgShow = false;
    boolean avgArrayHasData = false;
    int avgDepth = 10;
    int avgNewSampleWeight = 1;
    boolean avgSamples = false;
    DataPoint[] perArray;
    boolean perShowMax = false;
    boolean perShowMin = false;
    boolean perShowMed = false;
    boolean perArrayHasData = false;
    int lastScanPosition = 0;
    int scanPosition = 0;
    int completeCycles = 0;
    int tabColorBachground = this.color(0, 70, 80);

    public void MsgBox(String Msg, String Title) {
        JOptionPane.showMessageDialog(null, Msg, Title, 0);
    }

    public void setupStartControls() {
        int width = 170;
        int x = 15;
        int y = 40;
        this.deviceDropdown = (ListBox)((ListBox)this.cp5.addListBox("deviceDropdown").setBarHeight(20).setItemHeight(20).setPosition((float)x, (float)y)).setSize(width, 20 + this.devices.length * 30);
        this.deviceDropdown.getCaptionLabel().align(37, 12).setText("Select device");
        int i = 0;
        while (i < this.devices.length) {
            this.deviceDropdown.addItem(this.devices[i], (Object)i);
            ++i;
        }
        this.scaledBuffer = new DataPoint[0];
    }

    public void setupControls() {
        int width = 170;
        ((Tab)((Tab)this.cp5.addTab("default").setColorLabel(this.color(255))).activateEvent(true).setId(1)).setLabel(this.tabLabels[1]).setHeight(30);
        this.background(this.color(-14539996));
        int x = 15;
        int y = 10;
        this.uiNextLineIndex = 0;
        this.uiLines[this.uiNextLineIndex++][1] = y;
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("receiverLabel").setText("RECEIVER RANGE:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        ((Textfield)this.cp5.addTextfield("startFreqText").setPosition((float)x, (float)(y += 35))).setSize(width - 50, 20).setText(spektrum.str((int)this.startFreq)).setAutoClear(false).getCaptionLabel().align(37, 12).setText("Start frequency [Hz]");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("resetMin").setPosition((float)(width - 30), (float)y)).setSize(40, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("|<< RST");
        ((Textfield)this.cp5.addTextfield("stopFreqText").setPosition((float)x, (float)(y += 40))).setSize(width - 50, 20).setText(spektrum.str((int)this.stopFreq)).setAutoClear(false).getCaptionLabel().align(37, 12).setText("End frequency [Hz]");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("resetMax").setPosition((float)(width - 30), (float)y)).setSize(40, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("RST >>|");
        ((Textfield)this.cp5.addTextfield("binStepText").setPosition((float)x, (float)(y += 40))).setSize(60, 20).setText(spektrum.str((int)this.binStep)).setAutoClear(true).getCaptionLabel().align(37, 12).setText("Bin size [Hz]");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("setRangeButton").setValue(0.0f).setPosition(95.0f, (float)y)).setSize(width / 2, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Set range");
        this.uiLines[this.uiNextLineIndex++][1] = y += 10;
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("ifLabel").setText("UP/DOWN CONVERTER:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        ((Textfield)this.cp5.addTextfield("ifOffset").setPosition((float)x, (float)(y += 30))).setSize(90, 20).setText(spektrum.str((int)this.binStep)).setAutoClear(true).getCaptionLabel().align(37, 12).setText("IF Frequency");
        ((Textfield)this.cp5.get(Textfield.class, "ifOffset")).setText(spektrum.str((int)this.ifOffset));
        ((Toggle)((Toggle)this.cp5.addToggle("ifPlusToggle").setPosition((float)(x + 100), (float)y)).setSize(20, 20)).getCaptionLabel().align(3, 12).setText("Above");
        ((Toggle)((Toggle)this.cp5.addToggle("ifMinusToggle").setPosition((float)(x + 140), (float)y)).setSize(20, 20)).getCaptionLabel().align(3, 12).setText("Below");
        this.uiLines[this.uiNextLineIndex++][1] = y;
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("optionsLabel").setText("VARIOUS OPTIONS:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        ((Toggle)((Toggle)this.cp5.addToggle("vertCursorToggle").setPosition((float)x, (float)(y += 35))).setSize(20, 20)).getCaptionLabel().align(3, 12).setText("Cursors");
        ((Toggle)((Toggle)this.cp5.addToggle("drawSampleToggle").setPosition((float)(x + 70), (float)y)).setSize(20, 20)).getCaptionLabel().align(3, 12).setText("Line/Dots");
        ((Toggle)((Toggle)this.cp5.addToggle("drawFill").setPosition((float)(x + 140), (float)y)).setSize(20, 20)).getCaptionLabel().align(3, 12).setText("Filled Graph");
        ((Toggle)((Toggle)this.cp5.addToggle("offsetToggle").setPosition((float)x, (float)(y += 40))).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("Offset tunning");
        ((Toggle)((Toggle)this.cp5.addToggle("minmaxToggle").setPosition((float)(x + 70), (float)y)).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("Min/Max");
        ((Toggle)((Toggle)this.cp5.addToggle("sweepToggle").setPosition((float)(x + 140), (float)y)).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("Sweep");
        ((Textfield)this.cp5.addTextfield("cropPrcntTxt").setPosition((float)x, (float)(y += 40))).setSize(60, 20).setText(spektrum.str((int)this.cropPercent)).setAutoClear(false).getCaptionLabel().align(37, 12).setText("Crop percent (0-70%)");
        this.uiLines[this.uiNextLineIndex++][1] = y;
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("configLabel").setText("CONFIGURATION PRESETS:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        Table tmpTable = this.loadTable(this.fileName, "header");
        ((Textfield)this.cp5.addTextfield("presetName").setPosition((float)x, (float)(y += 35))).setSize(100, 20).setText(tmpTable.getString(0, "configName")).setAutoClear(false).getCaptionLabel().align(37, 12).setText("Current preset");
        this.configurationDropdown = (DropdownList)((DropdownList)((DropdownList)this.cp5.addDropdownList("configurationList").setBarHeight(20).setItemHeight(20).setPosition((float)x, (float)y)).setSize(100, 80)).hide();
        this.configurationDropdown.getCaptionLabel().align(37, 12).setText(this.configurationName);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("selectPreset").setPosition((float)(x + 105), (float)y)).setSize(20, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("...");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("savePreset").setPosition((float)(x + 135), (float)y)).setSize(40, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Save to");
        int i = 0;
        while (i < 10) {
            this.configurationDropdown.addItem(tmpTable.getString(i, "configName"), (Object)i);
            ++i;
        }
        y += 30;
        y = this.graphHeight() - 130;
        this.uiLines[this.uiNextLineIndex++][1] = y - 40;
        ((Button)((Button)((Button)((Button)this.cp5.addButton("freezeDisplay").setPosition((float)x, (float)y)).setSize(width / 2 - 5, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Pause");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("exitProgram").setPosition((float)(x + width / 2 + 5), (float)y)).setSize(width / 2 - 5, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Exit");
        this.uiLines[this.uiNextLineIndex++][1] = 0;
        ((Tab)((Tab)this.cp5.addTab(this.tabLabels[2]).setColorBackground(this.tabColorBachground)).activateEvent(true).setId(2)).setHeight(25);
        y = 10;
        this.uiNextLineIndex = 0;
        this.uiLines[this.uiNextLineIndex++][2] = y;
        Textlabel tmpLabel = ((Textlabel)((Textlabel)this.cp5.addTextlabel("verticalLabel").setText("VERTICAL SCALE & RF GAIN:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        tmpLabel.moveTo(this.tabLabels[2]);
        ((Textfield)this.cp5.addTextfield("scaleMinText").setPosition(70.0f, (float)(y += 35))).setSize(25, 20).setText(spektrum.str((int)this.scaleMin)).setAutoClear(false).getCaptionLabel().align(37, 12).setText("Lower");
        this.cp5.getController("scaleMinText").moveTo(this.tabLabels[2]);
        ((Textfield)this.cp5.addTextfield("scaleMaxText").setPosition(100.0f, (float)y)).setSize(25, 20).setText(spektrum.str((int)this.scaleMax)).setAutoClear(false).getCaptionLabel().align(37, 12).setText("Upper");
        this.cp5.getController("scaleMaxText").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("setScale").setPosition(130.0f, (float)y)).setSize(60, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Set scale");
        this.cp5.getController("setScale").moveTo(this.tabLabels[2]);
        ((Textlabel)this.cp5.addTextlabel("label").setText("GAIN").setPosition((float)(x + 10), (float)(y - 12))).setSize(20, 20);
        this.cp5.getController("label").moveTo(this.tabLabels[2]);
        ((Knob)this.cp5.addKnob("rfGain").setRange((float)this.gains[0], (float)this.gains[this.gains.length - 1]).setValue(50.0f).setPosition((float)(x + 10), (float)y)).setRadius(15.0f).setDragDirection(1).getCaptionLabel().align(37, 12).setText("");
        this.cp5.getController("rfGain").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("rfGain00").setPosition((float)x, (float)(y + 40))).setSize(9, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("rfGain01").setPosition((float)(x + 10), (float)(y + 40))).setSize(9, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("rfGain02").setPosition((float)(x + 20), (float)(y + 40))).setSize(9, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("rfGain03").setPosition((float)(x + 30), (float)(y + 40))).setSize(9, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("");
        ((Button)((Button)((Button)((Button)this.cp5.addButton("rfGain04").setPosition((float)(x + 40), (float)(y + 40))).setSize(9, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("");
        this.cp5.getController("rfGain00").moveTo(this.tabLabels[2]);
        this.cp5.getController("rfGain01").moveTo(this.tabLabels[2]);
        this.cp5.getController("rfGain02").moveTo(this.tabLabels[2]);
        this.cp5.getController("rfGain03").moveTo(this.tabLabels[2]);
        this.cp5.getController("rfGain04").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("autoScale").setPosition(70.0f, (float)(y += 40))).setSize(55, 20)).setColorLabel(this.buttonColorText)).setColorBackground(this.buttonColor)).getCaptionLabel().align(3, 3).setText("Auto scale");
        this.cp5.getController("autoScale").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("resetScale").setPosition(130.0f, (float)y)).setSize(60, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Reset scale");
        this.cp5.getController("resetScale").moveTo(this.tabLabels[2]);
        this.uiLines[this.uiNextLineIndex++][2] = y;
        tmpLabel = ((Textlabel)((Textlabel)this.cp5.addTextlabel("avgLabel").setText("VIDEO AVERAGING :").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        tmpLabel.moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("avgShow").setPosition((float)x, (float)(y += 35))).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("ON/OFF");
        this.cp5.getController("avgShow").moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("avgSamples").setPosition((float)(x + 70), (float)y)).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("Freeze");
        this.cp5.getController("avgSamples").moveTo(this.tabLabels[2]);
        ((Textfield)this.cp5.addTextfield("avgDepthTxt").setSize(30, 20).setPosition((float)(x + 130), (float)y)).setText(spektrum.str((int)this.avgDepth)).setAutoClear(true).getCaptionLabel().align(37, 12).setText("Depth");
        this.cp5.getController("avgDepthTxt").moveTo(this.tabLabels[2]);
        this.uiLines[this.uiNextLineIndex++][2] = y;
        tmpLabel = ((Textlabel)((Textlabel)this.cp5.addTextlabel("refLabel").setText("REFERENCE GRAPH:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        tmpLabel.moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("refShow").setPosition((float)x, (float)(y += 35))).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("Show");
        this.cp5.getController("refShow").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("refSave").setPosition(50.0f, (float)y)).setSize(width / 2 - 5, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Save Reference");
        this.cp5.getController("refSave").moveTo(this.tabLabels[2]);
        ((Knob)this.cp5.addKnob("refYoffset").setRange((float)(-this.graphHeight()), (float)this.graphHeight()).setValue(50.0f).setPosition(150.0f, (float)(y - 10))).setRadius(15.0f).setDragDirection(1).getCaptionLabel().align(37, 12).setText("");
        this.cp5.getController("refYoffset").moveTo(this.tabLabels[2]);
        this.uiLines[this.uiNextLineIndex++][2] = y;
        tmpLabel = ((Textlabel)((Textlabel)this.cp5.addTextlabel("persistenceLabel").setText("MIN, MAX, MEDIAN HOLD :").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        tmpLabel.moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("perShowMaxToggle").setPosition((float)x, (float)(y += 35))).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("MAX");
        this.cp5.getController("perShowMaxToggle").moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("perShowMedToggle").setPosition((float)(x + 35), (float)y)).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("med");
        this.cp5.getController("perShowMedToggle").moveTo(this.tabLabels[2]);
        ((Toggle)((Toggle)this.cp5.addToggle("perShowMinToggle").setPosition((float)(x + 70), (float)y)).setSize(20, 20)).setValue(false).getCaptionLabel().align(37, 12).setText("MIN");
        this.cp5.getController("perShowMinToggle").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("perReset").setPosition((float)(x + 130), (float)y)).setSize(40, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("RESET");
        this.cp5.getController("perReset").moveTo(this.tabLabels[2]);
        this.uiLines[this.uiNextLineIndex++][2] = y;
        tmpLabel = ((Textlabel)((Textlabel)this.cp5.addTextlabel("zoomLabel").setText("PRESET / RETURN TO PREVIOUS:").setPosition((float)(x - 13), (float)(y += 35))).setColorValue(-256)).setFont(this.createFont("ARIAL", 10.0f));
        tmpLabel.moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("presetRestore").setPosition((float)x, (float)(y += 25))).setSize(width / 2 - 5, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Pre-set");
        this.cp5.getController("presetRestore").moveTo(this.tabLabels[2]);
        ((Button)((Button)((Button)((Button)this.cp5.addButton("zoomBack").setPosition((float)(x + width / 2 + 5), (float)y)).setSize(width / 2 - 5, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("Back");
        this.cp5.getController("zoomBack").moveTo(this.tabLabels[2]);
        this.uiLines[this.uiNextLineIndex++][2] = y += 10;
        ((Button)((Button)((Button)this.cp5.addButton("toggleRelMode").setPosition((float)x, (float)(y += 50))).setSize(width, 20)).setColorBackground(-9437184)).getCaptionLabel().align(3, 3).setText("Relative mode");
        this.cp5.getController("toggleRelMode").moveTo(this.tabLabels[2]);
        y = this.graphHeight() - 120;
        this.uiLines[this.uiNextLineIndex++][1] = 0;
        ((Button)((Button)((Button)((Button)this.cp5.addButton("helpShow").setPosition(60.0f, (float)(y + 110))).setSize(80, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("HELP");
        this.cp5.getController("helpShow").moveTo("global");
        ((Textarea)this.cp5.addTextarea("textArea01").setPosition(0.0f, 0.0f)).setSize(1, 1).setText("");
        this.deltaLabelsYWaiting = y + 60;
        this.deltaLabelsXWaiting = x + 10;
        this.deltaLabelsY = this.deltaLabelsYWaiting;
        this.deltaLabelsX = this.deltaLabelsXWaiting;
        this.minMaxTextY = this.height - 50;
        this.loadConfigPostCreation();
        spektrum.println((String)"Reached end of setupControls.");
        this.startingupBypassSaveConfiguration = false;
    }

    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isTab()) {
            this.cp5.getTab(this.tabActiveName).setHeight(25);
            this.tabActiveID = theEvent.getTab().getId();
            theEvent.getTab().setHeight(30);
            this.tabActiveName = theEvent.getTab().getName();
        }
        if (theEvent.isController()) {
            spektrum.println((String)theEvent.getController().getName());
            if (theEvent.getController().getName() == "rfGain") {
                spektrum.println((String)"RF GAIN CLICKED");
            }
        }
    }

    public void cropPrcntTxt(String tmpText) {
        this.cropPercent = spektrum.parseInt((String)tmpText);
        this.cropPercent = spektrum.max((int)spektrum.min((int)70, (int)this.cropPercent), (int)0);
        ((Textfield)this.cp5.get(Textfield.class, "cropPrcntTxt")).setText(spektrum.str((int)this.cropPercent));
        this.setRangeButton();
    }

    public void configurationList(int confValue) {
        if (this.configurationOperation == 1) {
            this.configurationName = ((Textfield)this.cp5.get(Textfield.class, "presetName")).getText();
            this.table.setString(confValue, "configName", this.configurationName);
            this.saveConfigToIndx(confValue);
            this.configurationDropdown.clear();
            int i = 0;
            while (i < 10) {
                this.configurationDropdown.addItem(this.table.getString(i, "configName"), (Object)i);
                ++i;
            }
            this.configurationActive = confValue;
        } else {
            this.configurationActive = confValue;
            spektrum.println((String)("configurationList: Setting active configuration to " + confValue));
            this.presetRestore();
        }
        this.configurationOperation = 0;
        ((Textfield)this.cp5.get(Textfield.class, "presetName")).setText(this.configurationName);
        this.configurationDropdown.hide();
        ((Button)this.cp5.get(Button.class, "savePreset")).setColorBackground(this.buttonColor);
    }

    public void selectPreset() {
        if (this.configurationDropdown.isVisible()) {
            this.configurationDropdown.hide();
            this.configurationOperation = 0;
            ((Button)this.cp5.get(Button.class, "savePreset")).setColorBackground(this.buttonColor);
        } else {
            this.configurationDropdown.show();
        }
        this.configurationDropdown.bringToFront();
        this.configurationDropdown.open();
    }

    public void savePreset() {
        if (this.configurationOperation != 0) {
            this.configurationOperation = 0;
            this.configurationDropdown.hide();
            this.configurationDropdown.close();
            ((Button)this.cp5.get(Button.class, "savePreset")).setColorBackground(this.buttonColor);
        } else {
            this.configurationOperation = 1;
            this.configurationDropdown.show();
            this.configurationDropdown.open();
            ((Button)this.cp5.get(Button.class, "savePreset")).setColorBackground(this.willSaveButtonColor);
        }
    }

    public void presetRestore() {
        this.loadConfig();
        this.loadConfigPostCreation();
    }

    public void openSerial() {
        spektrum.println((float)this.cp5.getController("serialPort").getValue());
        spektrum.println((float)((DropdownList)this.cp5.get(DropdownList.class, "serialPort")).getValue());
    }

    public void rfGain(int gainValue) {
        this.spektrumReader.setGain(gainValue);
    }

    public void rfGain00(int gainValue) {
        this.rfGain(this.gains[0]);
        ((Knob)this.cp5.get(Knob.class, "rfGain")).setValue((float)this.gains[0]);
    }

    public void rfGain01(int gainValue) {
        int tpmInt = this.gains[0] + (this.gains[this.gains.length - 1] - this.gains[0]) * 1 / 3;
        this.rfGain(tpmInt);
        ((Knob)this.cp5.get(Knob.class, "rfGain")).setValue((float)tpmInt);
    }

    public void rfGain02(int gainValue) {
        int tpmInt = this.gains[0] + (this.gains[this.gains.length - 1] - this.gains[0]) / 2;
        this.rfGain(tpmInt);
        ((Knob)this.cp5.get(Knob.class, "rfGain")).setValue((float)tpmInt);
    }

    public void rfGain03(int gainValue) {
        int tpmInt = this.gains[0] + (this.gains[this.gains.length - 1] - this.gains[0]) * 2 / 3;
        this.rfGain(tpmInt);
        ((Knob)this.cp5.get(Knob.class, "rfGain")).setValue((float)tpmInt);
    }

    public void rfGain04(int gainValue) {
        this.rfGain(this.gains[this.gains.length - 1]);
        ((Knob)this.cp5.get(Knob.class, "rfGain")).setValue((float)this.gains[this.gains.length - 1]);
    }

    public void ifPlusToggle(int theValue) {
        if (this.setupDone) {
            if (theValue > 0) {
                ((Toggle)this.cp5.get(Toggle.class, "ifMinusToggle")).setValue(0.0f);
                this.ifType = 1;
                this.ifOffset = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "ifOffset")).getText());
            } else {
                this.ifType = 0;
            }
            this.configurationSaveDelay = this.CONFIG_SAVE_DELAY;
        }
    }

    public void ifMinusToggle(int theValue) {
        if (this.setupDone) {
            if (theValue > 0) {
                ((Toggle)this.cp5.get(Toggle.class, "ifPlusToggle")).setValue(0.0f);
                this.ifType = 2;
                this.ifOffset = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "ifOffset")).getText());
            } else {
                this.ifType = 0;
            }
        }
        this.configurationSaveDelay = this.CONFIG_SAVE_DELAY;
    }

    public void offsetToggle(int theValue) {
        if (this.setupDone) {
            if (theValue > 0) {
                this.spektrumReader.setOffsetTunning(true);
            } else {
                this.spektrumReader.setOffsetTunning(false);
            }
        }
    }

    public void minmaxToggle(int theValue) {
        if (this.setupDone) {
            this.minmaxDisplay = theValue > 0;
        }
    }

    public void sweepToggle(int theValue) {
        if (this.setupDone) {
            this.sweepDisplay = theValue > 0;
        }
    }

    public void perShowMaxToggle(int theValue) {
        if (this.setupDone) {
            this.perShowMax = theValue > 0;
        }
    }

    public void perShowMinToggle(int theValue) {
        if (this.setupDone) {
            this.perShowMin = theValue > 0;
        }
    }

    public void perShowMedToggle(int theValue) {
        if (this.setupDone) {
            this.perShowMed = theValue > 0;
        }
    }

    public int ifCorrectedFreq(int inFreq) {
        int tmpFreq = inFreq;
        if (this.ifType == 1) {
            tmpFreq -= this.ifOffset;
        } else if (this.ifType == 2) {
            tmpFreq = this.ifOffset - tmpFreq;
        }
        return tmpFreq;
    }

    public void setRangeButton() {
        this.setRange();
    }

    public void setRange() {
        ((Button)this.cp5.get(Button.class, "setRangeButton")).setColorBackground(this.buttonColor);
        this.cursorVerticalLeftX = -1;
        this.cursorVerticalRightX = -1;
        try {
            this.startFreq = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "startFreqText")).getText());
            this.stopFreq = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).getText());
            this.binStep = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "binStepText")).getText());
            this.cropPercent = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "cropPrcntTxt")).getText());
        }
        catch (Exception exception) {
            spektrum.println((String)"setRange exception.");
        }
        if (this.startFreq == 0 || this.stopFreq <= this.startFreq || this.binStep < 1) {
            return;
        }
        this.configurationSaveDelay = this.CONFIG_SAVE_DELAY;
        double tmpCrop = (float)spektrum.max((int)spektrum.min((int)70, (int)this.cropPercent), (int)0) / 100.0f;
        this.relMode = 0;
        this.spektrumReader.clearFrequencyRange();
        this.spektrumReader.setFrequencyRange(this.startFreq, this.stopFreq, this.binStep, tmpCrop);
        this.spektrumReader.startAutoScan();
        spektrum.println((String)("setRange: CROP set to " + tmpCrop));
    }

    public void setScale() {
        ((Button)this.cp5.get(Button.class, "setScale")).setColorBackground(this.buttonColor);
        this.cursorHorizontalTopY = -1;
        this.cursorHorizontalBottomY = -1;
        try {
            this.scaleMin = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).getText());
            this.scaleMax = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).getText());
        }
        catch (Exception exception) {
            return;
        }
        this.configurationSaveDelay = this.CONFIG_SAVE_DELAY;
    }

    public void resetScale() {
        this.scaleMin = this.fullScaleMin;
        this.scaleMax = this.fullScaleMax;
        ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)this.scaleMin));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)this.scaleMax));
    }

    public void autoScale() {
        if (this.setupDone) {
            if (this.minmaxDisplay) {
                this.scaleMin = (int)(this.minValue - (double)spektrum.abs((float)((float)this.minValue * 0.1f)));
                this.scaleMax = (int)(this.maxValue + (double)spektrum.abs((float)((float)this.maxValue * 0.1f)));
            } else {
                this.scaleMin = (int)(this.minScaledValue - (double)spektrum.abs((float)((float)this.minScaledValue * 0.1f)));
                this.scaleMax = (int)(this.maxScaledValue + (double)spektrum.abs((float)((float)this.maxScaledValue * 0.1f)));
            }
            ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)this.scaleMin));
            ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)this.scaleMax));
        }
    }

    public void refSave() {
        spektrum.println((String)"Flaging for graph storage");
        this.refStoreFlag = true;
    }

    public void perReset() {
        this.perArrayHasData = false;
    }

    public void swapCursors() {
        int tmpInt;
        if (this.cursorVerticalLeftX > this.cursorVerticalRightX) {
            tmpInt = this.cursorVerticalLeftX;
            this.cursorVerticalLeftX = this.cursorVerticalRightX;
            this.cursorVerticalRightX = tmpInt;
        }
        if (this.cursorHorizontalTopY > this.cursorHorizontalBottomY) {
            tmpInt = this.cursorHorizontalTopY;
            this.cursorHorizontalTopY = this.cursorHorizontalBottomY;
            this.cursorHorizontalBottomY = tmpInt;
        }
    }

    public void zoomBack() {
        this.swapCursors();
        ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)this.zoomBackFreqMin));
        ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)this.zoomBackFreqMax));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)this.zoomBackScalMin));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)this.zoomBackScalMax));
        this.zoomBackFreqMin = this.startFreq;
        this.zoomBackFreqMax = this.stopFreq;
        this.zoomBackScalMin = this.scaleMin;
        this.zoomBackScalMax = this.scaleMax;
        this.setScale();
        this.setRange();
    }

    public void zoomIn() {
        this.swapCursors();
        this.zoomBackFreqMin = this.startFreq;
        this.zoomBackFreqMax = this.stopFreq;
        this.zoomBackScalMin = this.scaleMin;
        this.zoomBackScalMax = this.scaleMax;
        ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)(this.startFreq + this.hzPerPixel() * (this.cursorVerticalLeftX - this.graphX()))));
        ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)(this.startFreq + this.hzPerPixel() * (this.cursorVerticalRightX - this.graphX()))));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)(this.scaleMax - (this.cursorHorizontalBottomY - this.graphY()) * this.gainPerPixel() / 1000)));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)(this.scaleMax - (this.cursorHorizontalTopY - this.graphY()) * this.gainPerPixel() / 1000)));
        this.setScale();
        this.setRange();
    }

    public void toggleRelMode(int theValue) {
        if (this.setupDone) {
            ++this.relMode;
            if (this.relMode > 2) {
                this.relMode = 0;
            }
        }
    }

    public void deviceDropdown(int theValue) {
        this.deviceDropdown.hide();
        this.spektrumReader = new Rtlspektrum(theValue);
        int status = this.spektrumReader.openDevice();
        int i = 0;
        while (i < 10) {
            this.configSet[i] = new configurationClass(i + 1);
            ++i;
        }
        this.makeConfig();
        this.loadConfig();
        if (status < 0) {
            this.MsgBox("Can't open rtl-sdr device.", "Spektrum");
            this.exit();
            return;
        }
        this.gains = this.spektrumReader.getGains();
        this.setupControls();
        this.relMode = 0;
        this.setupDone = true;
    }

    public void gainDropdown(int theValue) {
        this.spektrumReader.setGain(this.gains[theValue]);
    }

    public void setup() {
        if (this.frame != null) {
            this.surface.setResizable(true);
        }
        String[] stringArray = this.devices = Rtlspektrum.getDevices();
        int n = this.devices.length;
        int n2 = 0;
        while (n2 < n) {
            String dev = stringArray[n2];
            spektrum.println((String)dev);
            ++n2;
        }
        this.cp5 = new ControlP5((PApplet)this);
        this.setupStartControls();
        spektrum.println((String)"Reached end of setup.");
        this.reloadConfigurationAfterStartUp = this.CONFIG_RELOAD_DELAY;
    }

    public void stop() {
        this.spektrumReader.stopAutoScan();
    }

    public void draw() {
        this.background(this.color(-14539996));
        if (!this.setupDone) {
            return;
        }
        if (this.width != this.lastWidth) {
            this.refShow = false;
            this.avgShow = false;
            spektrum.println((String)"RESIZE DETECTED");
            this.lastWidth = this.width;
            ((Toggle)this.cp5.get(Toggle.class, "refShow")).setValue(0.0f);
            ((Toggle)this.cp5.get(Toggle.class, "avgShow")).setValue(0.0f);
            return;
        }
        if (this.relMode == 1) {
            ((Button)this.cp5.get(Button.class, "toggleRelMode")).getCaptionLabel().setText("Set relative");
            this.spektrumReader.setRelativeMode(Rtlspektrum.RelativeModeType.RECORD);
        } else if (this.relMode == 2) {
            ((Button)this.cp5.get(Button.class, "toggleRelMode")).getCaptionLabel().setText("Cancel relative");
            this.spektrumReader.setRelativeMode(Rtlspektrum.RelativeModeType.RELATIVE);
        } else {
            ((Button)this.cp5.get(Button.class, "toggleRelMode")).getCaptionLabel().setText("Relative mode");
            this.spektrumReader.setRelativeMode(Rtlspektrum.RelativeModeType.NONE);
        }
        double[] buffer = this.spektrumReader.getDbmBuffer();
        this.minValue = Double.POSITIVE_INFINITY;
        this.minScaledValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.maxScaledValue = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < buffer.length) {
            if (this.minValue > buffer[i] && buffer[i] != Double.NEGATIVE_INFINITY) {
                this.minFrequency = this.startFreq + i * this.binStep;
                this.minValue = buffer[i];
            }
            if (this.maxValue < buffer[i] && buffer[i] != Double.POSITIVE_INFINITY) {
                this.maxFrequency = this.startFreq + i * this.binStep;
                this.maxValue = buffer[i];
            }
            ++i;
        }
        this.scaledBuffer = this.scaleBufferX(buffer);
        if (!this.refArrayHasData && this.refShow) {
            this.refArray = new DataPoint[this.scaledBuffer.length];
            this.refShow = false;
            ((Toggle)this.cp5.get(Toggle.class, "refShow")).setValue(0.0f);
        }
        if (this.refShow && this.refArray.length != this.scaledBuffer.length) {
            this.refStoreFlag = true;
            this.refShow = false;
        }
        if (this.refStoreFlag) {
            if (this.avgShow && this.avgArrayHasData) {
                this.refArray = new DataPoint[this.avgArray.length];
                spektrum.arrayCopy((Object)this.avgArray, (Object)this.refArray);
                ((Toggle)this.cp5.get(Toggle.class, "avgShow")).setValue(0.0f);
            } else {
                this.refArray = new DataPoint[this.scaledBuffer.length];
                spektrum.arrayCopy((Object)this.scaledBuffer, (Object)this.refArray);
            }
            this.refArrayHasData = true;
            this.refStoreFlag = false;
            this.refShow = true;
            ((Toggle)this.cp5.get(Toggle.class, "refShow")).setValue(1.0f);
            ((Knob)this.cp5.get(Knob.class, "refYoffset")).setValue(0.0f);
        }
        if (!this.avgArrayHasData && this.avgShow) {
            this.avgArray = new DataPoint[this.scaledBuffer.length];
        }
        if (this.avgShow && this.avgArray.length != this.scaledBuffer.length) {
            this.avgArray = new DataPoint[this.scaledBuffer.length];
        }
        if (!this.perArrayHasData && (this.perShowMin || this.perShowMax || this.perShowMed)) {
            this.perArray = new DataPoint[this.scaledBuffer.length];
        }
        if ((this.perShowMin || this.perShowMax || this.perShowMed) && this.perArray.length != this.scaledBuffer.length) {
            this.perArray = new DataPoint[this.scaledBuffer.length];
        }
        i = 0;
        while (i < this.scaledBuffer.length) {
            if (this.scaledBuffer[i] != null) {
                if (this.minScaledValue > this.scaledBuffer[i].yAvg) {
                    this.minScaledValue = this.scaledBuffer[i].yAvg;
                }
                if (this.maxScaledValue < this.scaledBuffer[i].yAvg) {
                    this.maxScaledValue = this.scaledBuffer[i].yAvg;
                }
            }
            ++i;
        }
        this.drawGraphMatt(this.scaleMin, this.scaleMax, this.startFreq, this.stopFreq);
        double scaleFactor = (double)this.graphHeight() / (double)(this.scaleMax - this.scaleMin);
        DataPoint lastPoint = null;
        DataPoint refLastPoint = null;
        DataPoint avgLastPoint = null;
        DataPoint perLastPoint = null;
        DataPoint point = null;
        DataPoint refPoint = null;
        DataPoint avgPoint = null;
        DataPoint perPoint = null;
        int tmpColorGraph = this.color(200, 200, 40);
        int tmpColorAvg = this.color(10, 200, 40);
        int tmpColorRef = this.color(51, 51, 255);
        int tmpColorPerMax = this.color(180, 180, 180);
        int tmpColorPerMin = this.color(160, 160, 160);
        int tmpColorPerMed = this.color(51, 204, 255);
        int tmpColorFill = this.color(102, 102, 0);
        int tmpAlpha = 255;
        tmpAlpha = this.avgShow || this.perShowMed ? 70 : 255;
        int i2 = 0;
        while (i2 < this.scaledBuffer.length) {
            point = this.scaledBuffer[i2];
            refPoint = null;
            avgPoint = this.scaledBuffer[i2];
            perPoint = this.scaledBuffer[i2];
            if (this.refShow && this.refArrayHasData) {
                refPoint = this.refArray[i2];
            }
            if (this.avgShow && this.avgArrayHasData) {
                avgPoint = this.avgArray[i2];
            }
            if ((this.perShowMin || this.perShowMax || this.perShowMed) && this.perArrayHasData) {
                perPoint = this.perArray[i2];
            }
            if (point != null) {
                if (avgPoint == null) {
                    this.avgArrayHasData = false;
                }
                if (perPoint == null) {
                    this.perArrayHasData = false;
                }
                if (lastPoint != null) {
                    if (this.drawFill) {
                        this.graphDrawFill(lastPoint.x, (int)((lastPoint.yAvg - (double)this.scaleMin) * scaleFactor), point.x, (int)((point.yAvg - (double)this.scaleMin) * scaleFactor), tmpColorFill, 255.0f);
                    }
                    this.graphDrawLine(lastPoint.x, (int)((lastPoint.yAvg - (double)this.scaleMin) * scaleFactor), point.x, (int)((point.yAvg - (double)this.scaleMin) * scaleFactor), tmpColorGraph, tmpAlpha);
                    if (this.minmaxDisplay) {
                        this.graphDrawLine(lastPoint.x, (int)((lastPoint.yMin - (double)this.scaleMin) * scaleFactor), point.x, (int)((point.yMin - (double)this.scaleMin) * scaleFactor), -4048094, 255.0f);
                        this.graphDrawLine(lastPoint.x, (int)((lastPoint.yMax - (double)this.scaleMin) * scaleFactor), point.x, (int)((point.yMax - (double)this.scaleMin) * scaleFactor), -16531396, 255.0f);
                    }
                    if (this.refShow) {
                        this.graphDrawLine(refLastPoint.x, (int)((refLastPoint.yAvg - (double)this.scaleMin) * scaleFactor) - this.refYoffset, refPoint.x, (int)((refPoint.yAvg - (double)this.scaleMin) * scaleFactor) - this.refYoffset, tmpColorRef, 255.0f);
                    }
                    if (this.avgShow) {
                        if (!this.avgArrayHasData) {
                            spektrum.println((String)"STORING Average");
                            this.avgArray = new DataPoint[this.scaledBuffer.length];
                            spektrum.arrayCopy((Object)this.scaledBuffer, (Object)this.avgArray);
                            this.avgArrayHasData = true;
                        } else {
                            if (!this.avgSamples) {
                                if (this.scaledBuffer[i2].yAvg < 1000.0) {
                                    this.avgArray[i2].yAvg = this.avgArray[i2].yAvg - this.avgArray[i2].yAvg / (double)this.avgDepth + this.scaledBuffer[i2].yAvg / (double)this.avgDepth;
                                }
                            } else if (this.completeCycles > 0) {
                                this.avgArray[i2].yAvg = this.avgArray[i2].yAvg - this.avgArray[i2].yAvg / (double)this.avgDepth + this.scaledBuffer[i2].yAvg / (double)this.avgDepth;
                                this.completeCycles = 0;
                            }
                            if (avgLastPoint != null) {
                                this.graphDrawLine(avgLastPoint.x, (int)((avgLastPoint.yAvg - (double)this.scaleMin) * scaleFactor), avgPoint.x, (int)((avgPoint.yAvg - (double)this.scaleMin) * scaleFactor), tmpColorAvg, 255.0f);
                            }
                        }
                    }
                    if (this.perShowMin || this.perShowMax || this.perShowMed) {
                        if (!this.perArrayHasData) {
                            spektrum.println((String)"STORING Persistant");
                            this.perArray = new DataPoint[this.scaledBuffer.length];
                            spektrum.arrayCopy((Object)this.scaledBuffer, (Object)this.perArray);
                            int jj = 0;
                            while (jj < this.scaledBuffer.length - 1) {
                                this.perArray[jj].yMax = this.perArray[jj].yAvg;
                                this.perArray[jj].yMin = this.perArray[jj].yAvg;
                                ++jj;
                            }
                            this.perArrayHasData = true;
                        } else {
                            if (this.scaledBuffer[i2].yAvg > this.perArray[i2].yMax) {
                                this.perArray[i2].yMax = this.scaledBuffer[i2].yAvg;
                            }
                            if (this.scaledBuffer[i2].yAvg < this.perArray[i2].yMin) {
                                this.perArray[i2].yMin = this.scaledBuffer[i2].yAvg;
                            }
                            this.perArray[i2].yAvg = this.perArray[i2].yMin + (this.perArray[i2].yMax - this.perArray[i2].yMin) / 2.0;
                            if (perLastPoint != null) {
                                if (this.perShowMax) {
                                    this.graphDrawLine(perLastPoint.x, (int)((perLastPoint.yMax - (double)this.scaleMin) * scaleFactor), perPoint.x, (int)((perPoint.yMax - (double)this.scaleMin) * scaleFactor), tmpColorPerMax, 200.0f);
                                }
                                if (this.perShowMin) {
                                    this.graphDrawLine(perLastPoint.x, (int)((perLastPoint.yMin - (double)this.scaleMin) * scaleFactor), perPoint.x, (int)((perPoint.yMin - (double)this.scaleMin) * scaleFactor), tmpColorPerMin, 200.0f);
                                }
                                if (this.perShowMed) {
                                    this.graphDrawLine(perLastPoint.x, (int)((perLastPoint.yAvg - (double)this.scaleMin) * scaleFactor), perPoint.x, (int)((perPoint.yAvg - (double)this.scaleMin) * scaleFactor), tmpColorPerMed, 255.0f);
                                }
                            }
                        }
                    }
                }
                lastPoint = point;
                refLastPoint = refPoint;
                avgLastPoint = avgPoint;
                perLastPoint = perPoint;
            }
            ++i2;
        }
        this.fill(-14539996);
        this.stroke(-2780641);
        this.textAlign(37);
        this.fill(-4048094);
        this.text("Min: " + String.format("%.2f", this.minFrequency / 1000.0) + "kHz " + String.format("%.2f", this.minValue) + "dB", this.minMaxTextX + 5.0f, this.minMaxTextY + 20.0f);
        this.fill(-16531396);
        this.text("Max: " + String.format("%.2f", this.maxFrequency / 1000.0) + "kHz " + String.format("%.2f", this.maxValue) + "dB", this.minMaxTextX + 5.0f, this.minMaxTextY + 40.0f);
        if (this.vertCursorToggle) {
            this.drawVertCursor();
        }
        this.uiNextLineIndex = 0;
        while (this.uiLines[this.uiNextLineIndex][this.tabActiveID] != 0) {
            this.line(5.0f, this.uiLines[this.uiNextLineIndex][this.tabActiveID] + 30, 195.0f, this.uiLines[this.uiNextLineIndex][this.tabActiveID] + 30);
            ++this.uiNextLineIndex;
        }
        this.scanPosition = this.spektrumReader.getScanPos();
        if (this.lastScanPosition != this.scanPosition) {
            if (this.scanPosition - this.lastScanPosition <= 0) {
                ++this.completeCycles;
            }
            this.lastScanPosition = this.scanPosition;
        }
        if (this.sweepDisplay) {
            int scanPos = (int)((float)this.graphWidth() / (float)buffer.length * (float)this.scanPosition);
            this.sweep(scanPos, -1, 64.0f);
        }
        if (this.cursorVerticalLeftX < 0) {
            this.cursorVerticalLeftX = this.graphX();
        }
        if (this.cursorVerticalRightX < 0) {
            this.cursorVerticalRightX = this.graphX() + this.graphWidth();
        }
        if (this.cursorHorizontalTopY < 0) {
            this.cursorHorizontalTopY = this.graphY();
        }
        if (this.cursorHorizontalBottomY < 0) {
            this.cursorHorizontalBottomY = this.graphY() + this.graphHeight();
        }
        if (this.timeToSet > 1) {
            --this.timeToSet;
            if (this.infoText1X != 0) {
                this.fill(this.infoColor);
                this.textSize(40.0f);
                this.text(this.infoText, this.infoText1X, this.infoText1Y);
                this.textSize(12.0f);
                this.stroke(-1);
                if (this.itemToSet == 2) {
                    this.line(this.infoLineX, this.graphY(), this.infoLineX, this.graphY() + this.graphHeight());
                }
                if (this.itemToSet == 1) {
                    this.line(this.graphX(), this.infoLineY, this.graphX() + this.graphWidth(), this.infoLineY);
                }
                if (this.itemToSet == 3) {
                    this.noFill();
                    this.rect(this.infoRectangle[0], this.infoRectangle[1], this.infoRectangle[2], this.infoRectangle[3]);
                }
            }
        } else if (this.timeToSet == 1) {
            this.timeToSet = 0;
            if (this.itemToSet == 2) {
                this.setRange();
            }
            if (this.itemToSet == 1) {
                this.setScale();
            }
            if (this.itemToSet == 3) {
                this.setScale();
                this.setRange();
            }
            this.infoText1X = 0;
        }
        if (this.configurationSaveDelay > 1) {
            --this.configurationSaveDelay;
        } else if (this.configurationSaveDelay == 1) {
            this.configurationSaveDelay = 0;
            this.saveConfig();
            spektrum.println((String)"TMR: Config saved (after delay).");
        }
    }

    public void helpShow() {
        Textarea tmpTA = (Textarea)this.cp5.get(Textarea.class, "textArea01");
        PFont pfont = this.createFont("Arial", 15.0f, true);
        ControlFont font = new ControlFont(pfont, 15, 50);
        tmpTA.moveTo("global");
        this.tmpMessage = "SPEKTRUM - Quick reference.\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "Mouse operation :-                                                                          \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "Left Mouse Button :                                                                         \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Click and Drag on Cursor : Move cursor                                                    \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Double Click : Zoom in defined area (by cursors)                                          \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "Right Mouse Button :                                                                        \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Click : Move primary cursors to mouse pointer                                             \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Double click : Move primary cursors to pointer, store away secondary cursors.             \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Click and Drag : Define an area with primary and secondary cursors. Diff. measurements.   \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "Mouse wheel :                                                                               \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Double click : Reset full ranges (Amplitude and Frequency)                                \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Click and Drag : Move graph in X/Y preserving X/Y delta ranges (Pan graph)                \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Rotate on top/bottom of graph to change corresponding Amplitude limit                     \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Rotate on left/right of graph to change corresponding frequency limit                     \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "- Rotate in middle of graph to change zoom level (X and Y)                                  \n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n\n";
        this.tmpMessage = String.valueOf(this.tmpMessage) + "\n";
        this.tmpMessage1 = "Tips\n\n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "- On rotary knobs (eg RF gain) left click and drag up/down for fast adjustment. \n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "- An average graph may also be saved as reference if it is active when the 'SAVE REFERENCE'\n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "  Button is clicked        \n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "- Crop (percent) will make the graph smoother but slower. Enter a value between 0 and 70 and\n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "  press [ENTER]\n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "\n\n\n\n\n\n\n\n\n\n\n\n\n";
        this.tmpMessage1 = String.valueOf(this.tmpMessage1) + "\n";
        if (this.showInfoScreen == 0) {
            tmpTA.setPosition((float)(this.graphX() + 10), (float)(this.graphY() + 10));
            tmpTA.setSize(this.graphWidth() - 20, this.graphHeight() - 20);
            tmpTA.setColorBackground(-8355712);
            tmpTA.setText(String.valueOf(this.tmpMessage) + this.tmpMessage1);
            tmpTA.setFont(font);
            ((Button)((Button)((Button)((Button)this.cp5.addButton("closeHelp").setPosition((float)(this.graphX() + this.graphWidth() - 60), (float)(this.graphY() + 15))).setSize(40, 20)).setColorBackground(this.buttonColor)).setColorLabel(this.buttonColorText)).getCaptionLabel().align(3, 3).setText("CLOSE");
            this.showInfoScreen = 1;
        } else {
            this.showInfoScreen = 0;
            tmpTA.clear();
            tmpTA.setPosition(0.0f, -20.0f);
            tmpTA.setSize(10, 10);
            ((Button)this.cp5.get(Button.class, "closeHelp")).remove();
        }
    }

    public void closeHelp() {
        this.helpShow();
    }

    public void avgShow(int value) {
        if (value == 1) {
            this.avgShow = true;
            this.avgArrayHasData = false;
            this.avgDepth = spektrum.max((int)spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "avgDepthTxt")).getText()), (int)2);
        } else {
            this.avgShow = false;
            this.avgArrayHasData = false;
        }
    }

    public void freezeDisplay() {
        if (this.frozen) {
            this.frozen = false;
            ((Button)this.cp5.get(Button.class, "freezeDisplay")).getCaptionLabel().setText("Pause");
            this.loop();
            spektrum.println((String)"Display unfrozen.");
        } else {
            this.frozen = true;
            ((Button)this.cp5.get(Button.class, "freezeDisplay")).getCaptionLabel().setText("Run");
            this.noLoop();
            spektrum.println((String)"Display frozen.");
        }
    }

    public void exitProgram() {
        spektrum.println((String)"Exit program rtn.");
        if (this.setupDone) {
            this.exit();
        }
    }

    public void resetMin() {
        ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)this.fullRangeMin));
        this.setRange();
    }

    public void resetMax() {
        ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)this.fullRangeMax));
        this.setRange();
    }

    public void loadConfigPostCreation() {
        ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)this.startFreq));
        ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)this.stopFreq));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)this.scaleMin));
        ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)this.scaleMax));
        if (this.ifType == 1) {
            ((Toggle)this.cp5.get(Toggle.class, "ifMinusToggle")).setValue(0.0f);
            ((Toggle)this.cp5.get(Toggle.class, "ifPlusToggle")).setValue(1.0f);
        } else if (this.ifType == 2) {
            ((Toggle)this.cp5.get(Toggle.class, "ifMinusToggle")).setValue(1.0f);
            ((Toggle)this.cp5.get(Toggle.class, "ifPlusToggle")).setValue(0.0f);
        } else {
            ((Toggle)this.cp5.get(Toggle.class, "ifMinusToggle")).setValue(0.0f);
            ((Toggle)this.cp5.get(Toggle.class, "ifPlusToggle")).setValue(0.0f);
        }
        ((Textfield)this.cp5.get(Textfield.class, "ifOffset")).setText(spektrum.str((int)this.ifOffset));
        ((Textfield)this.cp5.get(Textfield.class, "cropPrcntTxt")).setText(spektrum.str((int)this.cropPercent));
        this.setScale();
        this.setRange();
        this.configurationSaveDelay = 0;
    }

    public void loadConfig() {
        this.table = this.loadTable(this.fileName, "header");
        this.startFreq = this.table.getInt(this.configurationActive, "startFreq");
        this.stopFreq = this.table.getInt(this.configurationActive, "stopFreq");
        if (this.startFreq >= this.stopFreq) {
            this.stopFreq = this.startFreq + 100000;
        }
        this.binStep = this.table.getInt(this.configurationActive, "binStep");
        this.scaleMin = this.table.getInt(this.configurationActive, "scaleMin");
        this.scaleMax = this.table.getInt(this.configurationActive, "scaleMax");
        this.fullRangeMin = this.table.getInt(this.configurationActive, "minFreq");
        this.fullRangeMax = this.table.getInt(this.configurationActive, "maxFreq");
        this.ifOffset = this.table.getInt(this.configurationActive, "ifOffset");
        this.ifType = this.table.getInt(this.configurationActive, "ifType");
        this.cropPercent = this.table.getInt(this.configurationActive, "cropPrcnt");
        this.configurationName = this.table.getString(this.configurationActive, "configName");
        if (this.binStep < this.binStepProtection) {
            this.binStep = this.binStepProtection;
        }
        this.cropPercent = spektrum.max((int)spektrum.min((int)70, (int)this.cropPercent), (int)0);
        this.zoomBackFreqMin = this.startFreq;
        this.zoomBackFreqMax = this.stopFreq;
        this.zoomBackScalMin = this.scaleMin;
        this.zoomBackScalMax = this.scaleMax;
        spektrum.println((String)("loadConfig: Config table " + this.fileName + " loaded."));
        spektrum.println((Object[])new Object[]{"startFreq = " + this.startFreq + " stopFreq = " + this.stopFreq + " binStep = " + this.binStep + " scaleMin = " + this.scaleMin + " scaleMax = ", String.valueOf(this.scaleMax) + " rfGain = " + this.rfGain + " fullRangeMin = " + this.fullRangeMin + "  fullRangeMax = " + this.fullRangeMax + " ifOffset = " + this.ifOffset + " ifType = " + this.ifType});
        try {
            ((Textfield)this.cp5.get(Textfield.class, "ifOffset")).setText(spektrum.str((int)this.ifOffset));
        }
        catch (Exception exception) {}
    }

    public void saveConfig() {
        this.saveConfigToIndx(0);
    }

    public void saveConfigToIndx(int configIndx) {
        if (!this.startingupBypassSaveConfiguration) {
            spektrum.println((String)("saveConfig: Active Configuration " + this.configurationActive + " with name " + this.configurationName));
            this.table.setInt(0, "activeConfig", this.configurationActive);
            this.table.setInt(configIndx, "startFreq", this.startFreq);
            this.table.setInt(configIndx, "stopFreq", this.stopFreq);
            this.table.setInt(configIndx, "binStep", this.binStep);
            this.table.setInt(configIndx, "scaleMin", this.scaleMin);
            this.table.setInt(configIndx, "scaleMax", this.scaleMax);
            this.table.setInt(configIndx, "rfGain", this.rfGain);
            this.table.setInt(configIndx, "minFreq", this.fullRangeMin);
            this.table.setInt(configIndx, "maxFreq", this.fullRangeMax);
            this.table.setInt(configIndx, "ifOffset", this.ifOffset);
            this.table.setInt(configIndx, "ifType", this.ifType);
            this.table.setInt(configIndx, "cropPrcnt", this.cropPercent);
            this.saveTable(this.table, this.fileName, "csv");
            spektrum.println((Object[])new Object[]{"STORE TO " + configIndx + " : startFreq = " + this.startFreq + " stopFreq = " + this.stopFreq + " binStep = " + this.binStep + " scaleMin = " + this.scaleMin + " scaleMax = ", String.valueOf(this.scaleMax) + " rfGain = " + this.rfGain + " fullRangeMin = " + this.fullRangeMin + "  fullRangeMax = " + this.fullRangeMax + " ifOffset = " + this.ifOffset + " ifType = " + this.ifType});
            spektrum.println((String)("Config table " + this.fileName + " saved."));
        }
    }

    public void makeConfig() {
        FileWriter fw = null;
        File file = null;
        spektrum.println((String)("File " + this.fileName));
        try {
            file = new File(this.fileName);
            spektrum.println((String)file.getAbsolutePath());
            if (file.exists()) {
                spektrum.println((String)("File " + this.fileName + " exists."));
            } else {
                file.createNewFile();
                fw = new FileWriter(file);
                fw.write("startFreq,stopFreq,binStep,scaleMin,scaleMax,rfGain,minFreq,maxFreq,ifOffset,ifType,cropPrcnt,activeConfig,configName\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,AutoSave\n");
                fw.write("88000000,108000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,FM Band\n");
                fw.write("118000000,178000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,VHF Band+\n");
                fw.write("380000000,450000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,UHF Band+\n");
                fw.write("120000000,170000000,2000,-110,40,0,24000000,1800000000,120000000,1,0,0,Spyverter\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,Config A\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,Config B\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,Config C\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,Config D\n");
                fw.write("24000000,1800000000,2000,-110,40,0,24000000,1800000000,0,0,0,0,Config E\n");
                fw.flush();
                fw.close();
                spektrum.println((String)(String.valueOf(this.fileName) + " created succesfully"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        spektrum.println((String)"Reached end of makeconfig");
    }

    public void drawVertCursor() {
        float cfr_ignored_0 = this.stopFreq - this.startFreq;
        int freqLeft = this.startFreq + this.hzPerPixel() * (this.cursorVerticalLeftX - this.graphX());
        int freqRight = this.startFreq + this.hzPerPixel() * (this.cursorVerticalRightX - this.graphX());
        float scaleBottom = (float)this.scaleMax - (float)((this.cursorHorizontalBottomY - this.graphY()) * this.gainPerPixel()) / 1000.0f;
        float scaleTop = (float)this.scaleMax - (float)((this.cursorHorizontalTopY - this.graphY()) * this.gainPerPixel()) / 1000.0f;
        this.textSize(16.0f);
        this.stroke(this.cursorVerticalLeftX_Color);
        this.fill(this.cursorVerticalLeftX_Color);
        this.line(this.cursorVerticalLeftX, this.graphY(), this.cursorVerticalLeftX, this.graphY() + this.graphHeight());
        this.textAlign(3);
        this.text(String.valueOf(this.numToStr(this.ifCorrectedFreq(freqLeft) / 1000)) + " kHz", this.cursorVerticalLeftX - 10, this.graphY() - 5);
        this.stroke(this.cursorVerticalRightX_Color);
        this.fill(this.cursorVerticalRightX_Color);
        this.line(this.cursorVerticalRightX, this.graphY(), this.cursorVerticalRightX, this.graphY() + this.graphHeight());
        this.textAlign(3);
        this.text(String.valueOf(this.numToStr(this.ifCorrectedFreq(freqRight) / 1000)) + " kHz", this.cursorVerticalRightX - 10, this.graphY() - 5);
        this.stroke(this.cursorHorizontalBottomY_Color);
        this.fill(this.cursorHorizontalBottomY_Color);
        this.line(this.graphX(), this.cursorHorizontalBottomY, this.graphX() + this.graphWidth(), this.cursorHorizontalBottomY);
        this.textAlign(3);
        this.text(String.valueOf(String.format("%.1f", Float.valueOf(scaleBottom))) + " db", this.graphX() + this.graphWidth() + 20, this.cursorHorizontalBottomY + 4);
        this.stroke(this.cursorHorizontalTopY_Color);
        this.fill(this.cursorHorizontalTopY_Color);
        this.line(this.graphX(), this.cursorHorizontalTopY, this.graphX() + this.graphWidth(), this.cursorHorizontalTopY);
        this.textAlign(3);
        this.text(String.valueOf(String.format("%.1f", Float.valueOf(scaleTop))) + " db", this.graphX() + this.graphWidth() + 20, this.cursorHorizontalTopY + 4);
        float tmpVSWR = 1.0f;
        float tmpDdb = 0.0f;
        tmpDdb = spektrum.abs((float)(scaleBottom - scaleTop));
        tmpVSWR = (spektrum.pow((float)10.0f, (float)(tmpDdb / 20.0f)) + 1.0f) / (spektrum.pow((float)10.0f, (float)(tmpDdb / 20.0f)) - 1.0f);
        int labelXOffset = 0;
        int labelYOffset = 0;
        if (this.deltaLabelsX > this.graphX() - 40) {
            labelXOffset = this.deltaLabelsX > this.graphWidth() / 2 ? -140 : 50;
            labelYOffset = this.deltaLabelsY > this.graphHeight() / 2 ? -30 : 60;
        }
        this.textAlign(37);
        this.fill(this.cursorDeltaColor);
        this.text("\u0394x : " + this.numToStr((freqRight - freqLeft) / 1000) + " kHz", this.deltaLabelsX + labelXOffset, this.deltaLabelsY + labelYOffset);
        this.text("\u0394y : " + String.format("%.1f", Float.valueOf(scaleBottom - scaleTop)) + " db", this.deltaLabelsX + labelXOffset, this.deltaLabelsY + 20 + labelYOffset);
        this.textSize(12.0f);
        this.text("VSWR: 1 : " + String.format("%.3f", Float.valueOf(tmpVSWR)), this.deltaLabelsX + labelXOffset, this.deltaLabelsY + 38 + labelYOffset);
        this.textSize(12.0f);
        this.noFill();
        this.stroke(-8355712);
        this.rect(this.deltaLabelsX - 10 + labelXOffset, this.deltaLabelsY - 20 + labelYOffset, 170.0f, 65.0f);
    }

    public String numToStr(int inNum) {
        String outStr = spektrum.nfc((int)inNum);
        return outStr;
    }

    public int getGraphXfromFreq(int frequency) {
        return spektrum.max((int)(this.graphX() - 10), (int)spektrum.min((int)(this.graphX() + this.graphWidth() + 10), (int)(this.graphX() + this.graphWidth() * (frequency / 1000 - this.startFreq / 1000) / (this.stopFreq / 1000 - this.startFreq / 1000))));
    }

    public int getGraphYfromDb(int db) {
        return spektrum.min((int)(this.graphY() + this.graphHeight() + 10), (int)spektrum.max((int)(this.graphY() - 10), (int)(this.graphHeight() + this.graphY() - this.graphHeight() * (db - this.scaleMin) / (this.scaleMax - this.scaleMin))));
    }

    public void mousePressed(MouseEvent evnt) {
        int thisMouseX = this.mouseX;
        int thisMouseY = this.mouseY;
        if (this.mouseX < this.graphX()) {
            return;
        }
        if (this.showInfoScreen > 0) {
            this.closeHelp();
            return;
        }
        if (evnt.getCount() == 2) {
            if (this.mouseButton == 39) {
                this.cursorVerticalRightX = this.graphWidth() + this.graphX();
                this.cursorHorizontalTopY = this.graphY();
            }
            if (this.mouseButton == 3) {
                this.resetMin();
                this.resetMax();
                this.resetScale();
            }
            if (this.mouseButton == 37) {
                this.zoomIn();
            }
            spektrum.println((String)"DOUBLE CLICK DETECTED");
            return;
        }
        if (thisMouseX < this.graphX() || thisMouseX > this.graphWidth() + this.graphX() + 1) {
            return;
        }
        if (thisMouseY < this.graphY() || thisMouseY > this.graphHeight() + this.graphY() + 1) {
            return;
        }
        if (thisMouseX - this.graphX() < this.graphWidth() / 2) {
            // empty if block
        }
        if (thisMouseY - this.graphY() < this.graphHeight() / 2) {
            // empty if block
        }
        int clickFreq = this.startFreq + this.hzPerPixel() * (thisMouseX - this.graphX());
        int clickScale = (thisMouseY - this.graphY()) * this.gainPerPixel() / 1000;
        clickScale = this.scaleMax - clickScale;
        if (this.mouseButton == 39) {
            if (thisMouseX >= this.graphX() && thisMouseX <= this.graphWidth() + this.graphX() + 1) {
                this.mouseDragLock = true;
                this.vertCursorFreq = clickFreq;
                this.lastMouseX = this.mouseX;
                spektrum.println((String)("clickFreq = " + clickFreq));
            }
            this.cursorVerticalLeftX = this.mouseX;
            this.cursorHorizontalBottomY = this.mouseY;
            spektrum.println((String)("clickFreq: " + clickFreq + ",   clickScale: " + clickScale));
        } else if (this.mouseButton == 3) {
            this.mouseDragGraph = 1;
            this.dragGraphStartX = this.mouseX;
            this.dragGraphStartY = this.mouseY;
        } else if (this.mouseButton == 37) {
            int SELECT_THR = 20;
            if (spektrum.abs((int)(this.mouseY - this.cursorHorizontalTopY)) <= SELECT_THR) {
                spektrum.println((String)"TOP LINE");
                spektrum.println((String)("clickScale: " + clickScale));
                ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)clickScale));
                this.sweepVertical(this.mouseY - this.graphY(), -207840, 255.0f);
                this.cursorHorizontalTopY = this.mouseY;
                this.movingCursor = 3;
                ((Button)this.cp5.get(Button.class, "setScale")).setColorBackground(this.clickMeButtonColor);
            } else if (spektrum.abs((int)(this.mouseY - this.cursorHorizontalBottomY)) <= SELECT_THR) {
                spektrum.println((String)"BOTTOM LINE");
                spektrum.println((String)("clickScale: " + clickScale));
                ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)clickScale));
                this.sweepVertical(this.mouseY - this.graphY(), -207840, 255.0f);
                this.cursorHorizontalBottomY = this.mouseY;
                this.movingCursor = 4;
                ((Button)this.cp5.get(Button.class, "setScale")).setColorBackground(this.clickMeButtonColor);
            } else if (spektrum.abs((int)(this.mouseX - this.cursorVerticalLeftX)) <= SELECT_THR) {
                spektrum.println((String)"LEFT LINE");
                spektrum.println((String)("clickFreq: " + clickFreq));
                ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)clickScale));
                this.sweep(this.mouseX - this.graphX(), -207840, 255.0f);
                this.cursorVerticalLeftX = this.mouseX;
                this.movingCursor = 1;
                ((Button)this.cp5.get(Button.class, "setRangeButton")).setColorBackground(this.clickMeButtonColor);
            } else if (spektrum.abs((int)(this.mouseX - this.cursorVerticalRightX)) <= SELECT_THR) {
                spektrum.println((String)"RIGHT LINE");
                spektrum.println((String)("clickFreq: " + clickFreq));
                ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)clickScale));
                this.sweep(this.mouseX - this.graphX(), -207840, 255.0f);
                this.cursorVerticalRightX = this.mouseX;
                this.movingCursor = 2;
                ((Button)this.cp5.get(Button.class, "setRangeButton")).setColorBackground(this.clickMeButtonColor);
            }
        }
    }

    public void mouseDragged() {
        int thisMouseX = this.mouseX;
        int thisMouseY = this.mouseY;
        if (thisMouseX < this.graphX() || thisMouseX > this.graphWidth() + this.graphX() + 1) {
            return;
        }
        if (thisMouseY < this.graphY() || thisMouseY > this.graphHeight() + this.graphY() + 1) {
            return;
        }
        if (this.mouseDragLock && (spektrum.abs((int)(this.cursorVerticalLeftX - this.mouseX)) > this.startDraggingThr || spektrum.abs((int)(this.cursorHorizontalBottomY - this.mouseY)) > this.startDraggingThr)) {
            this.cursorVerticalRightX = this.mouseX;
            this.cursorHorizontalTopY = this.mouseY;
            this.deltaLabelsX = this.mouseX - 30;
            this.deltaLabelsY = this.mouseY - 29;
        }
        if (this.movingCursor == 1) {
            this.cursorVerticalLeftX = thisMouseX;
            int clickFreq = this.startFreq + this.hzPerPixel() * (thisMouseX - this.graphX());
            ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)clickFreq));
        } else if (this.movingCursor == 2) {
            this.cursorVerticalRightX = thisMouseX;
            int clickFreq = this.startFreq + this.hzPerPixel() * (thisMouseX - this.graphX());
            ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)clickFreq));
        } else if (this.movingCursor == 3) {
            this.cursorHorizontalTopY = thisMouseY;
            int clickScale = this.scaleMax - (thisMouseY - this.graphY()) * this.gainPerPixel() / 1000;
            ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)clickScale));
        } else if (this.movingCursor == 4) {
            this.cursorHorizontalBottomY = thisMouseY;
            int clickScale = this.scaleMax - (thisMouseY - this.graphY()) * this.gainPerPixel() / 1000;
            ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)clickScale));
        }
        if (this.mouseButton == 39) {
            this.stroke(-10461088);
            this.line(this.cursorVerticalLeftX, this.cursorHorizontalBottomY, this.mouseX, this.mouseY);
        } else if (this.mouseButton == 3) {
            this.stroke(-10461088);
            this.line(this.dragGraphStartX, this.dragGraphStartY, this.mouseX, this.mouseY);
        }
    }

    public void mouseReleased() {
        this.mouseDragLock = false;
        this.lastMouseX = 0;
        this.movingCursor = 0;
        this.deltaLabelsX = this.deltaLabelsXWaiting;
        this.deltaLabelsY = this.deltaLabelsYWaiting;
        if (this.mouseDragGraph == 1) {
            this.mouseDragGraph = 0;
            int freqLeft = this.startFreq + this.hzPerPixel() * (this.dragGraphStartX - this.graphX());
            int freqRight = this.startFreq + this.hzPerPixel() * (this.mouseX - this.graphX());
            int scaleBottom = this.scaleMax - (this.dragGraphStartY - this.graphY()) * this.gainPerPixel() / 1000;
            int scaleTop = this.scaleMax - (this.mouseY - this.graphY()) * this.gainPerPixel() / 1000;
            int deltaF = freqRight - freqLeft;
            int deltaDB = scaleBottom - scaleTop;
            if (deltaDB != 0) {
                this.scaleMin += deltaDB;
                this.scaleMax += deltaDB;
                if (this.scaleMin < this.fullScaleMin) {
                    this.scaleMin = this.fullScaleMin;
                }
                if (this.scaleMin > this.fullScaleMax) {
                    this.scaleMin = this.fullScaleMin;
                }
                if (this.scaleMax < this.fullScaleMin) {
                    this.scaleMax = this.fullScaleMin;
                }
                if (this.scaleMax > this.fullScaleMax) {
                    this.scaleMax = this.fullScaleMax;
                }
                ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)this.scaleMin));
                ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)this.scaleMax));
                this.setScale();
                spektrum.println((String)("deltaDB: " + this.numToStr(deltaDB) + ", -New Scale: \n" + "  LOWER:" + this.numToStr(this.scaleMin) + ",  UPPER:" + this.numToStr(this.scaleMax)));
            }
            if (spektrum.abs((int)deltaF) > 10) {
                this.startFreq -= deltaF;
                this.stopFreq -= deltaF;
                if (this.startFreq < this.fullRangeMin) {
                    this.startFreq = this.fullRangeMin;
                }
                if (this.startFreq > this.fullRangeMax) {
                    this.startFreq = this.fullRangeMax;
                }
                if (this.stopFreq < this.fullRangeMin) {
                    this.stopFreq = this.fullRangeMin;
                }
                if (this.stopFreq > this.fullRangeMax) {
                    this.stopFreq = this.fullRangeMax;
                }
                ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)this.startFreq));
                ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)this.stopFreq));
                spektrum.println((String)("deltaF: " + this.numToStr(deltaF) + ", -New Freq: \n" + "  START:" + this.numToStr(this.startFreq) + ",  STOP:" + this.numToStr(this.stopFreq)));
                this.setRange();
            }
        }
    }

    public void mouseWheel(MouseEvent event) {
        int freqStep = 0;
        int scaleFreqOverDb = 0;
        int gMouseX = this.mouseX - this.graphX();
        int gMouseY = this.mouseY - this.graphY();
        int toModify = 0;
        if (spektrum.abs((int)(gMouseX - this.graphWidth() / 2)) < this.graphWidth() / 4) {
            if (gMouseY < this.graphHeight() / 4) {
                toModify = 1;
            } else if (this.graphHeight() - gMouseY < this.graphHeight() / 4) {
                toModify = 2;
            }
        }
        if (spektrum.abs((int)(gMouseY - this.graphHeight() / 2)) < this.graphHeight() / 4) {
            if (gMouseX < this.graphWidth() / 4 && gMouseX > 0) {
                toModify = 4;
            } else if (this.graphWidth() - gMouseX < this.graphWidth() / 4) {
                toModify = 8;
            }
        }
        if (spektrum.abs((int)(gMouseX - this.graphWidth() / 2)) < this.graphWidth() / 4 && spektrum.abs((int)(gMouseY - this.graphHeight() / 2)) < this.graphHeight() / 4) {
            toModify = 16;
        }
        int tmpFreq = 0;
        if (toModify > 0) {
            this.infoText1X = spektrum.min((int)spektrum.max((int)(this.graphX() + 90), (int)this.mouseX), (int)(this.graphWidth() + 140));
            this.infoText1Y = spektrum.max((int)(this.graphY() + 40), (int)this.mouseY);
        }
        freqStep = this.stopFreq - this.startFreq > 50000000 ? 10000000 : 1000000;
        switch (toModify) {
            case 2: {
                int tmpGain = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).getText()) - event.getCount();
                if (tmpGain < this.fullScaleMin) {
                    tmpGain = this.fullScaleMin;
                }
                if (tmpGain > this.fullScaleMax) {
                    tmpGain = this.fullScaleMax - 1;
                }
                if (tmpGain >= this.scaleMax) {
                    tmpGain = this.scaleMax - 1;
                }
                ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)tmpGain));
                this.infoText = String.valueOf(spektrum.str((int)tmpGain)) + " db";
                this.itemToSet = 1;
                this.infoLineY = this.getGraphYfromDb(tmpGain);
                this.timeToSet = 25;
                break;
            }
            case 1: {
                int tmpGain = spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).getText()) - event.getCount();
                if (tmpGain < this.fullScaleMin) {
                    tmpGain = this.fullScaleMin + 1;
                }
                if (tmpGain > this.fullScaleMax) {
                    tmpGain = this.fullScaleMax;
                }
                if (tmpGain <= this.scaleMin) {
                    tmpGain = this.scaleMin + 1;
                }
                ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)tmpGain));
                this.itemToSet = 1;
                this.infoText = String.valueOf(spektrum.str((int)tmpGain)) + " db";
                this.infoLineY = this.getGraphYfromDb(tmpGain);
                this.timeToSet = 25;
                break;
            }
            case 4: {
                tmpFreq = (spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "startFreqText")).getText()) / freqStep - event.getCount()) * freqStep;
                if (tmpFreq < this.fullRangeMin) {
                    tmpFreq = this.fullRangeMin;
                }
                if (tmpFreq > this.fullRangeMax) {
                    tmpFreq = this.fullRangeMax;
                }
                if (tmpFreq >= this.stopFreq) {
                    tmpFreq = this.stopFreq - 1000000;
                }
                ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)tmpFreq));
                this.itemToSet = 2;
                this.infoText = String.valueOf(spektrum.str((int)(this.ifCorrectedFreq(tmpFreq) / 1000000))) + " MHz";
                this.infoLineX = this.getGraphXfromFreq(tmpFreq);
                this.timeToSet = 25;
                break;
            }
            case 8: {
                tmpFreq = (spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).getText()) / freqStep - event.getCount()) * freqStep;
                if (tmpFreq < this.fullRangeMin) {
                    tmpFreq = this.fullRangeMin;
                }
                if (tmpFreq > this.fullRangeMax) {
                    tmpFreq = this.fullRangeMax;
                }
                if (tmpFreq <= this.startFreq) {
                    tmpFreq = this.startFreq + 1000000;
                }
                ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)tmpFreq));
                this.itemToSet = 2;
                this.infoText = String.valueOf(spektrum.str((int)(this.ifCorrectedFreq(tmpFreq) / 1000000))) + " MHz";
                this.infoLineX = this.getGraphXfromFreq(tmpFreq);
                this.timeToSet = 25;
                break;
            }
            case 16: {
                scaleFreqOverDb = (this.stopFreq - this.startFreq) / (this.scaleMax - this.scaleMin);
                int tmpGain = spektrum.min((int)spektrum.max((int)(spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).getText()) - event.getCount()), (int)this.fullScaleMin), (int)this.fullScaleMax);
                int tmpGain2 = spektrum.max((int)spektrum.min((int)(spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).getText()) + event.getCount()), (int)this.fullScaleMax), (int)this.fullScaleMin);
                if (tmpGain2 <= tmpGain) {
                    tmpGain2 = tmpGain + 2;
                }
                if (tmpGain == this.fullScaleMax) {
                    tmpGain = this.fullScaleMax - 1;
                    tmpGain2 = this.fullScaleMax;
                }
                ((Textfield)this.cp5.get(Textfield.class, "scaleMinText")).setText(spektrum.str((int)tmpGain));
                ((Textfield)this.cp5.get(Textfield.class, "scaleMaxText")).setText(spektrum.str((int)tmpGain2));
                tmpFreq = spektrum.min((int)spektrum.max((int)(spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "startFreqText")).getText()) - scaleFreqOverDb * event.getCount()), (int)this.fullRangeMin), (int)this.fullRangeMax);
                int tmpFreq2 = spektrum.max((int)spektrum.min((int)(spektrum.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).getText()) + scaleFreqOverDb * event.getCount()), (int)this.fullRangeMax), (int)this.fullRangeMin);
                if (tmpFreq >= tmpFreq2) {
                    tmpFreq2 = tmpFreq + 10000000;
                }
                ((Textfield)this.cp5.get(Textfield.class, "startFreqText")).setText(spektrum.str((int)tmpFreq));
                ((Textfield)this.cp5.get(Textfield.class, "stopFreqText")).setText(spektrum.str((int)tmpFreq2));
                this.infoText = event.getCount() > 0 ? "ZOOM OUT" : "ZOOM IN";
                this.infoRectangle[0] = this.getGraphXfromFreq(tmpFreq);
                this.infoRectangle[1] = this.getGraphYfromDb(tmpGain);
                this.infoRectangle[2] = this.getGraphXfromFreq(tmpFreq2) - this.infoRectangle[0];
                this.infoRectangle[3] = this.getGraphYfromDb(tmpGain2) - this.infoRectangle[1];
                this.itemToSet = 3;
                this.timeToSet = 25;
            }
        }
    }

    public int graphWidth() {
        return this.width - 280;
    }

    public int graphX() {
        return 230;
    }

    public int graphHeight() {
        return this.height - 50;
    }

    public int graphY() {
        return 25;
    }

    public int hzPerPixel() {
        return (this.stopFreq - this.startFreq) / this.graphWidth();
    }

    public int gainPerPixel() {
        return (this.scaleMax - this.scaleMin) * 1000 / this.graphHeight();
    }

    public void graphDrawLine(int x1, int y1, int x2, int y2, int lineColor, float alpha) {
        this.stroke(lineColor, alpha);
        if (this.drawSampleToggle) {
            this.ellipse(x2 + this.graphX(), this.graphHeight() - y2 + this.graphY(), 1.0f, 1.0f);
        } else {
            this.line(x1 + this.graphX(), this.graphHeight() - y1 + this.graphY(), x2 + this.graphX(), this.graphHeight() - y2 + this.graphY());
        }
    }

    public void graphDrawFill(int x1, int y1, int x2, int y2, int lineColor, float alpha) {
        this.stroke(lineColor, alpha);
        this.quad(x1 + this.graphX(), this.graphHeight() - y1 + this.graphY(), x2 + this.graphX(), this.graphHeight() - y2 + this.graphY(), x2 + this.graphX(), this.graphY() + this.graphHeight(), x1 + this.graphX(), this.graphY() + this.graphHeight());
    }

    public void drawGraphMatt(double minValue, double maxValue, int minFreq, int maxFreq) {
        int pixelSpacing = 50;
        int verticals = this.graphWidth() / pixelSpacing / 5 * 5;
        int horizontals = this.graphHeight() / pixelSpacing / 5 * 5;
        verticals = verticals == 0 ? 1 : verticals;
        horizontals = horizontals == 0 ? 1 : horizontals;
        float verticalSpacing = (float)this.graphWidth() / (float)verticals;
        float horizontalSpacing = (float)this.graphHeight() / (float)horizontals;
        double xStep = (float)((maxFreq - minFreq) / verticals) / 10000.0f;
        double xPos = (float)minFreq / 10000.0f;
        double yStep = (maxValue - minValue) / (double)horizontals;
        double yPos = maxValue;
        this.stroke(-12105913);
        this.fill(-5789785);
        int i = 0;
        while (i <= verticals) {
            this.line((float)this.graphX() + (float)i * verticalSpacing, this.graphY(), (float)this.graphX() + (float)i * verticalSpacing, this.graphY() + this.graphHeight());
            this.textAlign(3);
            this.text(String.valueOf((float)spektrum.round((float)((float)this.ifCorrectedFreq((int)(xPos * 10000.0)) / 10000.0f)) / 100.0f), (float)this.graphX() + (float)i * verticalSpacing, this.graphY() + this.graphHeight() + 20);
            xPos += xStep;
            ++i;
        }
        i = 0;
        while (i <= horizontals) {
            this.line(this.graphX(), (float)this.graphY() + (float)i * horizontalSpacing, this.graphX() + this.graphWidth(), (float)this.graphY() + (float)i * horizontalSpacing);
            this.textAlign(39);
            this.text(String.valueOf(spektrum.round((float)((float)yPos))), this.graphX() - 5, (float)this.graphY() + (float)i * horizontalSpacing + 4.0f);
            yPos -= yStep;
            ++i;
        }
    }

    public void sweep(int x, int lineColor, float alpha) {
        this.stroke(lineColor, alpha);
        this.line(x + this.graphX(), this.graphY(), x + this.graphX(), this.graphY() + this.graphHeight());
    }

    public void sweepVertical(int y, int lineColor, float alpha) {
        this.stroke(lineColor, alpha);
        this.line(this.graphX(), y + this.graphY(), this.graphX() + this.graphWidth(), y + this.graphY());
    }

    public DataPoint[] reduceBuffer(double[] buffer, int length) {
        DataPoint[] ret = new DataPoint[length];
        float step = (float)length / (float)buffer.length;
        int oldIndex = 0;
        float position = 0.0f;
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        int count = 0;
        double sum = 0.0;
        int sourcePos = 0;
        while (position < (float)length) {
            if (oldIndex != (int)position) {
                DataPoint dp = new DataPoint();
                dp.x = (int)position - 1;
                dp.yMin = minValue;
                dp.yMax = maxValue;
                dp.yAvg = sum / (double)count;
                ret[oldIndex] = dp;
                sum = 0.0;
                count = 0;
                minValue = Double.POSITIVE_INFINITY;
                maxValue = Double.NEGATIVE_INFINITY;
                oldIndex = (int)position;
                continue;
            }
            if (sourcePos < buffer.length) {
                if (buffer[sourcePos] < minValue && buffer[sourcePos] != Double.NEGATIVE_INFINITY) {
                    minValue = buffer[sourcePos];
                }
                if (buffer[sourcePos] > maxValue) {
                    maxValue = buffer[sourcePos];
                }
                if (buffer[sourcePos] > Double.NEGATIVE_INFINITY && buffer[sourcePos] != Double.POSITIVE_INFINITY) {
                    sum += buffer[sourcePos];
                    ++count;
                }
            }
            position += step;
            ++sourcePos;
        }
        return ret;
    }

    public DataPoint[] scaleBufferX(double[] buffer) {
        DataPoint[] ret;
        double[] cfr_ignored_0 = new double[this.graphWidth()];
        if (buffer == null) {
            return new DataPoint[0];
        }
        if (this.graphWidth() < buffer.length) {
            ret = this.reduceBuffer(buffer, this.graphWidth());
        } else {
            ret = new DataPoint[buffer.length];
            float step = (float)this.graphWidth() / (float)buffer.length;
            int i = 0;
            while (i < buffer.length) {
                DataPoint dp = new DataPoint();
                dp.x = (int)((float)i * step);
                dp.yMin = buffer[i];
                dp.yMax = buffer[i];
                dp.yAvg = buffer[i];
                ret[i] = dp;
                ++i;
            }
        }
        return ret;
    }

    public void settings() {
        this.size(1200, 750);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"spektrum"};
        if (passedArgs != null) {
            PApplet.main((String[])spektrum.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    static interface CURSORS {
        public static final int CUR_NONE = 0;
        public static final int CUR_X_LEFT = 1;
        public static final int CUR_X_RIGHT = 2;
        public static final int CUR_Y_TOP = 3;
        public static final int CUR_Y_BOTTOM = 4;
    }

    class DataPoint {
        public int x;
        public double yMin = 0.0;
        public double yMax = 0.0;
        public double yAvg = 0.0;

        DataPoint() {
        }
    }

    public class configurationClass {
        public int startFreq;
        public int stopFreq;
        public int binStep;
        public int scaleMin;
        public int scaleMax;
        public int rfGain;
        public int fullRangeMin;
        public int fullRangeMax;
        public int ifOffset;
        public int ifType;
        public int activeConfig;
        public String configName;

        public configurationClass(int i) {
            this.configName = "Config" + i;
        }
    }

    class infoScreen {
        public int topY = 0;
        public int leftX = 0;
        public int width = 0;
        public int height = 0;
        public String text = "";
        int colorBack;

        infoScreen() {
        }
    }
}

