/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ArrowKeyNavigationSupport {
    private int[] _keyCode = new int[]{37, 39, 38, 40};
    private Class[] _componentTypes;
    public static final String CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT = "ArrowKeyNavigationSupport.previousAction";

    public ArrowKeyNavigationSupport() {
    }

    public ArrowKeyNavigationSupport(Class[] componentTypes) {
        this._componentTypes = componentTypes;
    }

    public ArrowKeyNavigationSupport(int[] keyCodes) {
        this._keyCode = keyCodes;
    }

    public ArrowKeyNavigationSupport(Class[] componentTypes, int[] keyCode) {
        this._keyCode = keyCode;
        this._componentTypes = componentTypes;
    }

    public void install(JComponent container) {
        for (int keyCode : this._keyCode) {
            KeyStroke keyStroke;
            InputMap inputMap = container.getInputMap(1);
            Object actionName = inputMap.get(keyStroke = KeyStroke.getKeyStroke(keyCode, 0));
            if (actionName != null) {
                container.putClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT, actionName);
            }
            container.registerKeyboardAction(new NavigationAction(container, keyCode), "ArrowKeyNavigation " + keyCode, keyStroke, 1);
        }
    }

    public void uninstall(JComponent container) {
        for (int keyCode : this._keyCode) {
            Object actionName = container.getClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT);
            if (actionName != null) {
                InputMap inputMap = container.getInputMap(1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, 0);
                inputMap.put(keyStroke, actionName);
                continue;
            }
            container.unregisterKeyboardAction(KeyStroke.getKeyStroke(keyCode, 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavigationAction
    implements ActionListener {
        private JComponent _parent;
        private int _keyCode;

        public NavigationAction(JComponent c, int key) {
            this._parent = c;
            this._keyCode = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
            final ArrayList<Component> components = new ArrayList<Component>();
            JideSwingUtilities.setRecursively(this._parent, new JideSwingUtilities.Handler(){

                public void postAction(Component c) {
                }

                public void action(Component c) {
                    if (ArrowKeyNavigationSupport.this._componentTypes != null) {
                        boolean allowed = false;
                        for (Class allowedType : ArrowKeyNavigationSupport.this._componentTypes) {
                            if (!allowedType.isAssignableFrom(c.getClass())) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            return;
                        }
                    }
                    Rectangle bounds = c.getBounds();
                    rects.add(SwingUtilities.convertRectangle(c, bounds, NavigationAction.this._parent));
                    components.add(c);
                }

                public boolean condition(Component c) {
                    return c.isVisible() && c.isDisplayable() && c.isFocusable() && c.isEnabled();
                }
            });
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component c = null;
            switch (this._keyCode) {
                case 39: {
                    c = this.findComponentToRight(owner, rects, components);
                    break;
                }
                case 37: {
                    c = this.findComponentToLeft(owner, rects, components);
                    break;
                }
                case 38: {
                    c = this.findComponentToAbove(owner, rects, components);
                    break;
                }
                case 40: {
                    c = this.findComponentToBelow(owner, rects, components);
                }
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }

        private Component findComponentToRight(Component c, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c, c.getBounds(), this._parent);
            for (int i = 0; i < rects.size(); ++i) {
                int dist;
                Rectangle dst = rects.get(i);
                if (dst.x <= src.x + src.width || dst.y + dst.height < src.y || dst.y > src.y + src.height || (dist = dst.x - src.x - src.width) >= max) continue;
                max = dist;
                found = components.get(i);
            }
            return found;
        }

        private Component findComponentToBelow(Component c, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c, c.getBounds(), this._parent);
            for (int i = 0; i < rects.size(); ++i) {
                int dist;
                Rectangle dst = rects.get(i);
                if (dst.y <= src.y + src.height || dst.x + dst.width < src.x || dst.x > src.x + src.width || (dist = dst.y - src.y - src.height) >= max) continue;
                max = dist;
                found = components.get(i);
            }
            return found;
        }

        private Component findComponentToLeft(Component c, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c, c.getBounds(), this._parent);
            for (int i = 0; i < rects.size(); ++i) {
                int dist;
                Rectangle dst = rects.get(i);
                if (dst.x + dst.width >= src.x || dst.y + dst.height < src.y || dst.y > src.y + src.height || (dist = src.x - dst.x - dst.width) >= max) continue;
                max = dist;
                found = components.get(i);
            }
            return found;
        }

        private Component findComponentToAbove(Component c, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c, c.getBounds(), this._parent);
            for (int i = 0; i < rects.size(); ++i) {
                int dist;
                Rectangle dst = rects.get(i);
                if (dst.y + dst.height >= src.y || dst.x + dst.width < src.x || dst.x > src.x + src.width || (dist = src.y - dst.y - dst.height) >= max) continue;
                max = dist;
                found = components.get(i);
            }
            return found;
        }
    }
}

