/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWaypointRenderer
implements WaypointRenderer<Waypoint> {
    private static final Logger mLog = LoggerFactory.getLogger(DefaultWaypointRenderer.class);
    private BufferedImage img = null;

    public DefaultWaypointRenderer() {
        try {
            this.img = ImageIO.read(this.getClass().getResource("resources/standard_waypoint.png"));
        }
        catch (Exception ex) {
            mLog.error("couldn't read standard_waypoint.png", (Throwable)ex);
        }
    }

    @Override
    public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint w) {
        if (this.img == null) {
            return;
        }
        Point2D point = map.getTileFactory().geoToPixel(w.getPosition(), map.getZoom());
        int x = (int)point.getX() - this.img.getWidth() / 2;
        int y = (int)point.getY() - this.img.getHeight();
        g.drawImage((Image)this.img, x, y, null);
    }
}

