/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.window;

import io.github.dsheirer.dsp.window.ScalarWindow;
import io.github.dsheirer.dsp.window.VectorWindow;
import io.github.dsheirer.dsp.window.Window;
import io.github.dsheirer.dsp.window.WindowFactory;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class WindowCalibration
extends Calibration {
    private static final int WINDOW_SIZE = 8192;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private Window mScalarWindow;
    private Window mVectorWindow;

    public WindowCalibration() {
        super(CalibrationType.WINDOW);
        float[] window = WindowFactory.getBlackman(8192);
        this.mScalarWindow = new ScalarWindow(window);
        this.mVectorWindow = new VectorWindow(window);
    }

    @Override
    public void calibrate() throws CalibrationException {
        int x;
        Mean scalarMean = new Mean();
        float[] samples = this.getFloatSamples(8192);
        for (int x2 = 0; x2 < 5; ++x2) {
            scalarMean.increment((double)this.testScalar(samples));
        }
        mLog.info("WINDOW WARMUP - SCALAR: " + scalarMean.getResult());
        Mean vectorMean = new Mean();
        samples = this.getFloatSamples(8192);
        for (x = 0; x < 5; ++x) {
            vectorMean.increment((double)this.testVector(samples));
        }
        mLog.info("WINDOW WARMUP - VECTOR: " + vectorMean.getResult());
        scalarMean.clear();
        samples = this.getFloatSamples(8192);
        for (x = 0; x < 5; ++x) {
            scalarMean.increment((double)this.testScalar(samples));
        }
        mLog.info("WINDOW - SCALAR: " + scalarMean.getResult());
        vectorMean.clear();
        samples = this.getFloatSamples(8192);
        for (x = 0; x < 5; ++x) {
            vectorMean.increment((double)this.testVector(samples));
        }
        mLog.info("WINDOW - VECTOR: " + vectorMean.getResult());
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("WINDOW - OPTIMAL IMPLEMENTATION SET TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] samples) {
        long start = System.currentTimeMillis();
        double accumulator = 0.0;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            this.mScalarWindow.apply(samples);
            accumulator += (double)samples[3];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector(float[] samples) {
        long start = System.currentTimeMillis();
        double accumulator = 0.0;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            this.mVectorWindow.apply(samples);
            accumulator += (double)samples[3];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

