/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.mixer;

import io.github.dsheirer.dsp.mixer.ScalarComplexMixer;
import io.github.dsheirer.dsp.mixer.VectorComplexMixer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class ComplexMixerCalibration
extends Calibration {
    private static final double FREQUENCY = 2.0;
    private static final double SAMPLE_RATE = 10.0;
    private static final int SAMPLE_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private ScalarComplexMixer mScalarComplexMixer = new ScalarComplexMixer(2.0, 10.0);
    private VectorComplexMixer mVectorComplexMixer = new VectorComplexMixer(2.0, 10.0);

    public ComplexMixerCalibration() {
        super(CalibrationType.MIXER_COMPLEX);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        float[] i = this.getFloatSamples(2048);
        float[] q = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar(i, q);
            scalarMean.increment((double)score2);
        }
        mLog.info("COMPLEX MIXER WARMUP - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vectorMean = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(i, q);
            vectorMean.increment((double)score);
        }
        mLog.info("COMPLEX MIXER WARMUP - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar(i, q);
            scalarMean.increment((double)score);
        }
        mLog.info("COMPLEX MIXER - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        vectorMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(i, q);
            vectorMean.increment((double)score);
        }
        mLog.info("COMPLEX MIXER - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("COMPLEX MIXER - IMPLEMENTATION SET TO:" + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] i, float[] q) {
        long start = System.currentTimeMillis();
        double accumulator = 0.0;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            ComplexSamples mixed = this.mScalarComplexMixer.mix(i, q, start);
            accumulator += (double)mixed.i()[2];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector(float[] i, float[] q) {
        long start = System.currentTimeMillis();
        double accumulator = 0.0;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            ComplexSamples mixed = this.mVectorComplexMixer.mix(i, q, start);
            accumulator += (double)mixed.i()[2];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

