/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.filter;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.halfband.RealHalfBandDecimationFilter;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap64Bit;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class RealHalfBand23TapFilterCalibration
extends Calibration {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private IRealDecimationFilter mScalar;
    private IRealDecimationFilter mVector512;
    private IRealDecimationFilter mVector256;
    private IRealDecimationFilter mVector128;
    private IRealDecimationFilter mVector64;

    public RealHalfBand23TapFilterCalibration() {
        super(CalibrationType.FILTER_HALF_BAND_REAL_23_TAP);
        float[] coefficients = FilterFactory.getHalfBand(23, WindowType.BLACKMAN);
        this.mScalar = new RealHalfBandDecimationFilter(coefficients);
        this.mVector512 = new VectorRealHalfBandDecimationFilter23Tap512Bit(coefficients);
        this.mVector256 = new VectorRealHalfBandDecimationFilter23Tap256Bit(coefficients);
        this.mVector128 = new VectorRealHalfBandDecimationFilter23Tap128Bit(coefficients);
        this.mVector64 = new VectorRealHalfBandDecimationFilter23Tap64Bit(coefficients);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        long score2;
        float[] samples = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score3 = this.testScalar(samples);
            scalarMean.increment((double)score3);
        }
        mLog.info("REAL HALF-BAND 23-TAP DECIMATE WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vector512Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 16) {
            for (int x3 = 0; x3 < 5; ++x3) {
                long score4 = this.testVector512(samples);
                vector512Mean.increment((double)score4);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
        }
        Mean vector256Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 8) {
            for (int x4 = 0; x4 < 5; ++x4) {
                long score5 = this.testVector256(samples);
                vector256Mean.increment((double)score5);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
        }
        Mean vector128Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 4) {
            for (int x5 = 0; x5 < 5; ++x5) {
                long score6 = this.testVector128(samples);
                vector128Mean.increment((double)score6);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
        }
        Mean vector64Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 2) {
            for (int x6 = 0; x6 < 5; ++x6) {
                score2 = this.testVector64(samples);
                vector64Mean.increment((double)score2);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
        }
        scalarMean.clear();
        for (int x7 = 0; x7 < 5; ++x7) {
            score2 = this.testScalar(samples);
            scalarMean.increment((double)score2);
        }
        mLog.info("REAL HALF-BAND 23-TAP DECIMATE - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        double bestScore = scalarMean.getResult();
        this.setImplementation(Implementation.SCALAR);
        if (VECTOR_SPECIES.length() >= 16) {
            vector512Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector512(samples);
                vector512Mean.increment((double)score);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
            if (vector512Mean.getResult() > bestScore) {
                bestScore = vector512Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_512);
            }
        }
        if (VECTOR_SPECIES.length() >= 8) {
            vector256Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector256(samples);
                vector256Mean.increment((double)score);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
            if (vector256Mean.getResult() > bestScore) {
                bestScore = vector256Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_256);
            }
        }
        if (VECTOR_SPECIES.length() >= 4) {
            vector128Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector128(samples);
                vector128Mean.increment((double)score);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
            if (vector128Mean.getResult() > bestScore) {
                bestScore = vector128Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_128);
            }
        }
        if (VECTOR_SPECIES.length() >= 2) {
            vector64Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector64(samples);
                vector64Mean.increment((double)score);
            }
            mLog.info("REAL HALF-BAND 23-TAP DECIMATE - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
            if (vector64Mean.getResult() > bestScore) {
                this.setImplementation(Implementation.VECTOR_SIMD_64);
            }
        }
        mLog.info("REAL HALF-BAND 23-TAP DECIMATE - SET OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mScalar.decimateReal(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector512(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector512.decimateReal(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector256(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector256.decimateReal(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector128(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector128.decimateReal(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector64(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector64.decimateReal(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

