/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.filter;

import io.github.dsheirer.dsp.filter.dc.IDcRemovalFilter;
import io.github.dsheirer.dsp.filter.dc.ScalarDcRemovalFilter;
import io.github.dsheirer.dsp.filter.dc.VectorDcRemovalFilter;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class RealDcRemovalCalibration
extends Calibration {
    private static final float GAIN = 0.15f;
    private static final int BUFFER_SIZE = 8192;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int TEST_ITERATIONS = 5;
    private static final int WARMUP_ITERATIONS = 5;
    private IDcRemovalFilter mScalar = new ScalarDcRemovalFilter(0.15f);
    private IDcRemovalFilter mVector = new VectorDcRemovalFilter(0.15f);

    public RealDcRemovalCalibration() {
        super(CalibrationType.DC_REMOVAL_REAL);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        float[] samples = this.getFloatSamples(8192);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar(samples);
            scalarMean.increment((double)score2);
        }
        mLog.info("REAL DC REMOVAL WARMUP - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vectorMean = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(samples);
            vectorMean.increment((double)score);
        }
        mLog.info("REAL DC REMOVAL WARMUP - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar(samples);
            scalarMean.increment((double)score);
        }
        mLog.info("REAL DC REMOVAL - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        vectorMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(samples);
            vectorMean.increment((double)score);
        }
        mLog.info("REAL DC REMOVAL - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("REAL DC REMOVAL - SET OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mScalar.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

