/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.demodulator;

import io.github.dsheirer.dsp.fm.IDemodulator;
import io.github.dsheirer.dsp.fm.ScalarFMDemodulator;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator128;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator256;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator512;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator64;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class FmDemodulatorCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private IDemodulator mScalarDemodulator = new ScalarFMDemodulator();
    private IDemodulator mVectorDemodulator64 = new VectorFMDemodulator64();
    private IDemodulator mVectorDemodulator128 = new VectorFMDemodulator128();
    private IDemodulator mVectorDemodulator256 = new VectorFMDemodulator256();
    private IDemodulator mVectorDemodulator512 = new VectorFMDemodulator512();

    public FmDemodulatorCalibration() {
        super(CalibrationType.FM_DEMODULATOR);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        float[] i = this.getFloatSamples(2048);
        float[] q = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar(i, q);
            scalarMean.increment((double)score2);
        }
        mLog.info("FM DEMODULATOR WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vectorMean64 = new Mean();
        for (int x3 = 0; x3 < 5; ++x3) {
            long score3 = this.testVector64(i, q);
            vectorMean64.increment((double)score3);
        }
        mLog.info("FM DEMODULATOR WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vectorMean64.getResult()));
        Mean vectorMean128 = new Mean();
        for (int x4 = 0; x4 < 5; ++x4) {
            long score4 = this.testVector128(i, q);
            vectorMean128.increment((double)score4);
        }
        mLog.info("FM DEMODULATOR WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vectorMean128.getResult()));
        Mean vectorMean256 = new Mean();
        for (int x5 = 0; x5 < 5; ++x5) {
            long score5 = this.testVector256(i, q);
            vectorMean256.increment((double)score5);
        }
        mLog.info("FM DEMODULATOR WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vectorMean256.getResult()));
        Mean vectorMean512 = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector512(i, q);
            vectorMean512.increment((double)score);
        }
        mLog.info("FM DEMODULATOR WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vectorMean512.getResult()));
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar(i, q);
            scalarMean.increment((double)score);
        }
        mLog.info("FM DEMODULATOR - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        vectorMean64.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector64(i, q);
            vectorMean64.increment((double)score);
        }
        mLog.info("FM DEMODULATOR - VECTOR 64: " + DECIMAL_FORMAT.format(vectorMean64.getResult()));
        vectorMean128.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector128(i, q);
            vectorMean128.increment((double)score);
        }
        mLog.info("FM DEMODULATOR - VECTOR 128: " + DECIMAL_FORMAT.format(vectorMean128.getResult()));
        vectorMean256.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector256(i, q);
            vectorMean256.increment((double)score);
        }
        mLog.info("FM DEMODULATOR - VECTOR 256: " + DECIMAL_FORMAT.format(vectorMean256.getResult()));
        vectorMean512.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector512(i, q);
            vectorMean512.increment((double)score);
        }
        mLog.info("FM DEMODULATOR - VECTOR 512: " + DECIMAL_FORMAT.format(vectorMean512.getResult()));
        Implementation best = Implementation.SCALAR;
        double bestScore = scalarMean.getResult();
        if (vectorMean64.getResult() > bestScore) {
            bestScore = vectorMean64.getResult();
            best = Implementation.VECTOR_SIMD_64;
        }
        if (vectorMean128.getResult() > bestScore) {
            bestScore = vectorMean128.getResult();
            best = Implementation.VECTOR_SIMD_128;
        }
        if (vectorMean256.getResult() > bestScore) {
            bestScore = vectorMean256.getResult();
            best = Implementation.VECTOR_SIMD_256;
        }
        if (vectorMean512.getResult() > bestScore) {
            best = Implementation.VECTOR_SIMD_512;
        }
        this.setImplementation(best);
        mLog.info("FM DEMODULATOR - SET OPTIMAL IMPLEMENTATION TO:" + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] i, float[] q) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mScalarDemodulator.demodulate(i, q);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector64(float[] i, float[] q) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator64.demodulate(i, q);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector128(float[] i, float[] q) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator128.demodulate(i, q);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector256(float[] i, float[] q) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator256.demodulate(i, q);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector512(float[] i, float[] q) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator512.demodulate(i, q);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    public static void main(String[] args) {
        FmDemodulatorCalibration calibration = new FmDemodulatorCalibration();
        try {
            calibration.calibrate();
        }
        catch (Exception e) {
            mLog.error("Error during calibration", (Throwable)e);
        }
    }
}

