/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.airspy;

import io.github.dsheirer.buffer.airspy.ScalarUnpackedSampleConverter;
import io.github.dsheirer.buffer.airspy.VectorUnpackedSampleConverter;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import java.nio.ByteBuffer;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class AirspySampleConverterCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 262144;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARM_UP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;

    public AirspySampleConverterCalibration() {
        super(CalibrationType.AIRSPY_SAMPLE_CONVERTER);
    }

    @Override
    public void calibrate() throws CalibrationException {
        int vectorTest;
        long score;
        int scalarTest;
        Mean scalarMean = new Mean();
        Mean vectorMean = new Mean();
        byte[] samples = new byte[262144];
        ByteBuffer buffer = ByteBuffer.wrap(samples);
        for (scalarTest = 0; scalarTest < 5; ++scalarTest) {
            score = this.testScalar(buffer);
            scalarMean.increment((double)score);
        }
        mLog.info("AIRSPY CONVERTER WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        for (vectorTest = 0; vectorTest < 5; ++vectorTest) {
            score = this.testVector(buffer);
            vectorMean.increment((double)score);
        }
        mLog.info("AIRSPY CONVERTER WARMUP - VECTOR: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
        scalarMean.clear();
        vectorMean.clear();
        for (scalarTest = 0; scalarTest < 5; ++scalarTest) {
            score = this.testScalar(buffer);
            scalarMean.increment((double)score);
        }
        mLog.info("AIRSPY CONVERTER - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        for (vectorTest = 0; vectorTest < 5; ++vectorTest) {
            score = this.testVector(buffer);
            vectorMean.increment((double)score);
        }
        mLog.info("AIRSPY CONVERTER - VECTOR: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("AIRSPY CONVERTER - SETTING OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(ByteBuffer buffer) {
        long start = System.currentTimeMillis();
        ScalarUnpackedSampleConverter scalor = new ScalarUnpackedSampleConverter();
        long count = 0L;
        long accumulator = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            short[] converted = scalor.convert(buffer);
            accumulator += (long)converted[2];
            ++count;
        }
        return count + accumulator * 0L;
    }

    private long testVector(ByteBuffer buffer) {
        VectorUnpackedSampleConverter vector = new VectorUnpackedSampleConverter();
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            short[] converted = vector.convert(buffer);
            accumulator += (long)converted[2];
            ++count;
        }
        return count + accumulator * 0L;
    }
}

