/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate;

public enum CalibrationType {
    OSCILLATOR_COMPLEX("Complex Oscillator", 1),
    GAIN_COMPLEX("Complex Gain", 1),
    AIRSPY_SAMPLE_CONVERTER("Airspy Sample Converter", 1),
    AIRSPY_UNPACKED_INTERLEAVED_ITERATOR("Airspy Unpacked Interleaved Iterator", 1),
    AIRSPY_UNPACKED_ITERATOR("Airspy Unpacked Iterator", 1),
    AM_DEMODULATOR("AM Demodulator", 1),
    DC_REMOVAL_REAL("Real DC Removal Filter", 1),
    FILTER_FIR("FIR Filter", 1),
    FILTER_HALF_BAND_REAL_11_TAP("Real Half-Band Decimation Filter - 11 Tap", 1),
    FILTER_HALF_BAND_REAL_15_TAP("Real Half-Band Decimation Filter - 15 Tap", 1),
    FILTER_HALF_BAND_REAL_23_TAP("Real Half-Band Decimation Filter - 23 Tap", 1),
    FILTER_HALF_BAND_REAL_63_TAP("Real Half-Band Decimation Filter - 63 Tap", 1),
    FILTER_HALF_BAND_REAL_DEFAULT("Real Half-Band Decimation Filter - Default", 1),
    FM_DEMODULATOR("FM Demodulator", 2),
    GAIN_CONTROL_COMPLEX("Complex Gain Control", 1),
    HILBERT_TRANSFORM("Hilbert Transform", 1),
    MAGNITUDE("Magnitude", 1),
    MIXER_COMPLEX("Complex Mixer", 1),
    OSCILLATOR_REAL("Real Oscillator", 1),
    SQUELCHING_FM_DEMODULATOR("Squelching FM Demodulator", 1),
    WINDOW("Window", 1);

    private String mDescription;
    private int mVersion;

    private CalibrationType(String description, int version) {
        this.mDescription = description;
        this.mVersion = version;
    }

    public String getPreferenceKey() {
        return this.name() + " - V" + this.getVersion();
    }

    public String getDescription() {
        return this.mDescription;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return this.getDescription();
    }
}

