/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate;

import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Calibration {
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    public static final Logger mLog = LoggerFactory.getLogger(Calibration.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(Calibration.class);
    private CalibrationType mType;
    private Implementation mImplementation;

    public Calibration(CalibrationType type) {
        this.mType = type;
    }

    public Logger getLogger() {
        return mLog;
    }

    public CalibrationType getType() {
        return this.mType;
    }

    public boolean isCalibrated() {
        return this.getImplementation() != Implementation.UNCALIBRATED;
    }

    public void reset() {
        this.setImplementation(Implementation.UNCALIBRATED);
    }

    public Implementation getImplementation() {
        if (this.mImplementation == null) {
            String implementation = this.mPreferences.get(this.getType().getPreferenceKey(), Implementation.UNCALIBRATED.name());
            this.mImplementation = Implementation.valueOf(implementation);
        }
        return this.mImplementation;
    }

    protected void setImplementation(Implementation implementation) {
        this.mImplementation = implementation;
        this.mPreferences.put(this.getType().getPreferenceKey(), implementation.name());
    }

    public abstract void calibrate() throws CalibrationException;

    protected float[] getFloatSamples(int size) {
        Random random = new Random();
        float[] samples = new float[size];
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = random.nextFloat() * 2.0f - 1.0f;
        }
        return samples;
    }

    protected short[] getShortSamples(int size) {
        Random random = new Random();
        short[] samples = new short[size];
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = (short)((random.nextFloat() * 2.0f - 1.0f) * 32767.0f);
        }
        return samples;
    }
}

