/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeStamp {
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmmss");
    public static SimpleDateFormat DATE_WITH_MILLISECONDS_FORMAT = new SimpleDateFormat("HHmmss.SSS");
    public static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    public static SimpleDateFormat DATE_TIME_MILLIS_FORMAT = new SimpleDateFormat("yyyyMMdd HHmmss.SSS");

    public static synchronized String getFormattedDate() {
        return TimeStamp.getFormattedDate(System.currentTimeMillis());
    }

    public static synchronized String getFormattedDate(long timestamp) {
        return DATE_FORMAT.format(new Date(timestamp));
    }

    public static synchronized String getFormattedTime() {
        return TimeStamp.getFormattedTime(System.currentTimeMillis());
    }

    public static synchronized String getFormattedTime(long timestamp) {
        return TIME_FORMAT.format(new Date(timestamp));
    }

    public static synchronized String getFormattedTimeWithMilliseconds(long timestamp) {
        return DATE_WITH_MILLISECONDS_FORMAT.format(new Date(timestamp));
    }

    public static synchronized String getTimeStamp(String separator) {
        return TimeStamp.getTimeStamp(System.currentTimeMillis(), separator);
    }

    public static synchronized String getTimeStamp(long timestamp, String separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeStamp.getFormattedDate(timestamp));
        sb.append(separator);
        sb.append(TimeStamp.getFormattedTime(timestamp));
        return sb.toString();
    }

    public static synchronized String getLongTimeStamp(String separator) {
        return TimeStamp.getLongTimeStamp(System.currentTimeMillis(), separator);
    }

    public static synchronized String getLongTimeStamp(long timestamp, String separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeStamp.getFormattedDate(timestamp));
        sb.append(separator);
        sb.append(TimeStamp.getFormattedTimeWithMilliseconds(timestamp));
        return sb.toString();
    }
}

