/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.util;

import io.github.dsheirer.sample.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class ArcTangent {
    public static final double sTANGENT_MAP_RESOLUTION = 0.003921549;
    public static final double sRADIANS_PER_DEGREE = 0.017453293;
    public static final int sTANGENT_MAP_SIZE = 256;
    public static final double sHALF_PI = 1.5707963267948966;
    private static double[] sLOOKUP_TABLE = new double[]{0.0, 0.003921549, 0.007842976, 0.01176416, 0.01568499, 0.01960533, 0.02352507, 0.02744409, 0.03136226, 0.03527947, 0.0391956, 0.04311053, 0.04702413, 0.05093629, 0.0548469, 0.05875582, 0.06266295, 0.06656816, 0.07047134, 0.07437238, 0.07827114, 0.08216752, 0.08606141, 0.08995267, 0.09384121, 0.09772691, 0.1016096, 0.1054893, 0.1093658, 0.113239, 0.1171087, 0.120975, 0.1248376, 0.1286965, 0.1325515, 0.1364026, 0.1402496, 0.1440924, 0.147931, 0.1517652, 0.1555948, 0.1594199, 0.1632403, 0.1670559, 0.1708665, 0.1746722, 0.1784728, 0.1822681, 0.1860582, 0.1898428, 0.193622, 0.1973956, 0.2011634, 0.2049255, 0.2086818, 0.212432, 0.2161762, 0.2199143, 0.2236461, 0.2273716, 0.2310907, 0.2348033, 0.2385093, 0.2422086, 0.2459012, 0.2495869, 0.2532658, 0.2569376, 0.2606024, 0.26426, 0.2679104, 0.2715535, 0.2751892, 0.2788175, 0.2824383, 0.2860514, 0.2896569, 0.2932547, 0.2968447, 0.3004268, 0.3040009, 0.3075671, 0.3111252, 0.3146752, 0.318217, 0.3217506, 0.3252758, 0.3287927, 0.3323012, 0.3358012, 0.3392926, 0.3427755, 0.3462497, 0.3497153, 0.3531721, 0.3566201, 0.3600593, 0.3634896, 0.366911, 0.3703234, 0.3737268, 0.3771211, 0.3805064, 0.3838825, 0.3872494, 0.390607, 0.3939555, 0.3972946, 0.4006244, 0.4039448, 0.4072558, 0.4105574, 0.4138496, 0.4171322, 0.4204054, 0.4236689, 0.4269229, 0.4301673, 0.4334021, 0.4366272, 0.4398426, 0.4430483, 0.4462443, 0.4494306, 0.452607, 0.4557738, 0.4589307, 0.4620778, 0.465215, 0.4683424, 0.47146, 0.4745676, 0.4776654, 0.4807532, 0.4838312, 0.4868992, 0.4899573, 0.4930055, 0.4960437, 0.4990719, 0.5020902, 0.5050985, 0.5080968, 0.5110852, 0.5140636, 0.517032, 0.5199904, 0.5229388, 0.5258772, 0.5288056, 0.5317241, 0.5346325, 0.537531, 0.5404195, 0.543298, 0.5461666, 0.5490251, 0.5518738, 0.5547124, 0.5575411, 0.5603599, 0.5631687, 0.5659676, 0.5687566, 0.5715357, 0.5743048, 0.5770641, 0.5798135, 0.5825531, 0.5852828, 0.5880026, 0.5907126, 0.5934128, 0.5961032, 0.5987839, 0.6014547, 0.6041158, 0.6067672, 0.6094088, 0.6120407, 0.614663, 0.6172755, 0.6198784, 0.6224717, 0.6250554, 0.6276294, 0.6301939, 0.6327488, 0.6352942, 0.6378301, 0.6403565, 0.6428734, 0.6453808, 0.6478788, 0.6503674, 0.6528466, 0.6553165, 0.657777, 0.6602282, 0.6626701, 0.6651027, 0.6675261, 0.6699402, 0.6723452, 0.6747409, 0.6771276, 0.6795051, 0.6818735, 0.6842328, 0.6865831, 0.6889244, 0.6912567, 0.69358, 0.6958943, 0.6981998, 0.7004964, 0.7027841, 0.705063, 0.707333, 0.7095943, 0.7118469, 0.7140907, 0.7163258, 0.7185523, 0.7207701, 0.7229794, 0.72518, 0.7273721, 0.7295557, 0.7317307, 0.7338974, 0.7360555, 0.7382053, 0.7403467, 0.7424797, 0.7446045, 0.7467209, 0.7488291, 0.7509291, 0.7530208, 0.7551044, 0.7571798, 0.7592472, 0.7613064, 0.7633576, 0.7654008, 0.767436, 0.7694633, 0.7714826, 0.773494, 0.7754975, 0.7774932, 0.7794811, 0.7814612, 0.7834335, 0.7853983, 0.7853983};

    public static double getAngle(Complex sample) {
        return ArcTangent.getAngle(sample.inphase(), sample.quadrature());
    }

    public static double getAngle(double x, double y) {
        double angle;
        double base_angle;
        double y_abs;
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        double x_abs = FastMath.abs((double)x);
        double z = x_abs < (y_abs = FastMath.abs((double)y)) ? x_abs / y_abs : y_abs / x_abs;
        if (z < 0.003921549) {
            base_angle = z;
        } else {
            double alpha = z * 255.5;
            int index = (int)alpha;
            base_angle = sLOOKUP_TABLE[index];
            base_angle += (sLOOKUP_TABLE[index + 1] - sLOOKUP_TABLE[index]) * (alpha -= (double)index);
        }
        if (x_abs > y_abs) {
            if (x >= 0.0) {
                angle = y >= 0.0 ? base_angle : -base_angle;
            } else {
                angle = Math.PI;
                angle = y >= 0.0 ? (angle -= base_angle) : base_angle - angle;
            }
        } else if (y >= 0.0) {
            angle = 1.5707963267948966;
            angle = x >= 0.0 ? (angle -= base_angle) : (angle += base_angle);
        } else {
            angle = -1.5707963267948966;
            angle = x >= 0.0 ? (angle += base_angle) : (angle -= base_angle);
        }
        return angle;
    }
}

