/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum.converter;

import io.github.dsheirer.spectrum.converter.DFTResultsConverter;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealDecibelConverter
extends DFTResultsConverter {
    private static final Logger mLog = LoggerFactory.getLogger(RealDecibelConverter.class);

    @Override
    public void receive(float[] results) {
        float dftBinSizeScalor = 1.0f / (float)results.length;
        float[] processed = new float[results.length / 4];
        int index = 0;
        for (int x = 0; x < processed.length; ++x) {
            index = x * 2;
            processed[x] = 20.0f * (float)FastMath.log10((double)((results[index] * results[index] + results[index + 1] * results[index + 1]) * dftBinSizeScalor));
        }
        this.dispatch(processed);
    }
}

