/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum.converter;

import io.github.dsheirer.spectrum.converter.DFTResultsConverter;
import org.apache.commons.math3.util.FastMath;

public class ComplexDecibelConverter
extends DFTResultsConverter {
    @Override
    public void receive(float[] results) {
        int halfResults = results.length / 2;
        float dftBinSizeScalor = 1.0f / (float)halfResults;
        float[] processed = new float[halfResults];
        int middle = processed.length / 2;
        for (int x = 0; x < results.length; x += 2) {
            float decibels = 10.0f * (float)FastMath.log10((double)((results[x] * results[x] + results[x + 1] * results[x + 1]) * dftBinSizeScalor));
            int index = x / 2;
            if (index >= middle) {
                processed[index - middle] = decibels;
                continue;
            }
            processed[index + middle] = decibels;
        }
        this.dispatch(processed);
    }
}

