/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.spectrum.DFTResultsListener;
import io.github.dsheirer.spectrum.Pausable;
import io.github.dsheirer.spectrum.WaterfallColorModel;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JPanel;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterfallPanel
extends JPanel
implements DFTResultsListener,
Pausable,
SettingChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(WaterfallPanel.class);
    private static DecimalFormat CURSOR_FORMAT = new DecimalFormat("0.00000");
    private static final String PAUSED = "PAUSED - Right Click to Unpause";
    private static final String DISABLED = "DISABLED - Right Click to Select a Tuner";
    private byte[] mPixels;
    private byte[] mPausedPixels;
    private int mDFTSize = 4096;
    private int mImageHeight = 700;
    private MemoryImageSource mMemoryImageSource;
    private ColorModel mColorModel = WaterfallColorModel.getDefaultColorModel();
    private Color mColorSpectrumCursor;
    private Image mWaterfallImage;
    private Point mCursorLocation = new Point(0, 0);
    private boolean mCursorVisible = false;
    private long mCursorFrequency = 0L;
    private boolean mPaused = false;
    private boolean mDisabled = true;
    private int mZoom = 0;
    private int mDFTZoomWindowOffset = 0;
    private SettingsManager mSettingsManager;

    public WaterfallPanel(SettingsManager settingsManager) {
        this.mSettingsManager = settingsManager;
        this.mSettingsManager.addListener(this);
        this.mColorSpectrumCursor = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_CURSOR);
        this.reset();
    }

    public void dispose() {
        if (this.mSettingsManager != null) {
            this.mSettingsManager.removeListener(this);
        }
        this.mSettingsManager = null;
        this.mMemoryImageSource = null;
    }

    private void reset() {
        this.mPixels = new byte[this.mDFTSize * this.mImageHeight];
        this.mMemoryImageSource = new MemoryImageSource(this.mDFTSize, this.mImageHeight, this.mColorModel, this.mPixels, 0, this.mDFTSize);
        this.mMemoryImageSource.setAnimated(true);
        this.mWaterfallImage = this.createImage(this.mMemoryImageSource);
        this.repaint();
    }

    @Override
    public void setPaused(boolean paused) {
        if (paused) {
            this.mPausedPixels = (byte[])this.mPixels.clone();
        }
        this.mPaused = paused;
        this.repaint();
    }

    @Override
    public boolean isPaused() {
        return this.mPaused;
    }

    public boolean isDisabled() {
        return this.mDisabled;
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
    }

    private int getZoomMultiplier() {
        return (int)FastMath.pow((double)2.0, (int)this.mZoom);
    }

    public void setZoomWindowOffset(int offset) {
        this.mDFTZoomWindowOffset = offset;
    }

    private Color getColor(ColorSetting.ColorSettingName name) {
        ColorSetting setting = this.mSettingsManager.getColorSetting(name);
        return setting.getColor();
    }

    @Override
    public void settingChanged(Setting setting) {
        ColorSetting colorSetting;
        if (setting instanceof ColorSetting && (colorSetting = (ColorSetting)setting).getColorSettingName() == ColorSetting.ColorSettingName.SPECTRUM_CURSOR) {
            this.mColorSpectrumCursor = colorSetting.getColor();
        }
    }

    @Override
    public void settingDeleted(Setting setting) {
    }

    public void setCursorLocation(Point point) {
        this.mCursorLocation = point;
        this.repaint();
    }

    public void setCursorFrequency(long frequency) {
        this.mCursorFrequency = frequency;
    }

    public void setCursorVisible(boolean visible) {
        this.mCursorVisible = visible;
        this.repaint();
    }

    private double getPixelOffset(int multiplier) {
        double offset = 0.0;
        if (this.mZoom != 0) {
            double binPixelWidth = this.getBinPixelWidth(multiplier);
            offset = -binPixelWidth * (double)this.mDFTZoomWindowOffset;
        }
        return offset;
    }

    private double getBinPixelWidth(int multiplier) {
        return (double)this.getWidth() * (double)multiplier / (double)this.mDFTSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int multiplier = this.getZoomMultiplier();
        double binPixelWidth = this.getBinPixelWidth(multiplier);
        int offset = (int)(this.getPixelOffset(multiplier) - binPixelWidth);
        g.drawImage(this.mWaterfallImage, offset, 0, this.getWidth() * multiplier + (int)binPixelWidth, this.mImageHeight, this);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.mColorSpectrumCursor);
        if (this.mCursorVisible) {
            graphics.draw(new Line2D.Float(this.mCursorLocation.x, 0.0f, this.mCursorLocation.x, (float)this.getSize().getHeight()));
            String frequency = CURSOR_FORMAT.format((double)this.mCursorFrequency / 1000000.0);
            graphics.drawString(frequency, this.mCursorLocation.x + 5, this.mCursorLocation.y);
        }
        if (this.mDisabled) {
            graphics.drawString(DISABLED, 20, 20);
        } else if (this.mPaused) {
            graphics.drawString(PAUSED, 20, 20);
        }
        this.paintZoomIndicator(graphics);
        graphics.dispose();
    }

    private void paintZoomIndicator(Graphics2D graphics) {
        if (this.mZoom != 0) {
            int width = this.getWidth() / 4;
            int x = this.getWidth() / 2 - width / 2;
            graphics.drawRect(x, this.getHeight() - 12, width, 10);
            int zoomWidth = width / this.getZoomMultiplier();
            int windowOffset = 0;
            if (this.mDFTZoomWindowOffset != 0) {
                windowOffset = (int)((double)this.mDFTZoomWindowOffset / (double)this.mDFTSize * (double)width);
            }
            graphics.fillRect(x + windowOffset, this.getHeight() - 12, zoomWidth, 10);
            graphics.drawString("Zoom: " + this.getZoomMultiplier() + "x", x + width + 3, this.getHeight() - 2);
        }
    }

    @Override
    public void receive(float[] update) {
        this.mDisabled = false;
        byte[] newPixels = new byte[update.length];
        double sum = 0.0;
        for (int x = 0; x < update.length - 1; ++x) {
            sum += (double)update[x];
        }
        float average = (float)(sum / (double)update.length - 1.0);
        float scale = 256.0f / average;
        for (int x = 0; x < update.length - 1; ++x) {
            float value = (average - update[x]) * scale;
            newPixels[x] = value < 0.0f ? 0 : (value > 255.0f ? -1 : (byte)value);
        }
        EventQueue.invokeLater(() -> {
            if (this.mMemoryImageSource != null) {
                if (this.mDFTSize != newPixels.length) {
                    this.mDFTSize = newPixels.length;
                    this.reset();
                }
                System.arraycopy(this.mPixels, 0, this.mPixels, this.mDFTSize, this.mPixels.length - this.mDFTSize);
                System.arraycopy(newPixels, 0, this.mPixels, 0, newPixels.length);
                if (this.mPaused) {
                    this.mMemoryImageSource.newPixels(this.mPausedPixels, this.mColorModel, 0, this.mDFTSize);
                } else {
                    this.mMemoryImageSource.newPixels(this.mPixels, this.mColorModel, 0, this.mDFTSize);
                }
            }
        });
    }

    public void clearWaterfall() {
        Arrays.fill(this.mPixels, (byte)0);
        this.mDisabled = true;
        EventQueue.invokeLater(() -> {
            if (this.mMemoryImageSource != null) {
                try {
                    this.mMemoryImageSource.newPixels(this.mPixels, this.mColorModel, 0, this.mDFTSize);
                }
                catch (Exception e) {
                    mLog.error("Temporary error updating cleared waterfall panel - " + e.getLocalizedMessage());
                }
            }
        });
    }
}

