/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.dsp.filter.smoothing.GaussianSmoothingFilter;
import io.github.dsheirer.dsp.filter.smoothing.NoSmoothingFilter;
import io.github.dsheirer.dsp.filter.smoothing.RectangularSmoothingFilter;
import io.github.dsheirer.dsp.filter.smoothing.SmoothingFilter;
import io.github.dsheirer.dsp.filter.smoothing.TriangularSmoothingFilter;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.spectrum.DFTResultsListener;
import io.github.dsheirer.spectrum.SpectralDisplayAdjuster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Arrays;
import javax.swing.JPanel;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectrumPanel
extends JPanel
implements DFTResultsListener,
SettingChangeListener,
SpectralDisplayAdjuster {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(SpectrumPanel.class);
    private static final RenderingHints RENDERING_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Color mColorSpectrumBackground;
    private Color mColorSpectrumGradientTop;
    private Color mColorSpectrumGradientBottom;
    private Color mColorSpectrumLine;
    private float mSpectrumInset = 20.0f;
    private float[] mDisplayFFTBins = new float[1];
    private int mAveraging = 4;
    private SmoothingFilter mSmoothingFilter = new NoSmoothingFilter();
    private float mDBScale;
    private int mZoom = 0;
    private int mZoomWindowOffset = 0;
    private SettingsManager mSettingsManager;

    public SpectrumPanel(SettingsManager settingsManager) {
        this.mSettingsManager = settingsManager;
        if (this.mSettingsManager != null) {
            this.mSettingsManager.addListener(this);
        }
        this.setSampleSize(16.0);
        this.mSmoothingFilter.setPointSize(9);
        this.getColors();
        this.setAveraging(this.mAveraging);
    }

    public void dispose() {
        if (this.mSettingsManager != null) {
            this.mSettingsManager.removeListener(this);
        }
        this.mSettingsManager = null;
    }

    @Override
    public void receive(float[] currentFFTBins) {
        if (Float.isInfinite(currentFFTBins[0]) || Float.isNaN(currentFFTBins[0])) {
            currentFFTBins = new float[currentFFTBins.length];
        }
        if (this.mDisplayFFTBins == null || this.mDisplayFFTBins.length != currentFFTBins.length) {
            this.mDisplayFFTBins = currentFFTBins;
        }
        float[] smoothedBins = this.mSmoothingFilter.filter(currentFFTBins);
        if (this.mAveraging > 1) {
            float gain = 1.0f / (float)this.mAveraging;
            for (int x = 0; x < this.mDisplayFFTBins.length; ++x) {
                int n = x;
                this.mDisplayFFTBins[n] = this.mDisplayFFTBins[n] + (smoothedBins[x] - this.mDisplayFFTBins[x]) * gain;
            }
        } else {
            this.mDisplayFFTBins = smoothedBins;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setBackground(this.mColorSpectrumBackground);
        graphics.setRenderingHints(RENDERING_HINTS);
        this.drawSpectrum(graphics);
    }

    private void drawSpectrum(Graphics2D graphics) {
        Dimension size = this.getSize();
        Rectangle background = new Rectangle(0, 0, size.width, size.height);
        graphics.setColor(this.mColorSpectrumBackground);
        graphics.draw(background);
        graphics.fill(background);
        GradientPaint gradient = new GradientPaint(0.0f, ((float)this.getSize().height - this.mSpectrumInset) / 2.0f, this.mColorSpectrumGradientTop, 0.0f, this.getSize().height, this.mColorSpectrumGradientBottom);
        graphics.setBackground(this.mColorSpectrumBackground);
        GeneralPath spectrumShape = new GeneralPath();
        spectrumShape.moveTo(size.getWidth(), size.getHeight() - (double)this.mSpectrumInset);
        spectrumShape.lineTo(0.0, size.getHeight() - (double)this.mSpectrumInset);
        float[] bins = this.getBins();
        if (bins != null) {
            float insideHeight = (float)size.height - this.mSpectrumInset;
            float scalor = insideHeight / -this.mDBScale;
            float binSize = (float)size.width / (float)bins.length;
            for (int x = 0; x < bins.length; ++x) {
                float height = bins[x] * scalor;
                if (height > insideHeight) {
                    height = insideHeight;
                }
                if (height < 0.0f) {
                    height = 0.0f;
                }
                float xAxis = (float)x * binSize;
                spectrumShape.lineTo(xAxis, height);
            }
        } else {
            graphics.setPaint(gradient);
            spectrumShape.lineTo(0.0, size.getHeight() - (double)this.mSpectrumInset);
            spectrumShape.lineTo(size.getWidth(), size.getHeight() - (double)this.mSpectrumInset);
        }
        spectrumShape.lineTo(size.getWidth(), size.getHeight() - (double)this.mSpectrumInset);
        graphics.setPaint(gradient);
        graphics.draw(spectrumShape);
        graphics.fill(spectrumShape);
        graphics.setPaint(this.mColorSpectrumLine);
        graphics.draw(new Line2D.Float(0.0f, (float)size.height - this.mSpectrumInset, size.width, (float)size.height - this.mSpectrumInset));
    }

    public void setZoom(int zoom) {
        Validate.isTrue((0 <= zoom && zoom <= 6 ? 1 : 0) != 0, (String)("Unrecognized Zoom Level: " + zoom), (Object[])new Object[0]);
        this.mZoom = zoom;
    }

    public void setZoomWindowOffset(int offset) {
        this.mZoomWindowOffset = offset;
    }

    public void setSampleSize(double sampleSize) {
        Validate.isTrue((2.0 <= sampleSize && sampleSize <= 64.0 ? 1 : 0) != 0);
        this.mDBScale = (float)(20.0 * FastMath.log10((double)FastMath.pow((double)2.0, (double)(sampleSize - 1.0))));
    }

    @Override
    public void setAveraging(int size) {
        this.mAveraging = size;
    }

    @Override
    public int getAveraging() {
        return this.mAveraging;
    }

    public void clearSpectrum() {
        Arrays.fill(this.mDisplayFFTBins, 0.0f);
        this.repaint();
    }

    private void getColors() {
        this.mColorSpectrumBackground = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_BACKGROUND);
        this.mColorSpectrumGradientBottom = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_GRADIENT_BOTTOM);
        this.mColorSpectrumGradientTop = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_GRADIENT_TOP);
        this.mColorSpectrumLine = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_LINE);
    }

    private Color getColor(ColorSetting.ColorSettingName name) {
        ColorSetting setting = this.mSettingsManager.getColorSetting(name);
        return setting.getColor();
    }

    @Override
    public void settingChanged(Setting setting) {
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            switch (((ColorSetting)setting).getColorSettingName()) {
                case SPECTRUM_BACKGROUND: {
                    this.mColorSpectrumBackground = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_GRADIENT_BOTTOM: {
                    this.mColorSpectrumGradientBottom = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_GRADIENT_TOP: {
                    this.mColorSpectrumGradientTop = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_LINE: {
                    this.mColorSpectrumLine = colorSetting.getColor();
                    break;
                }
            }
        }
    }

    private int getZoomMultiplier() {
        return (int)FastMath.pow((double)2.0, (int)this.mZoom);
    }

    private float[] getBins() {
        if (this.mZoom == 0) {
            return this.mDisplayFFTBins;
        }
        int offset = this.mZoomWindowOffset;
        int length = this.mDisplayFFTBins.length / this.getZoomMultiplier();
        if (offset + length >= this.mDisplayFFTBins.length) {
            offset = this.mDisplayFFTBins.length - length;
        }
        if (offset < 0) {
            offset = 0;
        }
        return Arrays.copyOfRange(this.mDisplayFFTBins, offset, offset + length);
    }

    @Override
    public void settingDeleted(Setting setting) {
    }

    @Override
    public int getSmoothing() {
        return this.mSmoothingFilter.getPointSize();
    }

    @Override
    public void setSmoothing(int smoothing) {
        this.mSmoothingFilter.setPointSize(smoothing);
    }

    @Override
    public SmoothingFilter.SmoothingType getSmoothingType() {
        return this.mSmoothingFilter.getSmoothingType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSmoothingType(SmoothingFilter.SmoothingType type) {
        if (this.mSmoothingFilter.getSmoothingType() != type) {
            int pointSize = this.getSmoothing();
            SmoothingFilter smoothingFilter = this.mSmoothingFilter;
            synchronized (smoothingFilter) {
                switch (type) {
                    case GAUSSIAN: {
                        this.mSmoothingFilter = new GaussianSmoothingFilter();
                        break;
                    }
                    case RECTANGLE: {
                        this.mSmoothingFilter = new RectangularSmoothingFilter();
                        break;
                    }
                    case TRIANGLE: {
                        this.mSmoothingFilter = new TriangularSmoothingFilter();
                        break;
                    }
                    default: {
                        this.mSmoothingFilter = new NoSmoothingFilter();
                    }
                }
            }
            this.setSmoothing(pointSize);
        }
    }

    static {
        RENDERING_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

