/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import com.jidesoft.swing.JideSplitPane;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelModel;
import io.github.dsheirer.controller.channel.ChannelProcessingManager;
import io.github.dsheirer.dsp.filter.smoothing.SmoothingFilter;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.channel.ViewChannelRequest;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.ColorSettingMenuItem;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import io.github.dsheirer.spectrum.ComplexDftProcessor;
import io.github.dsheirer.spectrum.DFTSize;
import io.github.dsheirer.spectrum.DisableSpectrumWaterfallMenuItem;
import io.github.dsheirer.spectrum.IDFTWidthChangeProcessor;
import io.github.dsheirer.spectrum.OverlayPanel;
import io.github.dsheirer.spectrum.Pausable;
import io.github.dsheirer.spectrum.ShowTunerMenuItem;
import io.github.dsheirer.spectrum.SpectrumPanel;
import io.github.dsheirer.spectrum.WaterfallPanel;
import io.github.dsheirer.spectrum.converter.ComplexDecibelConverter;
import io.github.dsheirer.spectrum.converter.DFTResultsConverter;
import io.github.dsheirer.spectrum.menu.AveragingItem;
import io.github.dsheirer.spectrum.menu.DFTSizeItem;
import io.github.dsheirer.spectrum.menu.FFTWindowTypeItem;
import io.github.dsheirer.spectrum.menu.FrameRateItem;
import io.github.dsheirer.spectrum.menu.SmoothingItem;
import io.github.dsheirer.spectrum.menu.SmoothingTypeItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectralDisplayPanel
extends JPanel
implements Listener<INativeBuffer>,
ISourceEventProcessor,
IDFTWidthChangeProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(SpectralDisplayPanel.class);
    public static final String FFT_SIZE_PROPERTY = "spectral.display.dft.size";
    public static final String SPECTRAL_DISPLAY_ENABLED = "spectral.display.enabled";
    public static final int NO_ZOOM = 0;
    public static final int MAX_ZOOM = 6;
    private DFTSize mDFTSize = DFTSize.FFT04096;
    private int mZoom = 0;
    private int mDFTZoomWindowOffset = 0;
    private JScrollPane mScrollPane;
    private JLayeredPane mLayeredPanel;
    private SpectrumPanel mSpectrumPanel;
    private WaterfallPanel mWaterfallPanel;
    private OverlayPanel mOverlayPanel;
    private ComplexDftProcessor mComplexDftProcessor;
    private DFTResultsConverter mDFTConverter;
    private ChannelModel mChannelModel;
    private ChannelProcessingManager mChannelProcessingManager;
    private SettingsManager mSettingsManager;
    private DiscoveredTunerModel mDiscoveredTunerModel;
    private Tuner mTuner;

    public SpectralDisplayPanel(PlaylistManager playlistManager, SettingsManager settingsManager, DiscoveredTunerModel discoveredTunerModel) {
        this.mChannelModel = playlistManager.getChannelModel();
        this.mChannelProcessingManager = playlistManager.getChannelProcessingManager();
        this.mSettingsManager = settingsManager;
        this.mDiscoveredTunerModel = discoveredTunerModel;
        this.mSpectrumPanel = new SpectrumPanel(this.mSettingsManager);
        this.mOverlayPanel = new OverlayPanel(this.mSettingsManager, this.mChannelModel, this.mChannelProcessingManager);
        this.mWaterfallPanel = new WaterfallPanel(this.mSettingsManager);
        this.init();
        this.loadSettings();
    }

    private void loadSettings() {
        SystemProperties properties = SystemProperties.getInstance();
        String rawSize = properties.get(FFT_SIZE_PROPERTY, DFTSize.FFT04096.name());
        DFTSize size = null;
        if (rawSize != null) {
            try {
                size = DFTSize.valueOf(rawSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (size == null) {
            size = DFTSize.FFT04096;
        }
        this.setDFTSize(size, false);
    }

    public void dispose() {
        this.clearTuner();
        this.mSettingsManager = null;
        this.mComplexDftProcessor.dispose();
        this.mComplexDftProcessor = null;
        this.mDFTConverter.dispose();
        this.mDFTConverter = null;
        this.mSpectrumPanel.dispose();
        this.mSpectrumPanel = null;
        this.mWaterfallPanel.dispose();
        this.mWaterfallPanel = null;
        this.mOverlayPanel.dispose();
        this.mOverlayPanel = null;
        this.mTuner = null;
    }

    public void setDFTSize(DFTSize size, boolean save) {
        this.mComplexDftProcessor.setDFTSize(size);
        this.mOverlayPanel.setDFTSize(size);
        this.mDFTSize = size;
        if (save) {
            SystemProperties.getInstance().set(FFT_SIZE_PROPERTY, size.name());
        }
        this.setZoom(0, 0L, 0.0);
    }

    @Override
    public void setDFTSize(DFTSize size) {
        this.setDFTSize(size, true);
    }

    @Override
    public DFTSize getDFTSize() {
        return this.mDFTSize;
    }

    public int getZoom() {
        return this.mZoom;
    }

    public void setZoom(int zoom, long frequency, double windowOffset) {
        if (zoom < 0) {
            zoom = 0;
        } else if (zoom > 6) {
            zoom = 6;
        }
        if (zoom != this.mZoom) {
            this.mZoom = zoom;
            double binOffsetToFrequency = this.getBinOffset(frequency);
            double windowBinOffset = (double)this.getZoomWindowSizeInBins() * windowOffset;
            double offset = binOffsetToFrequency - windowBinOffset;
            this.mSpectrumPanel.setZoom(this.mZoom);
            this.mOverlayPanel.setZoom(this.mZoom);
            this.mWaterfallPanel.setZoom(this.mZoom);
            this.setZoomWindowOffset(offset);
        }
    }

    public void setZoomWindowOffset(double offset) {
        if (offset < 0.0) {
            offset = 0.0;
        }
        if (offset > (double)(this.mDFTSize.getSize() - this.getZoomWindowSizeInBins())) {
            offset = this.mDFTSize.getSize() - this.getZoomWindowSizeInBins();
        }
        this.mDFTZoomWindowOffset = (int)offset;
        this.mSpectrumPanel.setZoomWindowOffset(this.mDFTZoomWindowOffset);
        this.mOverlayPanel.setZoomWindowOffset(this.mDFTZoomWindowOffset);
        this.mWaterfallPanel.setZoomWindowOffset(this.mDFTZoomWindowOffset);
    }

    private int getZoomWindowSizeInBins() {
        return this.mDFTSize.getSize() / this.getZoomMultiplier();
    }

    public int getZoomMultiplier() {
        return (int)FastMath.pow((double)2.0, (int)this.mZoom);
    }

    private double getBinOffset(long frequency) {
        double offset = 0.0;
        if (this.mOverlayPanel.containsFrequency(frequency)) {
            offset = (double)this.mDFTSize.getSize() * ((double)(frequency - this.mOverlayPanel.getMinFrequency()) / (double)this.mOverlayPanel.getBandwidth());
        }
        return offset;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow]", "[grow]"));
        this.mLayeredPanel = new JLayeredPane();
        this.mLayeredPanel.addComponentListener(new ResizeListener());
        MouseEventProcessor mouser = new MouseEventProcessor();
        this.mOverlayPanel.addMouseListener(mouser);
        this.mOverlayPanel.addMouseMotionListener(mouser);
        this.mOverlayPanel.addMouseWheelListener(mouser);
        this.mLayeredPanel.add(this.mSpectrumPanel, 0, 0);
        this.mLayeredPanel.add(this.mOverlayPanel, 1, 0);
        this.mWaterfallPanel.addMouseListener(mouser);
        this.mWaterfallPanel.addMouseMotionListener(mouser);
        this.mWaterfallPanel.addMouseWheelListener(mouser);
        double totalHeight = this.mLayeredPanel.getPreferredSize().getHeight() + this.mWaterfallPanel.getPreferredSize().getHeight();
        this.mLayeredPanel.setPreferredSize(new Dimension((int)this.mLayeredPanel.getPreferredSize().getWidth(), (int)(totalHeight / 2.0)));
        this.mWaterfallPanel.setPreferredSize(new Dimension((int)this.mWaterfallPanel.getPreferredSize().getWidth(), (int)(totalHeight / 2.0)));
        JideSplitPane splitPane = new JideSplitPane(0);
        splitPane.setDividerSize(5);
        splitPane.add((Component)this.mLayeredPanel);
        splitPane.add((Component)this.mWaterfallPanel);
        this.mScrollPane = new JScrollPane((Component)splitPane);
        this.add((Component)this.mScrollPane, "grow");
        this.mComplexDftProcessor = new ComplexDftProcessor();
        this.mDFTConverter = new ComplexDecibelConverter();
        this.mComplexDftProcessor.addConverter(this.mDFTConverter);
        this.mDFTConverter.addListener(this.mSpectrumPanel);
        this.mDFTConverter.addListener(this.mWaterfallPanel);
    }

    @Override
    public void process(SourceEvent event) {
        this.mOverlayPanel.process(event);
    }

    @Override
    public void receive(INativeBuffer nativeBuffer) {
        this.mComplexDftProcessor.receive(nativeBuffer);
    }

    public void showTuner(Tuner tuner) {
        this.clearTuner();
        this.mComplexDftProcessor.clearBuffer();
        this.mComplexDftProcessor.start();
        this.mTuner = tuner;
        if (this.mTuner != null) {
            this.mTuner.getTunerController().addBufferListener(this.mComplexDftProcessor);
            if (this.mTuner != null) {
                this.mTuner.getTunerController().addListener(this);
                this.mSpectrumPanel.setSampleSize(this.mTuner.getSampleSize());
                this.process(SourceEvent.frequencyChange(null, this.mTuner.getTunerController().getFrequency()));
                this.process(SourceEvent.sampleRateChange(this.mTuner.getTunerController().getSampleRate()));
            }
        }
    }

    public void clearTuner() {
        if (this.mTuner != null) {
            this.mTuner.getTunerController().removeListener(this);
            this.mTuner.getTunerController().removeBufferListener(this.mComplexDftProcessor);
            this.mTuner = null;
        }
        this.mComplexDftProcessor.stop();
        this.mComplexDftProcessor.clearBuffer();
        this.mSpectrumPanel.clearSpectrum();
        this.mWaterfallPanel.clearWaterfall();
    }

    public Tuner getTuner() {
        return this.mTuner;
    }

    public class ResizeListener
    implements ComponentListener {
        @Override
        public void componentResized(ComponentEvent e) {
            Component c = e.getComponent();
            SpectralDisplayPanel.this.mSpectrumPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
            SpectralDisplayPanel.this.mOverlayPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }

    public class MouseEventProcessor
    extends MouseInputAdapter {
        private int mDFTZoomWindowOffsetAtDragStart = 0;
        private int mDragStartX = 0;
        private double mPixelsPerBin;

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int zoom = SpectralDisplayPanel.this.mZoom - e.getWheelRotation();
            long frequency = SpectralDisplayPanel.this.mOverlayPanel.getFrequencyFromAxis(e.getX());
            double windowOffset = (double)e.getX() / (double)SpectralDisplayPanel.this.getWidth();
            SpectralDisplayPanel.this.setZoom(zoom, frequency, windowOffset);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.update(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int maxOffset;
            this.update(event);
            int dragDistance = this.mDragStartX - event.getX();
            double binDistance = (double)dragDistance / this.mPixelsPerBin;
            int offset = (int)((double)this.mDFTZoomWindowOffsetAtDragStart + binDistance);
            if (offset < 0) {
                offset = 0;
            }
            if (offset > (maxOffset = SpectralDisplayPanel.this.mDFTSize.getSize() - SpectralDisplayPanel.this.mDFTSize.getSize() / SpectralDisplayPanel.this.getZoomMultiplier())) {
                offset = maxOffset;
            }
            SpectralDisplayPanel.this.setZoomWindowOffset(offset);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mDragStartX = e.getX();
            this.mDFTZoomWindowOffsetAtDragStart = SpectralDisplayPanel.this.mDFTZoomWindowOffset;
            this.mPixelsPerBin = (double)SpectralDisplayPanel.this.getWidth() / ((double)SpectralDisplayPanel.this.mDFTSize.getSize() / (double)SpectralDisplayPanel.this.getZoomMultiplier());
        }

        private void update(MouseEvent event) {
            if (event.getComponent() == SpectralDisplayPanel.this.mOverlayPanel) {
                SpectralDisplayPanel.this.mOverlayPanel.setCursorLocation(event.getPoint());
            } else {
                SpectralDisplayPanel.this.mWaterfallPanel.setCursorLocation(event.getPoint());
                SpectralDisplayPanel.this.mWaterfallPanel.setCursorFrequency(SpectralDisplayPanel.this.mOverlayPanel.getFrequencyFromAxis(event.getPoint().x));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getComponent() == SpectralDisplayPanel.this.mOverlayPanel) {
                SpectralDisplayPanel.this.mOverlayPanel.setCursorVisible(true);
            } else {
                SpectralDisplayPanel.this.mWaterfallPanel.setCursorVisible(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SpectralDisplayPanel.this.mOverlayPanel.setCursorVisible(false);
            SpectralDisplayPanel.this.mWaterfallPanel.setCursorVisible(false);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                JPopupMenu contextMenu = new JPopupMenu();
                if (event.getComponent() == SpectralDisplayPanel.this.mWaterfallPanel) {
                    contextMenu.add(new PauseItem(SpectralDisplayPanel.this.mWaterfallPanel, "Pause"));
                    contextMenu.add(new JSeparator());
                }
                long frequency = SpectralDisplayPanel.this.mOverlayPanel.getFrequencyFromAxis(event.getX());
                if (event.getComponent() == SpectralDisplayPanel.this.mOverlayPanel) {
                    ArrayList<Channel> channels = SpectralDisplayPanel.this.mOverlayPanel.getChannelsAtFrequency(frequency);
                    JMenu channelMenu = new JMenu("Channels");
                    for (Channel channel : channels) {
                        JMenuItem viewChannel = new JMenuItem("View/Edit: " + channel.getShortTitle());
                        viewChannel.addActionListener(e -> MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel)));
                        channelMenu.add(viewChannel);
                    }
                    contextMenu.add(channelMenu);
                    if (!channels.isEmpty()) {
                        contextMenu.add(new JSeparator());
                    }
                }
                JMenu colorMenu = new JMenu("Color");
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.CHANNEL_CONFIG));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.CHANNEL_CONFIG_PROCESSING));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.CHANNEL_CONFIG_SELECTED));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.SPECTRUM_CURSOR));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.SPECTRUM_LINE));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.SPECTRUM_BACKGROUND));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.SPECTRUM_GRADIENT_BOTTOM));
                colorMenu.add(new ColorSettingMenuItem(SpectralDisplayPanel.this.mSettingsManager, ColorSetting.ColorSettingName.SPECTRUM_GRADIENT_TOP));
                contextMenu.add(colorMenu);
                JMenu displayMenu = new JMenu("Display");
                contextMenu.add(displayMenu);
                if (event.getComponent() != SpectralDisplayPanel.this.mWaterfallPanel) {
                    JMenu averagingMenu = new JMenu("Averaging");
                    averagingMenu.add(new AveragingItem(SpectralDisplayPanel.this.mSpectrumPanel, 4));
                    displayMenu.add(averagingMenu);
                    JMenu channelDisplayMenu = new JMenu("Channel");
                    channelDisplayMenu.add(new ChannelDisplayItem(SpectralDisplayPanel.this.mOverlayPanel, OverlayPanel.ChannelDisplay.ALL));
                    channelDisplayMenu.add(new ChannelDisplayItem(SpectralDisplayPanel.this.mOverlayPanel, OverlayPanel.ChannelDisplay.ENABLED));
                    channelDisplayMenu.add(new ChannelDisplayItem(SpectralDisplayPanel.this.mOverlayPanel, OverlayPanel.ChannelDisplay.NONE));
                    displayMenu.add(channelDisplayMenu);
                }
                JMenu fftWidthMenu = new JMenu("FFT Width");
                displayMenu.add(fftWidthMenu);
                for (DFTSize width : DFTSize.values()) {
                    fftWidthMenu.add(new DFTSizeItem(SpectralDisplayPanel.this, width));
                }
                JMenu frameRateMenu = new JMenu("Frame Rate");
                displayMenu.add(frameRateMenu);
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 14));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 16));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 18));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 20));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 25));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 30));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 40));
                frameRateMenu.add(new FrameRateItem(SpectralDisplayPanel.this.mComplexDftProcessor, 50));
                JMenu fftWindowType = new JMenu("Window Type");
                displayMenu.add(fftWindowType);
                for (WindowType type : WindowType.values()) {
                    fftWindowType.add(new FFTWindowTypeItem(SpectralDisplayPanel.this.mComplexDftProcessor, type));
                }
                if (event.getComponent() != SpectralDisplayPanel.this.mWaterfallPanel) {
                    JMenu smoothingMenu = new JMenu("Smoothing");
                    if (SpectralDisplayPanel.this.mSpectrumPanel.getSmoothingType() != SmoothingFilter.SmoothingType.NONE) {
                        smoothingMenu.add(new SmoothingItem(SpectralDisplayPanel.this.mSpectrumPanel, 5));
                        smoothingMenu.add(new JSeparator());
                    }
                    smoothingMenu.add(new SmoothingTypeItem(SpectralDisplayPanel.this.mSpectrumPanel, SmoothingFilter.SmoothingType.GAUSSIAN));
                    smoothingMenu.add(new SmoothingTypeItem(SpectralDisplayPanel.this.mSpectrumPanel, SmoothingFilter.SmoothingType.TRIANGLE));
                    smoothingMenu.add(new SmoothingTypeItem(SpectralDisplayPanel.this.mSpectrumPanel, SmoothingFilter.SmoothingType.RECTANGLE));
                    smoothingMenu.add(new SmoothingTypeItem(SpectralDisplayPanel.this.mSpectrumPanel, SmoothingFilter.SmoothingType.NONE));
                    displayMenu.add(smoothingMenu);
                }
                JMenu zoomMenu = new JMenu("Zoom");
                double windowOffset = (double)event.getX() / (double)SpectralDisplayPanel.this.getWidth();
                ((Container)zoomMenu).add(new ZoomItem(frequency, windowOffset));
                contextMenu.add(zoomMenu);
                if (SpectralDisplayPanel.this.mTuner != null) {
                    contextMenu.add(new JSeparator());
                    contextMenu.add(new DisableSpectrumWaterfallMenuItem(SpectralDisplayPanel.this));
                }
                boolean separatorAdded = false;
                for (DiscoveredTuner discoveredTuner : SpectralDisplayPanel.this.mDiscoveredTunerModel.getAvailableTuners()) {
                    if (SpectralDisplayPanel.this.mTuner != null && SpectralDisplayPanel.this.mTuner == discoveredTuner.getTuner()) continue;
                    if (!separatorAdded) {
                        contextMenu.add(new JSeparator());
                        separatorAdded = true;
                    }
                    contextMenu.add(new ShowTunerMenuItem(SpectralDisplayPanel.this.mDiscoveredTunerModel, discoveredTuner.getTuner()));
                }
                if (contextMenu != null) {
                    if (event.getComponent() == SpectralDisplayPanel.this.mOverlayPanel) {
                        contextMenu.show(SpectralDisplayPanel.this.mOverlayPanel, event.getX(), event.getY());
                    } else {
                        contextMenu.show(SpectralDisplayPanel.this.mWaterfallPanel, event.getX(), event.getY());
                    }
                }
            }
        }
    }

    public class ChannelDisplayItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private OverlayPanel mOverlayPanel;
        private OverlayPanel.ChannelDisplay mChannelDisplay;

        public ChannelDisplayItem(OverlayPanel panel, OverlayPanel.ChannelDisplay display) {
            super(display.name());
            this.mOverlayPanel = panel;
            this.mChannelDisplay = display;
            this.setSelected(this.mOverlayPanel.getChannelDisplay() == this.mChannelDisplay);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChannelDisplayItem.this.mOverlayPanel.setChannelDisplay(ChannelDisplayItem.this.mChannelDisplay);
                        }
                    });
                }
            });
        }
    }

    public class ZoomItem
    extends JSlider {
        private static final long serialVersionUID = 1L;
        private long mFrequency;
        private double mWindowOffset;

        public ZoomItem(long frequency, double windowOffset) {
            super(0, 6, SpectralDisplayPanel.this.mZoom);
            this.mFrequency = frequency;
            this.mWindowOffset = windowOffset;
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(0, new JLabel("1x"));
            labels.put(1, new JLabel("2x"));
            labels.put(2, new JLabel("4x"));
            labels.put(3, new JLabel("8x"));
            labels.put(4, new JLabel("16x"));
            labels.put(5, new JLabel("32x"));
            labels.put(6, new JLabel("64x"));
            this.setLabelTable(labels);
            this.setMajorTickSpacing(1);
            this.setMinorTickSpacing(1);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpectralDisplayPanel.this.setZoom(ZoomItem.this.getValue(), ZoomItem.this.mFrequency, ZoomItem.this.mWindowOffset);
                }
            });
        }
    }

    public class PauseItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private Pausable mPausable;

        public PauseItem(Pausable pausable, String label) {
            super(label);
            final boolean paused = pausable.isPaused();
            this.setSelected(paused);
            this.mPausable = pausable;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PauseItem.this.mPausable.setPaused(!paused);
                        }
                    });
                }
            });
        }
    }
}

