/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.ChannelModel;
import io.github.dsheirer.controller.channel.ChannelProcessingManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.spectrum.DFTSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import org.apache.commons.math3.util.FastMath;

public class OverlayPanel
extends JPanel
implements Listener<ChannelEvent>,
ISourceEventProcessor,
SettingChangeListener {
    private static final long serialVersionUID = 1L;
    private final DecimalFormat PPM_FORMATTER = new DecimalFormat("#.0");
    private static final RenderingHints RENDERING_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final BasicStroke DASHED_STROKE;
    private static DecimalFormat CURSOR_FORMAT;
    private long mFrequency = 0L;
    private int mBandwidth = 0;
    private Point mCursorLocation = new Point(0, 0);
    private boolean mCursorVisible = false;
    private DFTSize mDFTSize = DFTSize.FFT04096;
    private int mZoom = 0;
    private int mDFTZoomWindowOffset = 0;
    private Color mColorChannelConfig;
    private Color mColorChannelConfigProcessing;
    private Color mColorChannelConfigSelected;
    private Color mColorSpectrumBackground;
    private Color mColorSpectrumCursor;
    private Color mColorSpectrumLine;
    private List<Channel> mVisibleChannels = new CopyOnWriteArrayList<Channel>();
    private List<Channel> mTrafficChannels = new CopyOnWriteArrayList<Channel>();
    private ChannelDisplay mChannelDisplay = ChannelDisplay.ALL;
    private double mSpectrumInset = 20.0;
    private LabelSizeManager mLabelSizeMonitor = new LabelSizeManager();
    private SettingsManager mSettingsManager;
    private ChannelModel mChannelModel;
    private ChannelProcessingManager mChannelProcessingManager;

    public OverlayPanel(SettingsManager settingsManager, ChannelModel channelModel, ChannelProcessingManager channelProcessingManager) {
        this.mSettingsManager = settingsManager;
        if (this.mSettingsManager != null) {
            this.mSettingsManager.addListener(this);
        }
        this.mChannelModel = channelModel;
        if (this.mChannelModel != null) {
            this.mChannelModel.addListener(this::receive);
        }
        this.mChannelProcessingManager = channelProcessingManager;
        if (this.mChannelProcessingManager != null) {
            this.mChannelProcessingManager.addChannelEventListener(this::receive);
        }
        this.addComponentListener(this.mLabelSizeMonitor);
        this.setOpaque(false);
        this.setColors();
    }

    public void dispose() {
        if (this.mChannelModel != null) {
            this.mChannelModel.removeListener(this);
        }
        this.mChannelModel = null;
        this.mVisibleChannels.clear();
        if (this.mSettingsManager != null) {
            this.mSettingsManager.removeListener(this);
        }
        this.mSettingsManager = null;
    }

    public void setDFTSize(DFTSize size) {
        this.mDFTSize = size;
    }

    public ChannelDisplay getChannelDisplay() {
        return this.mChannelDisplay;
    }

    public void setChannelDisplay(ChannelDisplay display) {
        this.mChannelDisplay = display;
    }

    public void setCursorLocation(Point point) {
        this.mCursorLocation = point;
        this.repaint();
    }

    public void setCursorVisible(boolean visible) {
        this.mCursorVisible = visible;
        this.repaint();
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
        this.mLabelSizeMonitor.update();
    }

    public void setZoomWindowOffset(int offset) {
        this.mDFTZoomWindowOffset = offset;
    }

    private void setColors() {
        this.mColorChannelConfig = this.getColor(ColorSetting.ColorSettingName.CHANNEL_CONFIG);
        this.mColorChannelConfigProcessing = this.getColor(ColorSetting.ColorSettingName.CHANNEL_CONFIG_PROCESSING);
        this.mColorChannelConfigSelected = this.getColor(ColorSetting.ColorSettingName.CHANNEL_CONFIG_SELECTED);
        this.mColorSpectrumCursor = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_CURSOR);
        this.mColorSpectrumLine = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_LINE);
        this.mColorSpectrumBackground = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_BACKGROUND);
    }

    private Color getColor(ColorSetting.ColorSettingName name) {
        ColorSetting setting = this.mSettingsManager.getColorSetting(name);
        return setting.getColor();
    }

    @Override
    public void settingChanged(Setting setting) {
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            switch (colorSetting.getColorSettingName()) {
                case CHANNEL_CONFIG: {
                    this.mColorChannelConfig = colorSetting.getColor();
                    break;
                }
                case CHANNEL_CONFIG_PROCESSING: {
                    this.mColorChannelConfigProcessing = colorSetting.getColor();
                    break;
                }
                case CHANNEL_CONFIG_SELECTED: {
                    this.mColorChannelConfigSelected = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_BACKGROUND: {
                    this.mColorSpectrumBackground = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_CURSOR: {
                    this.mColorSpectrumCursor = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_LINE: {
                    this.mColorSpectrumLine = colorSetting.getColor();
                    break;
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setBackground(this.mColorSpectrumBackground);
        graphics.setRenderingHints(RENDERING_HINTS);
        this.drawFrequencies(graphics);
        this.drawChannels(graphics);
        this.drawCursor(graphics);
    }

    private void drawCursor(Graphics2D graphics) {
        if (this.mCursorVisible) {
            this.drawFrequencyLine(graphics, this.mCursorLocation.x, this.mColorSpectrumCursor);
            String frequency = CURSOR_FORMAT.format((double)this.getFrequencyFromAxis(this.mCursorLocation.getX()) / 1000000.0);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            Rectangle2D rect = fontMetrics.getStringBounds(frequency, graphics);
            if ((double)this.mCursorLocation.y > rect.getHeight()) {
                graphics.drawString(frequency, this.mCursorLocation.x + 5, this.mCursorLocation.y);
            }
            if (this.mZoom != 0) {
                graphics.drawString("Zoom: " + (int)FastMath.pow((double)2.0, (int)this.mZoom) + "x", this.mCursorLocation.x + 17, this.mCursorLocation.y + 11);
            }
        }
    }

    private void drawFrequencies(Graphics2D graphics) {
        Stroke currentStroke = graphics.getStroke();
        long minFrequency = this.getMinDisplayFrequency();
        long maxFrequency = this.getMaxDisplayFrequency();
        int label = this.mLabelSizeMonitor.getLabelIncrement(graphics);
        int major = this.mLabelSizeMonitor.getMajorTickIncrement(graphics);
        int minor = this.mLabelSizeMonitor.getMinorTickIncrement(graphics);
        if (minor == 0) {
            minor = 1;
        }
        if (label == 0) {
            label = 1;
        }
        for (long frequency = minFrequency - minFrequency % (long)minor; frequency < maxFrequency; frequency += (long)minor) {
            if (frequency % (long)label == 0L) {
                this.drawFrequencyLineAndLabel(graphics, frequency);
                continue;
            }
            if (frequency % (long)major == 0L) {
                this.drawTickLine(graphics, frequency, true);
                continue;
            }
            this.drawTickLine(graphics, frequency, false);
        }
    }

    private void drawFrequencyLineAndLabel(Graphics2D graphics, long frequency) {
        double xAxis = this.getAxisFromFrequency(frequency);
        this.drawFrequencyLine(graphics, xAxis, this.mColorSpectrumLine);
        this.drawTickLine(graphics, frequency, false);
        graphics.setColor(this.mColorSpectrumLine);
        this.drawFrequencyLabel(graphics, xAxis, frequency);
    }

    private void drawTickLine(Graphics2D graphics, long frequency, boolean major) {
        graphics.setColor(this.mColorSpectrumLine);
        double xAxis = this.getAxisFromFrequency(frequency);
        double start = this.getSize().getHeight() - this.mSpectrumInset;
        double end = start + (major ? 9.0 : 3.0);
        graphics.draw(new Line2D.Double(xAxis, start, xAxis, end));
    }

    private void drawFrequencyLine(Graphics2D graphics, double xaxis, Color color) {
        graphics.setColor(color);
        graphics.draw(new Line2D.Double(xaxis, 0.0, xaxis, this.getSize().getHeight() - this.mSpectrumInset));
    }

    private void drawChannelCenterLine(Graphics2D graphics, double xaxis) {
        double height = this.getSize().getHeight() - this.mSpectrumInset;
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.draw(new Line2D.Double(xaxis, height * 0.65, xaxis, height - 1.0));
    }

    private void drawAFC(Graphics2D graphics, double frequencyAxis, double errorAxis, double bandwidth, int correction, long frequency) {
        double height = this.getSize().getHeight() - this.mSpectrumInset;
        double verticalAxisTop = height * 0.88;
        double verticalAxisBottom = height * 0.98;
        double halfBandwidth = bandwidth / 2.0;
        double errorEdgeStart = errorAxis - halfBandwidth;
        double errorEdgeStop = errorAxis + halfBandwidth;
        graphics.setColor(Color.YELLOW);
        graphics.draw(new Line2D.Double(errorEdgeStart, verticalAxisBottom, errorEdgeStop, verticalAxisBottom));
        graphics.draw(new Line2D.Double(errorEdgeStart, verticalAxisTop, errorEdgeStart, verticalAxisBottom));
        graphics.draw(new Line2D.Double(errorEdgeStop, verticalAxisTop, errorEdgeStop, verticalAxisBottom));
        double ppm = (double)correction / ((double)frequency / 1000000.0);
        String label = "PPM " + this.PPM_FORMATTER.format(ppm);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, graphics);
        if (rect.getWidth() <= bandwidth && rect.getHeight() * 5.0 <= height) {
            graphics.drawString(label, (float)(errorEdgeStart + 1.0), (float)(verticalAxisBottom - 2.0));
        }
    }

    private double getAxisFromFrequency(long frequency) {
        double screenWidth = this.getSize().getWidth();
        double pixelsPerBin = screenWidth / (double)this.mDFTSize.getSize();
        double pixelOffsetToMinDisplayFrequency = pixelsPerBin * 2.0;
        double frequencyOffset = frequency - this.getMinDisplayFrequency();
        double ratio = frequencyOffset / (double)this.getDisplayBandwidth();
        double screenOffset = screenWidth * ratio;
        return pixelOffsetToMinDisplayFrequency + screenOffset;
    }

    public long getFrequencyFromAxis(double xAxis) {
        double width = this.getSize().getWidth();
        double offset = xAxis / width;
        long frequency = this.getMinDisplayFrequency() + FastMath.round((double)((double)this.getDisplayBandwidth() * offset));
        if (frequency > this.getMaxFrequency()) {
            frequency = this.getMaxFrequency();
        }
        return frequency;
    }

    private void drawFrequencyLabel(Graphics2D graphics, double xaxis, long frequency) {
        String label = this.mLabelSizeMonitor.format(frequency);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, graphics);
        float xOffset = (float)rect.getWidth() / 2.0f;
        graphics.drawString(label, (float)(xaxis - (double)xOffset), (float)(this.getSize().getHeight() - 2.0));
    }

    private void drawChannels(Graphics2D graphics) {
        for (Channel channel : this.mVisibleChannels) {
            TunerChannel tunerChannel;
            if (this.mChannelDisplay != ChannelDisplay.ALL && (this.mChannelDisplay != ChannelDisplay.ENABLED || !channel.isProcessing())) continue;
            if (channel.isSelected()) {
                graphics.setColor(this.mColorChannelConfigSelected);
            } else if (channel.isProcessing()) {
                graphics.setColor(this.mColorChannelConfigProcessing);
            } else {
                graphics.setColor(this.mColorChannelConfig);
            }
            if ((tunerChannel = channel.getTunerChannel()) == null) continue;
            double xAxis = this.getAxisFromFrequency(tunerChannel.getFrequency());
            double width = (double)tunerChannel.getBandwidth() / (double)this.getDisplayBandwidth() * this.getSize().getWidth();
            Rectangle2D.Double box = new Rectangle2D.Double(xAxis - width / 2.0, 0.0, width, this.getSize().getHeight() - this.mSpectrumInset);
            graphics.fill(box);
            graphics.draw(box);
            graphics.setColor(this.mColorSpectrumLine);
            double yAxis = 0.0;
            String system = channel.hasSystem() ? channel.getSystem() : " ";
            yAxis += this.drawLabel(graphics, system, this.getFont(), xAxis, yAxis, width);
            String site = channel.hasSite() ? channel.getSite() : " ";
            yAxis += this.drawLabel(graphics, site, this.getFont(), xAxis, yAxis, width);
            yAxis += this.drawLabel(graphics, channel.getName(), this.getFont(), xAxis, yAxis, width);
            this.drawLabel(graphics, channel.getDecodeConfiguration().getDecoderType().getShortDisplayString(), this.getFont(), xAxis, yAxis, width);
            long frequency = tunerChannel.getFrequency();
            double frequencyAxis = this.getAxisFromFrequency(frequency);
            this.drawChannelCenterLine(graphics, frequencyAxis);
            int correction = channel.getChannelFrequencyCorrection();
            if (correction == 0) continue;
            long error = frequency + (long)correction;
            this.drawAFC(graphics, frequencyAxis, this.getAxisFromFrequency(error), width, correction, tunerChannel.getFrequency());
        }
    }

    private double drawLabel(Graphics2D graphics, String text, Font font, double x, double baseY, double maxWidth) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        Rectangle2D label = fontMetrics.getStringBounds(text, graphics);
        double offset = label.getWidth() / 2.0;
        double y = baseY + label.getHeight();
        if (offset > maxWidth / 2.0) {
            label.setRect(x - maxWidth / 2.0, y - label.getHeight(), maxWidth, label.getHeight());
            graphics.setClip(label);
            graphics.drawString(text, (float)(x - maxWidth / 2.0), (float)y);
            graphics.setClip(null);
        } else {
            graphics.drawString(text, (float)(x - offset), (float)y);
        }
        return label.getHeight();
    }

    @Override
    public void process(SourceEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.mBandwidth = event.getValue().intValue();
                this.mLabelSizeMonitor.update();
                break;
            }
            case NOTIFICATION_FREQUENCY_CHANGE: {
                this.mFrequency = event.getValue().longValue();
                this.mLabelSizeMonitor.update();
                break;
            }
        }
        this.mVisibleChannels.clear();
        this.mVisibleChannels.addAll(this.mChannelModel.getChannelsInFrequencyRange(this.getMinFrequency(), this.getMaxFrequency()));
        for (Channel trafficChannel : this.mTrafficChannels) {
            if (!trafficChannel.isWithin(this.getMinFrequency(), this.getMaxFrequency())) continue;
            this.mVisibleChannels.add(trafficChannel);
        }
    }

    @Override
    public void receive(ChannelEvent event) {
        Channel channel = event.getChannel();
        switch (event.getEvent()) {
            case NOTIFICATION_ADD: 
            case NOTIFICATION_PROCESSING_START: {
                if (channel.getChannelType() == Channel.ChannelType.TRAFFIC && !this.mTrafficChannels.contains(channel)) {
                    this.mTrafficChannels.add(channel);
                }
                if (this.mVisibleChannels.contains(channel) || !channel.isWithin(this.getMinFrequency(), this.getMaxFrequency())) break;
                this.mVisibleChannels.add(channel);
                break;
            }
            case NOTIFICATION_DELETE: {
                this.mVisibleChannels.remove(channel);
                break;
            }
            case NOTIFICATION_PROCESSING_STOP: 
            case NOTIFICATION_PROCESSING_START_REJECTED: {
                if (channel.getChannelType() != Channel.ChannelType.TRAFFIC) break;
                this.mVisibleChannels.remove(channel);
                this.mTrafficChannels.remove(channel);
                break;
            }
            case NOTIFICATION_CONFIGURATION_CHANGE: {
                if (this.mVisibleChannels.contains(channel) && !channel.isWithin(this.getMinFrequency(), this.getMaxFrequency())) {
                    this.mVisibleChannels.remove(channel);
                }
                if (this.mVisibleChannels.contains(channel) || !channel.isWithin(this.getMinFrequency(), this.getMaxFrequency())) break;
                this.mVisibleChannels.add(channel);
                break;
            }
        }
        this.repaint();
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public long getMinFrequency() {
        return this.mFrequency - (long)(this.mBandwidth / 2);
    }

    public long getMaxFrequency() {
        return this.mFrequency + (long)(this.mBandwidth / 2);
    }

    public boolean containsFrequency(long frequency) {
        return FastMath.abs((long)(this.mFrequency - frequency)) <= (long)(this.mBandwidth / 2);
    }

    private long getMinDisplayFrequency() {
        double bandwidthPerBin = (double)this.mBandwidth / (double)this.mDFTSize.getSize();
        return this.getMinFrequency() + (long)((int)((double)this.mDFTZoomWindowOffset * bandwidthPerBin));
    }

    private long getMaxDisplayFrequency() {
        return this.getMinDisplayFrequency() + (long)this.getDisplayBandwidth();
    }

    private int getDisplayBandwidth() {
        if (this.mZoom != 0) {
            return this.mBandwidth / (int)FastMath.pow((double)2.0, (int)this.mZoom);
        }
        return this.mBandwidth;
    }

    public ArrayList<Channel> getChannelsAtFrequency(long frequency) {
        ArrayList<Channel> configs = new ArrayList<Channel>();
        for (Channel config : this.mVisibleChannels) {
            TunerChannel channel = config.getTunerChannel();
            if (channel == null || channel.getMinFrequency() > frequency || channel.getMaxFrequency() < frequency) continue;
            configs.add(config);
        }
        return configs;
    }

    @Override
    public void settingDeleted(Setting setting) {
    }

    static {
        RENDERING_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        DASHED_STROKE = new BasicStroke(0.8f, 0, 0, 5.0f, new float[]{2.0f, 4.0f}, 0.0f);
        CURSOR_FORMAT = new DecimalFormat("000.00000");
    }

    public static enum ChannelDisplay {
        ALL,
        ENABLED,
        NONE;

    }

    public class LabelSizeManager
    implements ComponentListener {
        private static final double LABEL_FILL_THRESHOLD = 0.5;
        private DecimalFormat mFrequencyFormat = new DecimalFormat("0.0");
        private boolean mUpdateRequired = true;
        private int mLabelIncrement = 1;
        private int mMajorTickIncrement = 1;
        private int mMinorTickIncrement = 1;

        public String format(long frequency) {
            return this.mFrequencyFormat.format((double)frequency / 1000000.0);
        }

        private void setPrecision(int precision) {
            if (precision < 1) {
                precision = 1;
            }
            if (precision > 5) {
                precision = 5;
            }
            this.mFrequencyFormat.setMinimumFractionDigits(precision);
            this.mFrequencyFormat.setMaximumFractionDigits(precision);
        }

        private void update(Graphics2D graphics) {
            if (this.mUpdateRequired) {
                this.setPrecision(5);
                FontMetrics fontMetrics = graphics.getFontMetrics(OverlayPanel.this.getFont());
                int maxLabelWidth = fontMetrics.stringWidth(this.format(OverlayPanel.this.getMaxDisplayFrequency()));
                double maxLabels = (double)OverlayPanel.this.getWidth() * 0.5 / (double)maxLabelWidth;
                int power = (int)FastMath.log10((double)((double)OverlayPanel.this.getDisplayBandwidth() / maxLabels));
                int precision = 5 - power;
                int start = (int)FastMath.pow((double)10.0, (int)(power + 1));
                int minimum = (int)FastMath.pow((double)10.0, (int)power);
                int labelIncrement = start;
                while ((double)OverlayPanel.this.getDisplayBandwidth() / (double)labelIncrement < maxLabels && labelIncrement >= minimum) {
                    labelIncrement /= 2;
                    ++precision;
                }
                if (labelIncrement == minimum) {
                    precision = 5 - power;
                }
                this.setPrecision(precision);
                this.mLabelIncrement = labelIncrement;
                this.mMajorTickIncrement = labelIncrement / 2;
                this.mMinorTickIncrement = labelIncrement / 10;
                this.mUpdateRequired = false;
            }
        }

        public void update() {
            this.mUpdateRequired = true;
        }

        public int getMajorTickIncrement(Graphics2D graphics) {
            this.update(graphics);
            return this.mMajorTickIncrement;
        }

        public int getMinorTickIncrement(Graphics2D graphics) {
            return this.mMinorTickIncrement;
        }

        public int getLabelIncrement(Graphics2D graphics) {
            return this.mLabelIncrement;
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
            this.update();
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }
}

