/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;

public class NativeBufferManager<T extends INativeBuffer> {
    private LinkedTransferQueue<T> mTransferQueue = new LinkedTransferQueue();
    private List<T> mProducerQueue = new ArrayList<T>();
    private List<T> mConsumerQueue = new ArrayList<T>();
    private int mRequestSize;
    private int mProducerAvailable;

    public NativeBufferManager(int estimatedRequestSize) {
        this.mRequestSize = estimatedRequestSize;
    }

    public void add(T nativeBuffer) {
        if (this.mProducerAvailable >= this.mRequestSize && this.mTransferQueue.isEmpty()) {
            this.mTransferQueue.addAll(this.mProducerQueue);
            this.mProducerQueue.clear();
            this.mProducerAvailable = 0;
        }
        if (this.mProducerAvailable < this.mRequestSize) {
            this.mProducerQueue.add(nativeBuffer);
            this.mProducerAvailable += nativeBuffer.sampleCount();
        }
    }

    public void clear() {
        this.mTransferQueue.clear();
        this.mProducerQueue.clear();
        this.mConsumerQueue.clear();
    }

    public float[] get(int requestedSamples) throws IOException {
        if (requestedSamples != this.mRequestSize) {
            this.mRequestSize = requestedSamples;
        }
        ArrayList drained = new ArrayList();
        this.mTransferQueue.drainTo(drained);
        this.mConsumerQueue.addAll(drained);
        int count = 0;
        for (INativeBuffer buffer : this.mConsumerQueue) {
            count += buffer.sampleCount();
        }
        if (count < requestedSamples) {
            throw new IOException("Insufficient samples.  Please try again later");
        }
        float[] samples = new float[requestedSamples * 2];
        int samplesPointer = 0;
        for (INativeBuffer buffer : this.mConsumerQueue) {
            Iterator<InterleavedComplexSamples> iterator = buffer.iteratorInterleaved();
            while (iterator.hasNext() && samplesPointer < samples.length) {
                InterleavedComplexSamples complexSamples = iterator.next();
                int toCopy = Math.min(samples.length - samplesPointer, complexSamples.samples().length);
                System.arraycopy(complexSamples.samples(), 0, samples, samplesPointer, toCopy);
                samplesPointer += toCopy;
            }
            if (samplesPointer < samples.length) continue;
            break;
        }
        this.mConsumerQueue.clear();
        return samples;
    }
}

