/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.spectrum.DFTSize;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.apache.commons.math3.util.FastMath;

public class FrequencyOverlayPanel
extends JPanel
implements ISourceEventProcessor,
SettingChangeListener {
    private static final long serialVersionUID = 1L;
    private final DecimalFormat PPM_FORMATTER = new DecimalFormat("#.0");
    private static final RenderingHints RENDERING_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static DecimalFormat CURSOR_FORMAT;
    private long mFrequency = 0L;
    private int mBandwidth = 0;
    private int mChannelBandwidth = 0;
    private long mPllTrackingFrequency = 0L;
    private Point mCursorLocation = new Point(0, 0);
    private boolean mCursorVisible = false;
    private DFTSize mDFTSize = DFTSize.FFT04096;
    private Color mColorSpectrumBackground;
    private Color mColorSpectrumCursor;
    private Color mColorSpectrumLine;
    private double mSpectrumInset = 20.0;
    private LabelSizeManager mLabelSizeMonitor = new LabelSizeManager();
    private SettingsManager mSettingsManager;

    public FrequencyOverlayPanel(SettingsManager settingsManager) {
        this.mSettingsManager = settingsManager;
        if (this.mSettingsManager != null) {
            this.mSettingsManager.addListener(this);
        }
        this.addComponentListener(this.mLabelSizeMonitor);
        this.setOpaque(false);
        this.setColors();
    }

    public void setPllTrackingFrequency(long pllTrackingFrequency) {
        this.mPllTrackingFrequency = pllTrackingFrequency;
    }

    public void setChannelBandwidth(int channelBandwidth) {
        this.mChannelBandwidth = channelBandwidth;
    }

    public void dispose() {
        if (this.mSettingsManager != null) {
            this.mSettingsManager.removeListener(this);
        }
        this.mSettingsManager = null;
    }

    public void setDFTSize(DFTSize size) {
        this.mDFTSize = size;
    }

    public void setCursorLocation(Point point) {
        this.mCursorLocation = point;
        this.repaint();
    }

    public void setCursorVisible(boolean visible) {
        this.mCursorVisible = visible;
        this.repaint();
    }

    private void setColors() {
        this.mColorSpectrumCursor = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_CURSOR);
        this.mColorSpectrumLine = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_LINE);
        this.mColorSpectrumBackground = this.getColor(ColorSetting.ColorSettingName.SPECTRUM_BACKGROUND);
    }

    private Color getColor(ColorSetting.ColorSettingName name) {
        ColorSetting setting = this.mSettingsManager.getColorSetting(name);
        return setting.getColor();
    }

    @Override
    public void settingChanged(Setting setting) {
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            switch (colorSetting.getColorSettingName()) {
                case SPECTRUM_BACKGROUND: {
                    this.mColorSpectrumBackground = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_CURSOR: {
                    this.mColorSpectrumCursor = colorSetting.getColor();
                    break;
                }
                case SPECTRUM_LINE: {
                    this.mColorSpectrumLine = colorSetting.getColor();
                    break;
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setBackground(this.mColorSpectrumBackground);
        graphics.setRenderingHints(RENDERING_HINTS);
        this.drawFrequencies(graphics);
        this.drawCursor(graphics);
        this.drawPLL(graphics);
        this.drawChannelBandwidth(graphics);
    }

    private void drawCursor(Graphics2D graphics) {
        if (this.mCursorVisible) {
            this.drawFrequencyLine(graphics, this.mCursorLocation.x, this.mColorSpectrumCursor);
            String frequency = CURSOR_FORMAT.format((double)this.getFrequencyFromAxis(this.mCursorLocation.getX()) / 1000000.0);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            Rectangle2D rect = fontMetrics.getStringBounds(frequency, graphics);
            if ((double)this.mCursorLocation.y > rect.getHeight()) {
                graphics.drawString(frequency, this.mCursorLocation.x + 5, this.mCursorLocation.y);
            }
        }
    }

    private void drawFrequencies(Graphics2D graphics) {
        long minFrequency = this.getMinDisplayFrequency();
        long maxFrequency = this.getMaxDisplayFrequency();
        int label = this.mLabelSizeMonitor.getLabelIncrement(graphics);
        int major = this.mLabelSizeMonitor.getMajorTickIncrement(graphics);
        int minor = this.mLabelSizeMonitor.getMinorTickIncrement(graphics);
        if (minor == 0) {
            minor = 1;
        }
        if (label == 0) {
            label = 1;
        }
        for (long frequency = minFrequency - minFrequency % (long)minor; frequency < maxFrequency; frequency += (long)minor) {
            if (frequency % (long)label == 0L) {
                this.drawFrequencyLineAndLabel(graphics, frequency);
                continue;
            }
            if (frequency % (long)major == 0L) {
                this.drawTickLine(graphics, frequency, true);
                continue;
            }
            this.drawTickLine(graphics, frequency, false);
        }
    }

    private void drawFrequencyLineAndLabel(Graphics2D graphics, long frequency) {
        double xAxis = this.getAxisFromFrequency(frequency);
        this.drawFrequencyLine(graphics, xAxis, this.mColorSpectrumLine);
        this.drawTickLine(graphics, frequency, false);
        graphics.setColor(this.mColorSpectrumLine);
        this.drawFrequencyLabel(graphics, xAxis, frequency);
    }

    private void drawTickLine(Graphics2D graphics, long frequency, boolean major) {
        graphics.setColor(this.mColorSpectrumLine);
        double xAxis = this.getAxisFromFrequency(frequency);
        double start = this.getSize().getHeight() - this.mSpectrumInset;
        double end = start + (major ? 9.0 : 3.0);
        graphics.draw(new Line2D.Double(xAxis, start, xAxis, end));
    }

    private void drawFrequencyLine(Graphics2D graphics, double xaxis, Color color) {
        graphics.setColor(color);
        graphics.draw(new Line2D.Double(xaxis, 0.0, xaxis, this.getSize().getHeight() - this.mSpectrumInset));
    }

    private void drawChannelCenterLine(Graphics2D graphics, double xaxis) {
        double height = this.getSize().getHeight() - this.mSpectrumInset;
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.draw(new Line2D.Double(xaxis, height * 0.65, xaxis, height - 1.0));
    }

    private void drawPLL(Graphics2D graphics) {
        if (this.mPllTrackingFrequency == 0L) {
            return;
        }
        long frequency = this.mFrequency - this.mPllTrackingFrequency;
        double xAxis = this.getAxisFromFrequency(frequency);
        double height = this.getSize().getHeight() - this.mSpectrumInset;
        double verticalAxisTop = height * 0.02;
        double verticalAxisBottom = height * 0.98;
        graphics.setColor(Color.YELLOW);
        graphics.draw(new Line2D.Double(xAxis, verticalAxisTop, xAxis, verticalAxisBottom));
    }

    private void drawChannelBandwidth(Graphics2D graphics) {
        if (this.mChannelBandwidth == 0) {
            return;
        }
        long minFrequency = this.mFrequency - (long)(this.mChannelBandwidth / 2);
        long maxFrequency = this.mFrequency + (long)(this.mChannelBandwidth / 2);
        double height = this.getSize().getHeight() - this.mSpectrumInset;
        double verticalAxisTop = height * 0.8;
        double verticalAxisBottom = height * 0.98;
        double minXAxis = this.getAxisFromFrequency(minFrequency);
        double maxXAxis = this.getAxisFromFrequency(maxFrequency);
        graphics.setColor(Color.GREEN);
        graphics.draw(new Line2D.Double(minXAxis, verticalAxisTop, minXAxis, verticalAxisBottom));
        graphics.draw(new Line2D.Double(maxXAxis, verticalAxisTop, maxXAxis, verticalAxisBottom));
    }

    private double getAxisFromFrequency(long frequency) {
        double screenWidth = this.getSize().getWidth();
        double pixelsPerBin = screenWidth / (double)this.mDFTSize.getSize();
        double pixelOffsetToMinDisplayFrequency = pixelsPerBin * 2.0;
        double frequencyOffset = frequency - this.getMinDisplayFrequency();
        double ratio = frequencyOffset / (double)this.getDisplayBandwidth();
        double screenOffset = screenWidth * ratio;
        return pixelOffsetToMinDisplayFrequency + screenOffset;
    }

    public long getFrequencyFromAxis(double xAxis) {
        double width = this.getSize().getWidth();
        double offset = xAxis / width;
        long frequency = this.getMinDisplayFrequency() + FastMath.round((double)((double)this.getDisplayBandwidth() * offset));
        if (frequency > this.getMaxFrequency()) {
            frequency = this.getMaxFrequency();
        }
        return frequency;
    }

    private void drawFrequencyLabel(Graphics2D graphics, double xaxis, long frequency) {
        String label = this.mLabelSizeMonitor.format(frequency);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, graphics);
        float xOffset = (float)rect.getWidth() / 2.0f;
        graphics.drawString(label, (float)(xaxis - (double)xOffset), (float)(this.getSize().getHeight() - 2.0));
    }

    @Override
    public void process(SourceEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.mBandwidth = event.getValue().intValue();
                this.mLabelSizeMonitor.update();
                break;
            }
            case NOTIFICATION_FREQUENCY_CHANGE: {
                this.mFrequency = event.getValue().longValue();
                this.mLabelSizeMonitor.update();
                break;
            }
        }
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public long getMinFrequency() {
        return this.mFrequency - (long)(this.mBandwidth / 2);
    }

    public long getMaxFrequency() {
        return this.mFrequency + (long)(this.mBandwidth / 2);
    }

    public boolean containsFrequency(long frequency) {
        return FastMath.abs((long)(this.mFrequency - frequency)) <= (long)(this.mBandwidth / 2);
    }

    private long getMinDisplayFrequency() {
        double bandwidthPerBin = (double)this.mBandwidth / (double)this.mDFTSize.getSize();
        return this.getMinFrequency();
    }

    private long getMaxDisplayFrequency() {
        return this.getMinDisplayFrequency() + (long)this.getDisplayBandwidth();
    }

    private int getDisplayBandwidth() {
        return this.mBandwidth;
    }

    @Override
    public void settingDeleted(Setting setting) {
    }

    static {
        RENDERING_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        CURSOR_FORMAT = new DecimalFormat("000.00000");
    }

    public class LabelSizeManager
    implements ComponentListener {
        private static final double LABEL_FILL_THRESHOLD = 0.5;
        private DecimalFormat mFrequencyFormat = new DecimalFormat("0.0");
        private boolean mUpdateRequired = true;
        private int mLabelIncrement = 1;
        private int mMajorTickIncrement = 1;
        private int mMinorTickIncrement = 1;

        public String format(long frequency) {
            return this.mFrequencyFormat.format((double)frequency / 1000000.0);
        }

        private void setPrecision(int precision) {
            if (precision < 1) {
                precision = 1;
            }
            if (precision > 5) {
                precision = 5;
            }
            this.mFrequencyFormat.setMinimumFractionDigits(precision);
            this.mFrequencyFormat.setMaximumFractionDigits(precision);
        }

        private void update(Graphics2D graphics) {
            if (this.mUpdateRequired) {
                this.setPrecision(5);
                FontMetrics fontMetrics = graphics.getFontMetrics(FrequencyOverlayPanel.this.getFont());
                int maxLabelWidth = fontMetrics.stringWidth(this.format(FrequencyOverlayPanel.this.getMaxDisplayFrequency()));
                double maxLabels = (double)FrequencyOverlayPanel.this.getWidth() * 0.5 / (double)maxLabelWidth;
                int power = (int)FastMath.log10((double)((double)FrequencyOverlayPanel.this.getDisplayBandwidth() / maxLabels));
                int precision = 5 - power;
                int start = (int)FastMath.pow((double)10.0, (int)(power + 1));
                int minimum = (int)FastMath.pow((double)10.0, (int)power);
                int labelIncrement = start;
                while ((double)FrequencyOverlayPanel.this.getDisplayBandwidth() / (double)labelIncrement < maxLabels && labelIncrement >= minimum) {
                    labelIncrement /= 2;
                    ++precision;
                }
                if (labelIncrement == minimum) {
                    precision = 5 - power;
                }
                this.setPrecision(precision);
                this.mLabelIncrement = labelIncrement;
                this.mMajorTickIncrement = labelIncrement / 2;
                this.mMinorTickIncrement = labelIncrement / 10;
                this.mUpdateRequired = false;
            }
        }

        public void update() {
            this.mUpdateRequired = true;
        }

        public int getMajorTickIncrement(Graphics2D graphics) {
            this.update(graphics);
            return this.mMajorTickIncrement;
        }

        public int getMinorTickIncrement(Graphics2D graphics) {
            return this.mMinorTickIncrement;
        }

        public int getLabelIncrement(Graphics2D graphics) {
            return this.mLabelIncrement;
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
            this.update();
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }
}

