/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.wave;

import io.github.dsheirer.sample.ConversionUtils;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.SampleType;
import io.github.dsheirer.source.IControllableFileSource;
import io.github.dsheirer.source.IFrameLocationListener;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealWaveSource
extends Source
implements IControllableFileSource,
AutoCloseable {
    private static final Logger mLog = LoggerFactory.getLogger(RealWaveSource.class);
    private IFrameLocationListener mFrameLocationListener;
    private int mBytesPerFrame;
    private int mFrameCounter = 0;
    private long mFrequency = 0L;
    private Listener<float[]> mListener;
    private AudioInputStream mInputStream;
    private File mFile;

    public RealWaveSource(File file) throws IOException {
        this.mFile = file;
    }

    @Override
    public SampleType getSampleType() {
        return SampleType.REAL;
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
    }

    @Override
    public void removeSourceEventListener() {
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return null;
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    @Override
    public void start() {
        try {
            this.open();
        }
        catch (IOException | UnsupportedAudioFileException e) {
            mLog.error("Error starting real wave source", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.close();
        }
        catch (IOException e) {
            mLog.error("Error stopping real wave source", (Throwable)e);
        }
    }

    @Override
    public long getFrameCount() throws IOException {
        return 0L;
    }

    @Override
    public double getSampleRate() {
        if (this.mInputStream != null) {
            return this.mInputStream.getFormat().getSampleRate();
        }
        return 0.0;
    }

    @Override
    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) {
        this.mFrequency = frequency;
    }

    @Override
    public void close() throws IOException {
        if (this.mInputStream == null) {
            throw new IOException("Can't close wave source - was not opened");
        }
        this.mInputStream.close();
        this.mInputStream = null;
    }

    @Override
    public void open() throws IOException, UnsupportedAudioFileException {
        if (this.mInputStream != null) {
            throw new IOException("Can't open wave source - is already opened");
        }
        this.mInputStream = AudioSystem.getAudioInputStream(this.mFile);
        AudioFormat format = this.mInputStream.getFormat();
        this.mBytesPerFrame = format.getFrameSize();
        if (format.getChannels() != 1 || format.getSampleSizeInBits() != 16) {
            throw new IOException("Unsupported Wave Format - EXPECTED: 1 channel 16-bit samples FOUND: " + this.mInputStream.getFormat().getChannels() + " channels " + this.mInputStream.getFormat().getSampleSizeInBits() + "-bit samples");
        }
        this.broadcast(0);
    }

    @Override
    public void next(int frames) throws IOException {
        this.next(frames, true);
    }

    @Override
    public void next(int frames, boolean broadcast) throws IOException {
        if (this.mInputStream != null) {
            byte[] buffer = new byte[this.mBytesPerFrame * frames];
            int samplesRead = this.mInputStream.read(buffer);
            this.mFrameCounter += samplesRead;
            this.broadcast(this.mFrameCounter);
            if (broadcast && this.mListener != null) {
                if (samplesRead < buffer.length) {
                    if (samplesRead == -1) {
                        throw new IOException("End of recording");
                    }
                    buffer = Arrays.copyOf(buffer, samplesRead);
                }
                float[] samples = ConversionUtils.convertFromSigned16BitSamples(buffer);
                this.mListener.receive(samples);
            }
        }
    }

    public void setListener(Listener<float[]> listener) {
        this.mListener = listener;
    }

    public void removeListener(Listener<float[]> listener) {
        this.mListener = null;
    }

    @Override
    public File getFile() {
        return this.mFile;
    }

    private void broadcast(int byteLocation) {
        int frameLocation = byteLocation / this.mBytesPerFrame;
        if (this.mFrameLocationListener != null) {
            this.mFrameLocationListener.frameLocationUpdated(frameLocation);
        }
    }

    @Override
    public void setListener(IFrameLocationListener listener) {
        this.mFrameLocationListener = listener;
    }

    @Override
    public void removeListener(IFrameLocationListener listener) {
        this.mFrameLocationListener = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean supports(File file) {
        try (AudioInputStream ais = AudioSystem.getAudioInputStream(file);){
            AudioFormat format = ais.getFormat();
            if (format.getChannels() != 1) return false;
            if (format.getSampleSizeInBits() != 16) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

