/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.ui;

import com.jidesoft.swing.JideSplitPane;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.swing.JTableColumnWidthMonitor;
import io.github.dsheirer.source.tuner.configuration.TunerConfigurationManager;
import io.github.dsheirer.source.tuner.manager.DiscoveredRecordingTuner;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.source.tuner.recording.AddRecordingTunerDialog;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerEditor;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(TunerViewPanel.class);
    private static final String TABLE_PREFERENCE_KEY = "tuner.view.panel";
    private UserPreferences mUserPreferences;
    private DiscoveredTunerModel mDiscoveredTunerModel;
    private DiscoveredTunerEditor mDiscoveredTunerEditor;
    private TunerConfigurationManager mTunerConfigurationManager;
    private JTable mTunerTable;
    private JTableColumnWidthMonitor mColumnWidthMonitor;
    private TableRowSorter<DiscoveredTunerModel> mRowSorter;
    private JideSplitPane mSplitPane;
    private JButton mAddRecordingButton;
    private JButton mRemoveRecordingButton;

    public TunerViewPanel(TunerManager tunerManager, UserPreferences userPreferences) {
        this.mDiscoveredTunerModel = tunerManager.getDiscoveredTunerModel();
        this.mDiscoveredTunerEditor = new DiscoveredTunerEditor(userPreferences, tunerManager);
        this.mTunerConfigurationManager = tunerManager.getTunerConfigurationManager();
        this.mUserPreferences = userPreferences;
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[fill,grow]", "[fill,grow]"));
        this.mRowSorter = new TableRowSorter<DiscoveredTunerModel>(this.mDiscoveredTunerModel);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        this.mRowSorter.setSortKeys(sortKeys);
        this.mTunerTable = new JTable(this.mDiscoveredTunerModel);
        this.mTunerTable.setRowSorter(this.mRowSorter);
        this.mTunerTable.setSelectionMode(0);
        this.mTunerTable.getSelectionModel().addListSelectionListener(event -> {
            int row;
            this.getRemoveRecordingButton().setEnabled(false);
            if (!event.getValueIsAdjusting() && (row = this.mTunerTable.getSelectedRow()) >= 0) {
                int modelRow = this.mTunerTable.convertRowIndexToModel(row);
                DiscoveredTuner selected = this.mDiscoveredTunerModel.getDiscoveredTuner(modelRow);
                this.mDiscoveredTunerEditor.setItem(selected);
                this.getRemoveRecordingButton().setEnabled(selected instanceof DiscoveredRecordingTuner);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem logStateMenuItem = new JMenuItem("Log Tuner State");
        logStateMenuItem.addActionListener(e -> {
            int viewRow = this.mTunerTable.getSelectedRow();
            DiscoveredTuner selected = null;
            if (viewRow >= 0) {
                int modelRow = this.mTunerTable.convertRowIndexToModel(viewRow);
                selected = this.mDiscoveredTunerModel.getDiscoveredTuner(modelRow);
            }
            if (selected != null) {
                selected.logState();
            } else {
                mLog.error("Can't log state - tuner not selected");
            }
        });
        popupMenu.add(logStateMenuItem);
        this.mTunerTable.setComponentPopupMenu(popupMenu);
        this.mDiscoveredTunerModel.addTableModelListener(e -> {
            if (e.getType() == -1 && this.mDiscoveredTunerEditor.hasItem() && !this.mDiscoveredTunerModel.hasTuner((DiscoveredTuner)this.mDiscoveredTunerEditor.getItem())) {
                this.mDiscoveredTunerEditor.setItem(null);
            }
        });
        this.mDiscoveredTunerModel.addListener(tunerEvent -> {
            switch (tunerEvent.getEvent()) {
                case UPDATE_LOCK_STATE: {
                    int modelRow;
                    DiscoveredTuner selectedTuner;
                    int row;
                    if (tunerEvent.getTuner() == null || (row = this.mTunerTable.getSelectedRow()) < 0 || (selectedTuner = this.mDiscoveredTunerModel.getDiscoveredTuner(modelRow = this.mTunerTable.convertRowIndexToModel(row))) == null || !selectedTuner.hasTuner() || tunerEvent.getTuner() != selectedTuner.getTuner()) break;
                    this.mDiscoveredTunerEditor.setTunerLockState(selectedTuner.getTuner().getTunerController().isLockedSampleRate());
                }
            }
        });
        TunerStatusCellRenderer errorCellRenderer = new TunerStatusCellRenderer();
        this.mTunerTable.getColumnModel().getColumn(0).setCellRenderer(errorCellRenderer);
        this.mColumnWidthMonitor = new JTableColumnWidthMonitor(this.mUserPreferences, this.mTunerTable, TABLE_PREFERENCE_KEY);
        JScrollPane tunerTableScroller = new JScrollPane(this.mTunerTable);
        JPanel tunerTablePanel = new JPanel();
        tunerTablePanel.setLayout((LayoutManager)new MigLayout("insets 0", "[fill,grow,align center]", "[fill,grow][]"));
        tunerTablePanel.add((Component)tunerTableScroller, "span");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new MigLayout("insets 0 1 3 0", "", ""));
        buttonPanel.add(this.getAddRecordingButton());
        buttonPanel.add(this.getRemoveRecordingButton());
        tunerTablePanel.add(buttonPanel);
        tunerTablePanel.setPreferredSize(new Dimension(200, 200));
        JScrollPane editorScroller = new JScrollPane(this.mDiscoveredTunerEditor);
        editorScroller.setPreferredSize(new Dimension(200, 200));
        this.mSplitPane = new JideSplitPane();
        this.mSplitPane.setOrientation(1);
        this.mSplitPane.add((Component)tunerTablePanel);
        this.mSplitPane.add((Component)editorScroller);
        this.mSplitPane.setProportionalLayout(true);
        this.mSplitPane.setProportions(new double[]{0.5});
        this.add((Component)this.mSplitPane);
    }

    private JButton getAddRecordingButton() {
        if (this.mAddRecordingButton == null) {
            this.mAddRecordingButton = new JButton("Add Recording Tuner");
            this.mAddRecordingButton.addActionListener(e -> {
                AddRecordingTunerDialog dialog = new AddRecordingTunerDialog(this.mUserPreferences, this.mDiscoveredTunerModel, this.mTunerConfigurationManager);
                dialog.setLocationRelativeTo(this);
                EventQueue.invokeLater(() -> dialog.setVisible(true));
            });
        }
        return this.mAddRecordingButton;
    }

    private JButton getRemoveRecordingButton() {
        if (this.mRemoveRecordingButton == null) {
            this.mRemoveRecordingButton = new JButton("Remove Recording Tuner");
            this.mRemoveRecordingButton.setEnabled(false);
            this.mRemoveRecordingButton.addActionListener(e -> {
                int modelIndex;
                DiscoveredTuner selected;
                int[] indexes = this.mTunerTable.getSelectionModel().getSelectedIndices();
                if (indexes.length == 1 && (selected = this.mDiscoveredTunerModel.getDiscoveredTuner(modelIndex = this.mTunerTable.convertRowIndexToModel(indexes[0]))) instanceof DiscoveredRecordingTuner) {
                    DiscoveredRecordingTuner discoveredRecordingTuner = (DiscoveredRecordingTuner)selected;
                    mLog.info("Removing Tuner: " + String.valueOf(discoveredRecordingTuner));
                    discoveredRecordingTuner.stop();
                    this.mTunerConfigurationManager.removeTunerConfiguration(discoveredRecordingTuner.getTunerConfiguration());
                    EventQueue.invokeLater(() -> this.mDiscoveredTunerModel.removeDiscoveredTuner(discoveredRecordingTuner));
                }
            });
        }
        return this.mRemoveRecordingButton;
    }

    public class TunerStatusCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof TunerStatus) {
                TunerStatus tunerStatus = (TunerStatus)((Object)value);
                if (tunerStatus == TunerStatus.ERROR) {
                    component.setForeground(Color.RED);
                } else if (tunerStatus == TunerStatus.DISABLED) {
                    component.setForeground(Color.DARK_GRAY);
                } else {
                    component.setForeground(table.getForeground());
                }
            } else {
                component.setForeground(table.getForeground());
            }
            return component;
        }
    }
}

